import chalk from 'chalk';
import { editAsync } from 'external-editor';
import { createPrompt, useEffect, useState, useKeypress, usePrefix, isEnterKey, } from '@inquirer/core';
export default createPrompt((config, done) => {
    const { waitForUseInput = true, validate = () => true } = config;
    const [status, setStatus] = useState('pending');
    const [value, setValue] = useState(config.default || '');
    const [errorMsg, setError] = useState(undefined);
    function startEditor(rl) {
        rl.pause();
        editAsync(value, async (error, answer) => {
            rl.resume();
            if (error) {
                setError(error.toString());
            }
            else {
                setStatus('loading');
                const isValid = await validate(answer);
                if (isValid === true) {
                    setError(undefined);
                    setStatus('done');
                    done(answer);
                }
                else {
                    setValue(answer);
                    setError(isValid || 'You must provide a valid value');
                    setStatus('pending');
                }
            }
        }, {
            postfix: config.postfix || '.txt',
        });
    }
    useEffect((rl) => {
        if (!waitForUseInput) {
            startEditor(rl);
        }
    }, []);
    useKeypress((key, rl) => {
        // Ignore keypress while our prompt is doing other processing.
        if (status !== 'pending') {
            return;
        }
        if (isEnterKey(key)) {
            startEditor(rl);
        }
    });
    const isLoading = status === 'loading';
    const prefix = usePrefix(isLoading);
    const message = chalk.bold(config.message);
    let helpTip;
    if (status === 'loading') {
        helpTip = chalk.dim('Received');
    }
    else if (status === 'pending') {
        helpTip = chalk.dim('Press <enter> to launch your preferred editor.');
    }
    let error = '';
    if (errorMsg) {
        error = chalk.red(`> ${errorMsg}`);
    }
    return [[prefix, message, helpTip].filter(Boolean).join(' '), error];
});
