"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const chalk_1 = __importDefault(require("chalk"));
const external_editor_1 = require("external-editor");
const core_1 = require("@inquirer/core");
exports.default = (0, core_1.createPrompt)((config, done) => {
    const { waitForUseInput = true, validate = () => true } = config;
    const [status, setStatus] = (0, core_1.useState)('pending');
    const [value, setValue] = (0, core_1.useState)(config.default || '');
    const [errorMsg, setError] = (0, core_1.useState)(undefined);
    function startEditor(rl) {
        rl.pause();
        (0, external_editor_1.editAsync)(value, (error, answer) => __awaiter(this, void 0, void 0, function* () {
            rl.resume();
            if (error) {
                setError(error.toString());
            }
            else {
                setStatus('loading');
                const isValid = yield validate(answer);
                if (isValid === true) {
                    setError(undefined);
                    setStatus('done');
                    done(answer);
                }
                else {
                    setValue(answer);
                    setError(isValid || 'You must provide a valid value');
                    setStatus('pending');
                }
            }
        }), {
            postfix: config.postfix || '.txt',
        });
    }
    (0, core_1.useEffect)((rl) => {
        if (!waitForUseInput) {
            startEditor(rl);
        }
    }, []);
    (0, core_1.useKeypress)((key, rl) => {
        // Ignore keypress while our prompt is doing other processing.
        if (status !== 'pending') {
            return;
        }
        if ((0, core_1.isEnterKey)(key)) {
            startEditor(rl);
        }
    });
    const isLoading = status === 'loading';
    const prefix = (0, core_1.usePrefix)(isLoading);
    const message = chalk_1.default.bold(config.message);
    let helpTip;
    if (status === 'loading') {
        helpTip = chalk_1.default.dim('Received');
    }
    else if (status === 'pending') {
        helpTip = chalk_1.default.dim('Press <enter> to launch your preferred editor.');
    }
    let error = '';
    if (errorMsg) {
        error = chalk_1.default.red(`> ${errorMsg}`);
    }
    return [[prefix, message, helpTip].filter(Boolean).join(' '), error];
});
