import { type Prettify } from '@inquirer/type';
import { type Layout } from './lines.js';
export declare function usePagination<T>({ items, active, renderItem, pageSize, loop, }: {
    items: readonly T[];
    /** The index of the active item. */
    active: number;
    /** Renders an item as part of a page. */
    renderItem: (layout: Prettify<Layout<T>>) => string;
    /** The size of the page. */
    pageSize: number;
    /** Allows creating an infinitely looping list. `true` if unspecified. */
    loop?: boolean;
}): string;
