import { useRef } from './use-ref.mjs';
import { useEffect } from './use-effect.mjs';
import { withUpdates } from './hook-engine.mjs';
export function useKeypress(userHandler) {
    const signal = useRef(userHandler);
    signal.current = userHandler;
    useEffect((rl) => {
        const handler = withUpdates((_input, event) => {
            signal.current(event, rl);
        });
        rl.input.on('keypress', handler);
        return () => {
            rl.input.removeListener('keypress', handler);
        };
    }, []);
}
