"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.Separator = void 0;
const core_1 = require("@inquirer/core");
Object.defineProperty(exports, "Separator", { enumerable: true, get: function () { return core_1.Separator; } });
const chalk_1 = __importDefault(require("chalk"));
const figures_1 = __importDefault(require("figures"));
const ansi_escapes_1 = __importDefault(require("ansi-escapes"));
function isSelectable(item) {
    return !core_1.Separator.isSeparator(item) && !item.disabled;
}
function isChecked(item) {
    return isSelectable(item) && Boolean(item.checked);
}
function toggle(item) {
    return isSelectable(item) ? Object.assign(Object.assign({}, item), { checked: !item.checked }) : item;
}
function check(checked) {
    return function (item) {
        return isSelectable(item) ? Object.assign(Object.assign({}, item), { checked }) : item;
    };
}
function renderItem({ item, isActive }) {
    if (core_1.Separator.isSeparator(item)) {
        return ` ${item.separator}`;
    }
    const line = item.name || item.value;
    if (item.disabled) {
        const disabledLabel = typeof item.disabled === 'string' ? item.disabled : '(disabled)';
        return chalk_1.default.dim(`- ${line} ${disabledLabel}`);
    }
    const checkbox = item.checked ? chalk_1.default.green(figures_1.default.circleFilled) : figures_1.default.circle;
    const color = isActive ? chalk_1.default.cyan : (x) => x;
    const prefix = isActive ? figures_1.default.pointer : ' ';
    return color(`${prefix}${checkbox} ${line}`);
}
exports.default = (0, core_1.createPrompt)((config, done) => {
    const { prefix = (0, core_1.usePrefix)(), instructions, pageSize = 7, loop = true, choices, required, validate = () => true, } = config;
    const [status, setStatus] = (0, core_1.useState)('pending');
    const [items, setItems] = (0, core_1.useState)(choices.map((choice) => (Object.assign({}, choice))));
    const bounds = (0, core_1.useMemo)(() => {
        const first = items.findIndex(isSelectable);
        // TODO: Replace with `findLastIndex` when it's available.
        const last = items.length - 1 - [...items].reverse().findIndex(isSelectable);
        if (first < 0) {
            throw new Error('[checkbox prompt] No selectable choices. All choices are disabled.');
        }
        return { first, last };
    }, [items]);
    const [active, setActive] = (0, core_1.useState)(bounds.first);
    const [showHelpTip, setShowHelpTip] = (0, core_1.useState)(true);
    const [errorMsg, setError] = (0, core_1.useState)(undefined);
    (0, core_1.useKeypress)((key) => __awaiter(void 0, void 0, void 0, function* () {
        if ((0, core_1.isEnterKey)(key)) {
            const selection = items.filter(isChecked);
            const isValid = yield validate([...selection]);
            if (required && !items.some(isChecked)) {
                setError('At least one choice must be selected');
            }
            else if (isValid === true) {
                setStatus('done');
                done(selection.map((choice) => choice.value));
            }
            else {
                setError(isValid || 'You must select a valid value');
            }
        }
        else if ((0, core_1.isUpKey)(key) || (0, core_1.isDownKey)(key)) {
            if (loop ||
                ((0, core_1.isUpKey)(key) && active !== bounds.first) ||
                ((0, core_1.isDownKey)(key) && active !== bounds.last)) {
                const offset = (0, core_1.isUpKey)(key) ? -1 : 1;
                let next = active;
                do {
                    next = (next + offset + items.length) % items.length;
                } while (!isSelectable(items[next]));
                setActive(next);
            }
        }
        else if ((0, core_1.isSpaceKey)(key)) {
            setError(undefined);
            setShowHelpTip(false);
            setItems(items.map((choice, i) => (i === active ? toggle(choice) : choice)));
        }
        else if (key.name === 'a') {
            const selectAll = Boolean(items.find((choice) => isSelectable(choice) && !choice.checked));
            setItems(items.map(check(selectAll)));
        }
        else if (key.name === 'i') {
            setItems(items.map(toggle));
        }
        else if ((0, core_1.isNumberKey)(key)) {
            // Adjust index to start at 1
            const position = Number(key.name) - 1;
            const item = items[position];
            if (item != null && isSelectable(item)) {
                setActive(position);
                setItems(items.map((choice, i) => (i === position ? toggle(choice) : choice)));
            }
        }
    }));
    const message = chalk_1.default.bold(config.message);
    const page = (0, core_1.usePagination)({
        items,
        active,
        renderItem,
        pageSize,
        loop,
    });
    if (status === 'done') {
        const selection = items
            .filter(isChecked)
            .map((choice) => choice.name || choice.value);
        return `${prefix} ${message} ${chalk_1.default.cyan(selection.join(', '))}`;
    }
    let helpTip = '';
    if (showHelpTip && (instructions === undefined || instructions)) {
        if (typeof instructions === 'string') {
            helpTip = instructions;
        }
        else {
            const keys = [
                `${chalk_1.default.cyan.bold('<space>')} to select`,
                `${chalk_1.default.cyan.bold('<a>')} to toggle all`,
                `${chalk_1.default.cyan.bold('<i>')} to invert selection`,
                `and ${chalk_1.default.cyan.bold('<enter>')} to proceed`,
            ];
            helpTip = ` (Press ${keys.join(', ')})`;
        }
    }
    let error = '';
    if (errorMsg) {
        error = chalk_1.default.red(`> ${errorMsg}`);
    }
    return `${prefix} ${message}${helpTip}\n${page}\n${error}${ansi_escapes_1.default.cursorHide}`;
});
