"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.exec = exports.withTempDir = void 0;
const child_process_1 = require("child_process");
const fs = __importStar(require("fs-extra"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
async function withTempDir(dirname, closure) {
    const prevdir = process.cwd();
    const parent = await fs.mkdtemp(path.join(os.tmpdir(), "cdktf."));
    const workdir = path.join(parent, dirname);
    await fs.mkdirp(workdir);
    try {
        process.chdir(workdir);
        await closure();
    }
    finally {
        process.chdir(prevdir);
        await fs.remove(parent);
    }
}
exports.withTempDir = withTempDir;
const exec = async (command, args, options, stdout, stderr) => {
    return new Promise((ok, ko) => {
        var _a, _b, _c, _d;
        const child = (0, child_process_1.spawn)(command, args, options);
        const out = new Array();
        const err = new Array();
        if (stdout !== undefined) {
            (_a = child.stdout) === null || _a === void 0 ? void 0 : _a.on("data", (chunk) => {
                stdout(chunk);
            });
        }
        else {
            (_b = child.stdout) === null || _b === void 0 ? void 0 : _b.on("data", (chunk) => {
                out.push(chunk);
            });
        }
        if (stderr !== undefined) {
            (_c = child.stderr) === null || _c === void 0 ? void 0 : _c.on("data", (chunk) => {
                stderr(chunk);
            });
        }
        else {
            (_d = child.stderr) === null || _d === void 0 ? void 0 : _d.on("data", (chunk) => {
                process.stderr.write(chunk);
                err.push(chunk);
            });
        }
        child.once("error", (err) => ko(err));
        child.once("close", (code) => {
            if (code !== 0) {
                const error = new Error(`non-zero exit code ${code}`);
                error.stderr = err.map((chunk) => chunk.toString()).join("");
                return ko(error);
            }
            return ok(Buffer.concat(out).toString("utf-8"));
        });
    });
};
exports.exec = exec;
//# sourceMappingURL=data:application/json;base64,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