"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readSchema = exports.isLocalModule = exports.TerraformProviderConstraint = exports.TerraformModuleConstraint = exports.isRegistryModule = void 0;
var commons_1 = require("@cdktf/commons");
Object.defineProperty(exports, "isRegistryModule", { enumerable: true, get: function () { return commons_1.isRegistryModule; } });
Object.defineProperty(exports, "TerraformModuleConstraint", { enumerable: true, get: function () { return commons_1.TerraformModuleConstraint; } });
Object.defineProperty(exports, "TerraformProviderConstraint", { enumerable: true, get: function () { return commons_1.TerraformProviderConstraint; } });
Object.defineProperty(exports, "isLocalModule", { enumerable: true, get: function () { return commons_1.isLocalModule; } });
const commons_2 = require("@cdktf/commons");
const deepmerge_1 = __importDefault(require("deepmerge"));
const provider_schema_1 = require("./provider-schema");
const cache_1 = require("./cache");
async function readSchema(constraints, cacheDir) {
    const cachedReadProviderSchema = (0, cache_1.cachedAccess)(provider_schema_1.readProviderSchema, cacheDir);
    const targets = constraints.map((constraint) => commons_2.ConstructsMakerProviderTarget.from(constraint, commons_2.LANGUAGES[0]));
    throwIfTargetsConflict(targets);
    const schemas = await Promise.all(targets.map((t) => t.isModule
        ? (0, provider_schema_1.readModuleSchema)(t).then((s) => ({ moduleSchema: s }))
        : cachedReadProviderSchema(t).then((s) => ({ providerSchema: s }))));
    // ensure we have a schema for each target type
    schemas.unshift({
        providerSchema: {
            format_version: "0.1",
        },
        moduleSchema: {},
    });
    return deepmerge_1.default.all(schemas);
}
exports.readSchema = readSchema;
function throwIfTargetsConflict(targets) {
    const modules = targets.filter((t) => t.isModule);
    modules.forEach((moduleA) => {
        modules.forEach((moduleB) => {
            if (moduleA !== moduleB && moduleA.name === moduleB.name) {
                throw commons_2.Errors.Usage(`Found two modules with the same name "${moduleA.name}" which is not supported. Please rename one of the modules in your cdktf.json config. For more information on how to set the name refer to https://cdk.tf/adding-modules`);
            }
        });
    });
}
//# sourceMappingURL=data:application/json;base64,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