"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.readModuleSchema = exports.sanitizeProviderSchema = exports.readProviderSchema = exports.parseFQPN = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const hcl2json_1 = require("@cdktf/hcl2json");
const commons_1 = require("@cdktf/commons");
const terraformBinaryName = process.env.TERRAFORM_BINARY_NAME || "terraform";
const parseFQPN = (f) => {
    const [hostname, namespace, name] = f.split("/");
    if (!name) {
        throw new Error(`can't handle ${f}`);
    }
    return { hostname, namespace, name };
};
exports.parseFQPN = parseFQPN;
const unwrapIfArray = (item) => Array.isArray(item) ? item[0] : item;
const transformVariables = (variables) => {
    var _a;
    const result = [];
    if (!variables)
        return result;
    for (const name of Object.keys(variables)) {
        const variable = unwrapIfArray(variables[name]);
        let variableType;
        if (
        // eslint-disable-next-line no-prototype-builtins
        variable.hasOwnProperty("type") == false &&
            // eslint-disable-next-line no-prototype-builtins
            variable.hasOwnProperty("default") == true) {
            switch (typeof variable["default"]) {
                case "boolean":
                    variableType = "bool";
                    break;
                case "number":
                    variableType = "number";
                    break;
                default:
                    variableType = "any";
            }
        }
        else {
            const matched = (_a = variable["type"]) === null || _a === void 0 ? void 0 : _a.match(/\$\{(.*)\}/);
            variableType = matched ? matched[1] : "any";
        }
        const item = {
            name,
            type: variableType,
            description: variable["description"],
            // eslint-disable-next-line no-prototype-builtins
            required: variable.hasOwnProperty("default") == false,
        };
        if (!item.required) {
            item["default"] = variable["default"];
        }
        result.push(item);
    }
    return result;
};
const transformOutputs = (outputs) => {
    const result = [];
    if (outputs) {
        for (const name of Object.keys(outputs)) {
            const output = unwrapIfArray(outputs[name]);
            const item = {
                name,
                description: output["description"],
            };
            result.push(item);
        }
    }
    return result;
};
const harvestModuleSchema = async (workingDirectory, modules) => {
    const fileName = path.join(workingDirectory, ".terraform", "modules", "modules.json");
    const result = {};
    if (!fs.existsSync(fileName)) {
        throw new Error(`Modules were not generated properly - couldn't find ${fileName}`);
    }
    const moduleIndex = JSON.parse(fs.readFileSync(fileName, "utf-8"));
    for (const mod of modules) {
        const m = moduleIndex.Modules.find((other) => mod === other.Key);
        if (!m) {
            throw new Error(`Couldn't find ${m}`);
        }
        const parsed = await (0, hcl2json_1.convertFiles)(path.join(workingDirectory, m.Dir));
        if (!parsed) {
            throw new Error(`Modules were not generated properly - couldn't parse ${m.Dir}`);
        }
        const schema = {
            inputs: transformVariables(parsed.variable),
            outputs: transformOutputs(parsed.output),
            name: mod,
        };
        result[mod] = schema;
    }
    return result;
};
async function readProviderSchema(target) {
    const config = {
        provider: {},
        terraform: {
            required_providers: {},
        },
    };
    config.provider[target.name] = {};
    config.terraform.required_providers[target.name] = {
        version: target.version,
        source: target.source,
    };
    let providerSchema = { format_version: "0.1" };
    await (0, commons_1.withTempDir)("fetchProviderSchema", async () => {
        const outdir = process.cwd();
        const filePath = path.join(outdir, "main.tf.json");
        await fs.writeFile(filePath, JSON.stringify(config));
        await (0, commons_1.exec)(terraformBinaryName, ["init"], { cwd: outdir });
        providerSchema = JSON.parse(await (0, commons_1.exec)(terraformBinaryName, ["providers", "schema", "-json"], {
            cwd: outdir,
        }));
        const versionSchema = JSON.parse(await (0, commons_1.exec)(terraformBinaryName, ["version", "-json"], {
            cwd: outdir,
        }));
        providerSchema.provider_versions = versionSchema.provider_selections;
    });
    return sanitizeProviderSchema(providerSchema);
}
exports.readProviderSchema = readProviderSchema;
// The providers have some potential bugs that we want to pro-actively
// fix here so that the rest of the code can assume a consistent schema.
function sanitizeProviderSchema(schema) {
    // Mainly some attributes are "doubled", e.g. ["list", "string", "list", "string"]
    // instead of ["list", "string"]
    function attributeDoublingFix(attribute) {
        if ((0, commons_1.isNestedTypeAttribute)(attribute) || !Array.isArray(attribute.type)) {
            return attribute;
        }
        const type = attribute.type.length === 2
            ? attribute.type
            : attribute.type.slice(0, 2); // The types tell us this can't happen, reality begs to differ
        attribute.type = type;
        return attribute;
    }
    // Mutates block with the fix
    function sanitizeBlock(block) {
        Object.values(block.attributes || {}).forEach(attributeDoublingFix);
        Object.values(block.block_types || {}).forEach((blockType) => {
            sanitizeBlock(blockType.block);
        });
    }
    Object.values(schema.provider_schemas || {}).forEach((provider) => {
        const entities = [
            provider.provider,
            ...Object.values(provider.resource_schemas || {}),
            ...Object.values(provider.data_source_schemas || {}),
        ];
        entities.forEach((entity) => {
            sanitizeBlock(entity.block);
        });
    });
    return schema;
}
exports.sanitizeProviderSchema = sanitizeProviderSchema;
async function readModuleSchema(target) {
    let moduleSchema = {};
    await (0, commons_1.withTempDir)("fetchSchema", async () => {
        const config = {
            terraform: {},
        };
        if (!config.module)
            config.module = {};
        let source = target.source;
        const localSource = target.constraint
            .localSourceAbsolutePath;
        if (localSource) {
            // create relative path to module in the user project
            source = path.relative(process.cwd(), localSource);
        }
        config.module[target.moduleKey] = { source: source };
        if (target.version) {
            config.module[target.moduleKey]["version"] = target.version;
        }
        const outdir = process.cwd();
        const filePath = path.join(outdir, "main.tf.json");
        await fs.writeFile(filePath, JSON.stringify(config));
        await (0, commons_1.exec)(terraformBinaryName, ["get"], { cwd: outdir });
        if (config.module) {
            moduleSchema = await harvestModuleSchema(outdir, Object.keys(config.module));
        }
    });
    return moduleSchema;
}
exports.readModuleSchema = readModuleSchema;
//# sourceMappingURL=data:application/json;base64,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