import { ConstructsMakerModuleTarget, ConstructsMakerProviderTarget, ModuleSchema, ProviderSchema } from "@cdktf/commons";
/**
 * Fully Qualified provider name in the format:
 * like e.g. registry.terraform.io/hashicorp/aws
 */
export type FQPN = string & {
    __type: "FullyQualifiedProviderName";
};
export type ProviderHostname = string & {
    __type: "ProviderHostname";
};
export type ProviderNamespace = string & {
    __type: "ProviderNamespace";
};
export type ProviderName = string & {
    __type: "ProviderName";
};
export declare const parseFQPN: (f: FQPN) => {
    hostname: ProviderHostname;
    namespace: ProviderNamespace;
    name: ProviderName;
};
export interface TerraformConfig {
    provider?: {
        [name: string]: Record<string, any>;
    };
    terraform: {
        required_providers?: {
            [name: string]: {
                source?: string;
                version?: string;
            };
        };
    };
    module?: {
        [name: string]: {
            source: string;
            version?: string;
        };
    };
}
export declare function readProviderSchema(target: ConstructsMakerProviderTarget): Promise<ProviderSchema>;
export declare function sanitizeProviderSchema(schema: ProviderSchema): ProviderSchema;
export declare function readModuleSchema(target: ConstructsMakerModuleTarget): Promise<Record<string, ModuleSchema>>;
//# sourceMappingURL=provider-schema.d.ts.map