"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.cachedAccess = void 0;
const commons_1 = require("@cdktf/commons");
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
// We keep this very simple since the caching feature is experimental
// we might need to do housekeeping / include terraform / cdktf version in the future
function cacheKey(input) {
    return `${encodeURIComponent(input.fqn)}@${encodeURIComponent(input.version || "")}`;
}
function cachedAccess(producer, cacheDir) {
    const cacheEnabled = typeof cacheDir === "string" && cacheDir.length > 0;
    if (cacheEnabled && !fs.lstatSync(cacheDir).isDirectory()) {
        throw commons_1.Errors.Usage(`Provider Schema Cache directory '${cacheDir}' is not a directory`);
    }
    if (!cacheEnabled) {
        commons_1.logger.debug(`Provider Schema Cache disabled`);
        return (input) => {
            return producer(input);
        };
    }
    commons_1.logger.debug(`Provider Schema Cache enabled, caching at ${cacheDir}`);
    return async (input) => {
        const key = cacheKey(input);
        const cachePath = path.join(cacheDir, `${key}.json`);
        if (fs.existsSync(cachePath)) {
            commons_1.logger.debug(`Cache hit for ${key}`);
            return JSON.parse(await fs.readFile(cachePath, "utf-8"));
        }
        commons_1.logger.debug(`Cache miss for ${key}, generating schema`);
        const result = await producer(input);
        await fs.writeFile(cachePath, JSON.stringify(result));
        commons_1.logger.debug(`Write cache for ${key}`);
        return result;
    };
}
exports.cachedAccess = cachedAccess;
//# sourceMappingURL=data:application/json;base64,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