"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
const path = __importStar(require("path"));
const json_stable_stringify_1 = __importDefault(require("json-stable-stringify"));
const commons_1 = require("@cdktf/commons");
const provider_schema_1 = require("../provider-schema");
function sanitizeJson(value) {
    value["format_version"] = "STUBBED VERSION";
    return (0, json_stable_stringify_1.default)(value, {
        space: 2,
    });
}
describe("readSchema", () => {
    it("generates a single provider schema", async () => {
        const provider = new commons_1.TerraformProviderConstraint("hashicorp/null@3.1.0");
        const target = new commons_1.ConstructsMakerProviderTarget(provider, commons_1.Language.TYPESCRIPT);
        const result = await (0, provider_schema_1.readProviderSchema)(target);
        expect(sanitizeJson(result)).toMatchSnapshot();
    }, 120000);
    it("generates a single module schema", async () => {
        const module = new commons_1.TerraformModuleConstraint("terraform-aws-modules/iam/aws//modules/iam-account@3.12.0");
        const target = new commons_1.ConstructsMakerModuleTarget(module, commons_1.Language.TYPESCRIPT);
        const result = await (0, provider_schema_1.readModuleSchema)(target);
        expect(sanitizeJson(result)).toMatchSnapshot();
    }, 120000);
    it("generates a more complex schema", async () => {
        const module = new commons_1.TerraformModuleConstraint("terraform-aws-modules/eks/aws@7.0.1");
        const target = new commons_1.ConstructsMakerModuleTarget(module, commons_1.Language.TYPESCRIPT);
        const result = await (0, provider_schema_1.readModuleSchema)(target);
        expect(sanitizeJson(result)).toMatchSnapshot();
    }, 120000);
    it("generates a local module", async () => {
        const module = new commons_1.TerraformModuleConstraint({
            name: "local_module",
            fqn: "local_module",
            source: path.resolve(__dirname, "fixtures", "local-module"),
        });
        const target = new commons_1.ConstructsMakerModuleTarget(module, commons_1.Language.TYPESCRIPT);
        const result = await (0, provider_schema_1.readModuleSchema)(target);
        expect(sanitizeJson(result)).toMatchSnapshot();
    }, 120000);
    it("generates a local json module", async () => {
        const module = new commons_1.TerraformModuleConstraint({
            name: "local_module",
            fqn: "local_module",
            source: path.resolve(__dirname, "fixtures", "local-json-module"),
        });
        const target = new commons_1.ConstructsMakerModuleTarget(module, commons_1.Language.TYPESCRIPT);
        const result = await (0, provider_schema_1.readModuleSchema)(target);
        expect(sanitizeJson(result)).toMatchSnapshot();
    }, 120000);
});
describe("sanitizeProviderSchema", () => {
    it("sanitizes a provider schema", () => {
        const schema = {
            format_version: "0.1",
            provider_versions: {
                "registry.terraform.io/hashicorp/null": "3.1.0",
            },
            provider_schemas: {
                "registry.terraform.io/hashicorp/null": {
                    provider: {
                        version: 0,
                        block: {
                            attributes: {
                                version: {
                                    type: "string",
                                    required: true,
                                },
                                correct: {
                                    type: ["list", "string"],
                                },
                                incorrect: {
                                    type: ["list", "string", "list", "string"],
                                },
                            },
                            block_types: {
                                triggers: {
                                    nesting_mode: "single",
                                    block: {
                                        attributes: {
                                            correct: {
                                                type: ["list", "string"],
                                            },
                                            incorrect: {
                                                type: ["list", "string", "list", "string"],
                                            },
                                        },
                                        block_types: {},
                                    },
                                },
                            },
                        },
                    },
                    resource_schemas: {
                        null_resource: {
                            version: 0,
                            block: {
                                attributes: {
                                    id: {
                                        type: "string",
                                        computed: true,
                                    },
                                    correct: {
                                        type: ["list", "string"],
                                    },
                                    incorrect: {
                                        type: ["list", "string", "list", "string"],
                                    },
                                },
                                block_types: {
                                    triggers: {
                                        nesting_mode: "single",
                                        block: {
                                            attributes: {
                                                triggers: {
                                                    type: "string",
                                                    optional: true,
                                                },
                                                correct: {
                                                    type: ["list", "string"],
                                                },
                                                incorrect: {
                                                    type: ["list", "string", "list", "string"],
                                                },
                                            },
                                            block_types: {},
                                        },
                                    },
                                },
                            },
                        },
                    },
                    data_source_schemas: {},
                },
            },
        };
        const result = (0, provider_schema_1.sanitizeProviderSchema)(schema);
        expect(result).toMatchSnapshot();
    });
});
//# sourceMappingURL=data:application/json;base64,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