"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.uppercaseFirst = exports.downcaseFirst = void 0;
/**
 * Downcase the first character in a string.
 *
 * @param str the string to be processed.
 */
function downcaseFirst(str) {
    if (str === "") {
        return str;
    }
    return `${str[0].toLocaleLowerCase()}${str.slice(1)}`;
}
exports.downcaseFirst = downcaseFirst;
/**
 * Uppercase the first character in a string.
 *
 * @param str the string to be processed.
 */
function uppercaseFirst(str) {
    if (str === "") {
        return str;
    }
    return `${str[0].toLocaleUpperCase()}${str.slice(1)}`;
}
exports.uppercaseFirst = uppercaseFirst;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbInV0aWwudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6IjtBQUFBLCtCQUErQjtBQUMvQixtQ0FBbUM7OztBQUVuQzs7OztHQUlHO0FBQ0gsU0FBZ0IsYUFBYSxDQUFDLEdBQVc7SUFDdkMsSUFBSSxHQUFHLEtBQUssRUFBRSxFQUFFLENBQUM7UUFDZixPQUFPLEdBQUcsQ0FBQztJQUNiLENBQUM7SUFDRCxPQUFPLEdBQUcsR0FBRyxDQUFDLENBQUMsQ0FBQyxDQUFDLGlCQUFpQixFQUFFLEdBQUcsR0FBRyxDQUFDLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO0FBQ3hELENBQUM7QUFMRCxzQ0FLQztBQUVEOzs7O0dBSUc7QUFDSCxTQUFnQixjQUFjLENBQUMsR0FBVztJQUN4QyxJQUFJLEdBQUcsS0FBSyxFQUFFLEVBQUUsQ0FBQztRQUNmLE9BQU8sR0FBRyxDQUFDO0lBQ2IsQ0FBQztJQUNELE9BQU8sR0FBRyxHQUFHLENBQUMsQ0FBQyxDQUFDLENBQUMsaUJBQWlCLEVBQUUsR0FBRyxHQUFHLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUM7QUFDeEQsQ0FBQztBQUxELHdDQUtDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcblxuLyoqXG4gKiBEb3duY2FzZSB0aGUgZmlyc3QgY2hhcmFjdGVyIGluIGEgc3RyaW5nLlxuICpcbiAqIEBwYXJhbSBzdHIgdGhlIHN0cmluZyB0byBiZSBwcm9jZXNzZWQuXG4gKi9cbmV4cG9ydCBmdW5jdGlvbiBkb3duY2FzZUZpcnN0KHN0cjogc3RyaW5nKTogc3RyaW5nIHtcbiAgaWYgKHN0ciA9PT0gXCJcIikge1xuICAgIHJldHVybiBzdHI7XG4gIH1cbiAgcmV0dXJuIGAke3N0clswXS50b0xvY2FsZUxvd2VyQ2FzZSgpfSR7c3RyLnNsaWNlKDEpfWA7XG59XG5cbi8qKlxuICogVXBwZXJjYXNlIHRoZSBmaXJzdCBjaGFyYWN0ZXIgaW4gYSBzdHJpbmcuXG4gKlxuICogQHBhcmFtIHN0ciB0aGUgc3RyaW5nIHRvIGJlIHByb2Nlc3NlZC5cbiAqL1xuZXhwb3J0IGZ1bmN0aW9uIHVwcGVyY2FzZUZpcnN0KHN0cjogc3RyaW5nKTogc3RyaW5nIHtcbiAgaWYgKHN0ciA9PT0gXCJcIikge1xuICAgIHJldHVybiBzdHI7XG4gIH1cbiAgcmV0dXJuIGAke3N0clswXS50b0xvY2FsZVVwcGVyQ2FzZSgpfSR7c3RyLnNsaWNlKDEpfWA7XG59XG4iXX0=