"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.shouldSkipAttribute = void 0;
/**
 * There are large attributes on little used resources that blow up the
 * size and compile time of the generated providers by a lot.
 * To mitigate this issue we replace their entire tree of attributes with
 * a single any attribute. This can still be used, although less conveniently.
 */
const SKIPPED_ATTRIBUTES = [
    "aws.quicksight_template.definition",
    "aws.quicksight_dashboard.definition",
    "aws.quicksight_analysis.definition",
    "aws.data_aws_quicksight_analysis.definition",
    "aws.wafv2_web_acl.wafv2_web_acl_rule.statement",
    "aws.wafv2_rule_group.wafv2_rule_group_rule.statement",
    "oci.data_oci_objectstorage_private_endpoint.fqdns",
    "oci.data_oci_objectstorage_private_endpoint_summaries.private_endpoint_summaries.fqdns",
];
/**
 * We skip some deeply nested attributes to shorten the generated code.
 */
function shouldSkipAttribute(terraformFullName) {
    return SKIPPED_ATTRIBUTES.includes(terraformFullName);
}
exports.shouldSkipAttribute = shouldSkipAttribute;
//# sourceMappingURL=data:application/json;base64,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