"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
Object.defineProperty(exports, "__esModule", { value: true });
exports.sanitizedComment = void 0;
function sanitizedComment(code) {
    let wasSanitized = false;
    code.line(`/**`);
    return {
        line: (comment) => {
            // objects can not be valid comments
            if (typeof comment === "object" && !Array.isArray(comment)) {
                return;
            }
            const stringified = Array.isArray(comment)
                ? comment.join("\n")
                : comment.toLocaleString();
            const sanitized = typeof stringified === "string"
                ? stringified.replace(/\*\//g, "* /")
                : stringified;
            if (sanitized === "") {
                code.line(`*`);
                return;
            }
            if (sanitized !== stringified) {
                wasSanitized = true;
            }
            sanitized.split("\n").forEach((line) => {
                code.line(`* ${line}`);
            });
        },
        end: () => {
            if (wasSanitized) {
                code.line(` *`);
                code.line("* Note: The above comment contained a comment block ending sequence (* followed by /). We have introduced a space between to prevent syntax errors. Please ignore the space.");
            }
            code.line(`*/`);
        },
    };
}
exports.sanitizedComment = sanitizedComment;
//# sourceMappingURL=data:application/json;base64,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