import { CodeMaker } from "codemaker";
import { ConstructsMakerTarget, ProviderSchema } from "@cdktf/commons";
import { FQPN } from "@cdktf/provider-schema";
import { ResourceModel } from "./models";
interface ProviderData {
    name: string;
    source: string;
    version: string;
}
export interface ProviderConstraints {
    [fqn: string]: ProviderData;
}
export declare class TerraformProviderGenerator {
    private readonly code;
    private readonly schema;
    private resourceParser;
    private resourceEmitter;
    private structEmitter;
    versions: {
        [fqpn: string]: string | undefined;
    };
    constructor(code: CodeMaker, schema: ProviderSchema);
    private getProviderByConstraint;
    generate(providerConstraint: ConstructsMakerTarget): void;
    generateAll(): void;
    save(outdir: string): Promise<void>;
    buildResourceModels(fqpn: FQPN, constraint?: ConstructsMakerTarget): ResourceModel[];
    getClassNameForResource(terraformType: string): string;
    getNamespaceNameForResource(terraformType: string): string;
    private emitProvider;
    private emitResourceReadme;
    private emitIndexFile;
    private emitLazyIndexFile;
    private emitResource;
    private emitResourceWithComplexStruct;
    private emitFileHeader;
}
export {};
