"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.ConfigStruct = exports.Struct = void 0;
const util_1 = require("../../../util");
class Struct {
    constructor(name, attributes, isClass = false, isAnonymous = false, isSingleItem = false, nestingMode = "") {
        this.name = name;
        this.attributes = attributes;
        this.isClass = isClass;
        this.isAnonymous = isAnonymous;
        this.isSingleItem = isSingleItem;
        this.nestingMode = nestingMode;
    }
    get assignableAttributes() {
        return this.attributes.filter((attribute) => attribute.isAssignable);
    }
    get optionalAttributes() {
        return this.attributes.filter((attribute) => attribute.optional);
    }
    get allOptional() {
        return (this.attributes.filter((attribute) => !attribute.optional && !attribute.computed).length == 0);
    }
    get attributeType() {
        return `${this.name}${this.allOptional ? " = {}" : ""}`;
    }
    get assignable() {
        return !this.isClass || this.assignableAttributes.length > 0;
    }
    get extends() {
        return "";
    }
    get mapperName() {
        return `${(0, util_1.downcaseFirst)(this.name)}ToTerraform`;
    }
    get hclMapperName() {
        return `${(0, util_1.downcaseFirst)(this.name)}ToHclTerraform`;
    }
    get outputReferenceName() {
        return `${this.name}OutputReference`;
    }
    get listName() {
        return `${this.name}List`;
    }
    get mapName() {
        return `${this.name}Map`;
    }
    get mapListName() {
        return `${this.name}MapList`;
    }
    get listMapName() {
        return `${this.name}ListMap`;
    }
    get listListName() {
        return `${this.name}ListList`;
    }
    get isProvider() {
        return this.attributes.some((att) => att.isProvider);
    }
    get referencedTypes() {
        const types = [];
        this.attributes.forEach((att) => {
            const attReferences = att.getReferencedTypes(false); // This may be a config struct, but still need the references in this context
            if (attReferences) {
                types.push(...attReferences);
            }
        });
        return types;
    }
    get exportCount() {
        let count = 1; // self
        count += 1; // toTerraform function
        if (this.nestingMode === "list" ||
            this.nestingMode === "set" ||
            this.nestingMode === "map") {
            count += 1; // output reference
            if (!this.isSingleItem) {
                count += 1; // complex collection
            }
        }
        return count;
    }
}
exports.Struct = Struct;
class ConfigStruct extends Struct {
    get extends() {
        return ` extends cdktf.TerraformMetaArguments`;
    }
}
exports.ConfigStruct = ConfigStruct;
//# sourceMappingURL=data:application/json;base64,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