"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Scope = void 0;
class Scope {
    constructor(props) {
        var _a, _b, _c, _d, _e;
        this.name = props.name;
        this.parent = props.parent;
        this.isProvider = props.isProvider;
        this.isComputed = (_a = props.isComputed) !== null && _a !== void 0 ? _a : false;
        this.isOptional = (_b = props.isOptional) !== null && _b !== void 0 ? _b : true;
        this.isRequired = (_c = props.isRequired) !== null && _c !== void 0 ? _c : false;
        this.inBlockType = (_d = props.inBlockType) !== null && _d !== void 0 ? _d : false;
        this.isNestedType = (_e = props.isNestedType) !== null && _e !== void 0 ? _e : false;
    }
    fullName(attributeName) {
        return `${this.baseName}.${attributeName}`;
    }
    get baseName() {
        // eslint-disable-next-line @typescript-eslint/no-this-alias
        let scope = this;
        let name = "";
        while (scope) {
            if (name === "") {
                name = scope.name;
            }
            else {
                name = `${scope.name}.${name}`;
            }
            scope = scope.parent;
        }
        return name;
    }
}
exports.Scope = Scope;
//# sourceMappingURL=data:application/json;base64,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