import { FQPN, ProviderName } from "@cdktf/provider-schema";
import { AttributeModel } from "./attribute-model";
import { Struct, ConfigStruct } from "./struct";
import { Schema } from "@cdktf/commons";
export declare const STRUCT_SHARDING_THRESHOLD = 400;
interface ResourceModelOptions {
    terraformType: string;
    className: string;
    baseName: string;
    fileName: string;
    filePath: string;
    attributes: AttributeModel[];
    structs: Struct[];
    fqpn: FQPN;
    schema: Schema;
    terraformSchemaType: string;
    configStructName: string;
}
type DefinitionPath = string;
export declare class ResourceModel {
    className: string;
    filePath: string;
    terraformType: string;
    baseName: string;
    provider: ProviderName;
    fqpn: FQPN;
    providerVersionConstraint?: string;
    providerVersion?: string;
    terraformProviderSource?: string;
    terraformProviderName: string;
    fileName: string;
    attributes: AttributeModel[];
    schema: Schema;
    private _structs;
    private dependencies;
    private terraformSchemaType;
    private configStructName;
    readonly structsRequireSharding: boolean;
    recursiveAttributePaths: {
        [usagePath: string]: DefinitionPath;
    };
    constructor(options: ResourceModelOptions);
    get structs(): Struct[];
    get configStruct(): ConfigStruct;
    get synthesizableAttributes(): AttributeModel[];
    get importStatements(): string[];
    get schemaAsJson(): string;
    get linkToDocs(): string;
    get isProvider(): boolean;
    get isDataSource(): boolean;
    get parentClassName(): string;
    get terraformResourceType(): string;
    get terraformDocName(): string;
    get referencedTypes(): string[];
    get structsFolderName(): string;
    get structsFolderPath(): string;
    get namespaceFolderPath(): string;
    private escapeSchema;
}
export {};
