import { Struct } from "./struct";
export interface AttributeTypeModel {
    readonly struct?: Struct;
    readonly isComplex: boolean;
    getStoredClassInitializer(name: string): string;
    readonly storedClassType: string;
    readonly inputTypeDefinition: string;
    getAttributeAccessFunction(name: string): string;
    readonly toTerraformFunction: string;
    readonly toHclTerraformFunction: string;
    readonly typeModelType: string;
    readonly hasReferenceClass: boolean;
    readonly isTokenizable: boolean;
}
export declare class SkippedAttributeTypeModel implements AttributeTypeModel {
    constructor();
    get typeModelType(): string;
    get struct(): undefined;
    get isComplex(): boolean;
    getStoredClassInitializer(_name: string): string;
    get storedClassType(): string;
    get inputTypeDefinition(): string;
    getAttributeAccessFunction(name: string): string;
    get toTerraformFunction(): string;
    get toHclTerraformFunction(): string;
    get hasReferenceClass(): boolean;
    get isTokenizable(): boolean;
}
export declare class SimpleAttributeTypeModel implements AttributeTypeModel {
    readonly type: string;
    constructor(type: string);
    get typeModelType(): string;
    get struct(): undefined;
    get isComplex(): boolean;
    getStoredClassInitializer(_name: string): string;
    get storedClassType(): string;
    get inputTypeDefinition(): string;
    getAttributeAccessFunction(name: string): string;
    get toTerraformFunction(): string;
    get toHclTerraformFunction(): string;
    get hasReferenceClass(): boolean;
    get isTokenizable(): boolean;
}
export declare class StructAttributeTypeModel implements AttributeTypeModel {
    readonly struct: Struct;
    constructor(struct: Struct);
    get typeModelType(): string;
    get isComplex(): boolean;
    getStoredClassInitializer(name: string): string;
    get storedClassType(): string;
    get inputTypeDefinition(): string;
    getAttributeAccessFunction(name: string): string;
    get toTerraformFunction(): string;
    get toHclTerraformFunction(): string;
    get hasReferenceClass(): boolean;
    get isTokenizable(): boolean;
}
export interface CollectionAttributeTypeModel extends AttributeTypeModel {
    elementType: AttributeTypeModel;
}
export declare class ListAttributeTypeModel implements CollectionAttributeTypeModel {
    readonly elementType: AttributeTypeModel;
    readonly isSingleItem: boolean;
    private readonly isBlock;
    constructor(elementType: AttributeTypeModel, isSingleItem: boolean, isBlock: boolean);
    get typeModelType(): string;
    get struct(): Struct | undefined;
    get isComplex(): boolean;
    getStoredClassInitializer(name: string): string;
    get storedClassType(): string;
    get inputTypeDefinition(): string;
    getAttributeAccessFunction(name: string): string;
    get toTerraformFunction(): string;
    get toHclTerraformFunction(): string;
    get hasReferenceClass(): boolean;
    get isTokenizable(): boolean;
}
export declare class SetAttributeTypeModel implements CollectionAttributeTypeModel {
    readonly elementType: AttributeTypeModel;
    readonly isSingleItem: boolean;
    private readonly isBlock;
    constructor(elementType: AttributeTypeModel, isSingleItem: boolean, isBlock: boolean);
    get typeModelType(): string;
    get struct(): Struct | undefined;
    get isComplex(): boolean;
    getStoredClassInitializer(name: string): string;
    get storedClassType(): string;
    get inputTypeDefinition(): string;
    getAttributeAccessFunction(name: string): string;
    get toTerraformFunction(): string;
    get toHclTerraformFunction(): string;
    get hasReferenceClass(): boolean;
    get isTokenizable(): boolean;
}
export declare class MapAttributeTypeModel implements CollectionAttributeTypeModel {
    readonly elementType: AttributeTypeModel;
    constructor(elementType: AttributeTypeModel);
    get typeModelType(): string;
    get struct(): Struct | undefined;
    get isComplex(): boolean;
    getStoredClassInitializer(name: string): string;
    get storedClassType(): string;
    get inputTypeDefinition(): string;
    getAttributeAccessFunction(name: string): string;
    get toTerraformFunction(): string;
    get toHclTerraformFunction(): string;
    get hasReferenceClass(): boolean;
    get isTokenizable(): boolean;
}
