import { AttributeTypeModel } from "./attribute-type-model";
export type GetterType = {
    _type: "plain";
} | {
    _type: "args";
    args: string;
    returnType?: string;
    returnStatement: string;
} | {
    _type: "stored_class";
};
export type SetterType = {
    _type: "none";
} | {
    _type: "set";
    type: string;
} | {
    _type: "put";
    type: string;
} | {
    _type: "stored_class";
    type: string;
};
export interface AttributeModelOptions {
    storageName: string;
    name: string;
    type: AttributeTypeModel;
    optional: boolean;
    computed: boolean;
    terraformName: string;
    terraformFullName: string;
    description?: string;
    getAttCall?: string;
    provider: boolean;
    required: boolean;
    forcePlainGetterType?: boolean;
}
export declare function escapeAttributeName(name: string): string;
export declare class AttributeModel {
    storageName: string;
    private _name;
    type: AttributeTypeModel;
    optional: boolean;
    computed: boolean;
    terraformName: string;
    terraformFullName: string;
    private _description?;
    provider: boolean;
    required: boolean;
    forcePlainGetterType?: boolean;
    constructor(options: AttributeModelOptions);
    get typeDefinition(): string;
    get isAssignable(): boolean;
    get isOptional(): boolean;
    get isRequired(): boolean;
    get isProvider(): boolean;
    get getterType(): GetterType;
    get isStored(): boolean;
    get setterType(): SetterType;
    get name(): string;
    static escapeName(name: string): string;
    get description(): string | undefined;
    getReferencedTypes(isConfigStruct: boolean): string[] | undefined;
}
