"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.detectAttributeLoops = void 0;
const equalAttributeIdentifiers = (x, y) => x[0] === y[0] &&
    x[1].size === y[1].size &&
    [...x[1]].every((x) => y[1].has(x));
function typeStructure(model) {
    var _a;
    if (!model.type.isComplex) {
        return model.type.storedClassType;
    }
    return `<complex:{${(_a = model.type.struct) === null || _a === void 0 ? void 0 : _a.attributes.map((att) => att.name).sort()}}${model.type.typeModelType}>`;
}
function getAttributeIdentifier(model) {
    return [
        model.terraformName,
        new Set(model.type.struct.attributes.map((a) => `${a.name}:${typeStructure(a)}`)),
    ];
}
/**
 * Detects recursive attribute schemas and returns an Object
 * describing what property should be linking to which class
 */
function detectAttributeLoops(attributes) {
    // We aproximate a class as a set of attributes names
    // This is not a perfect approximation, but it's good enough for our purposes
    const redirects = {};
    function depthFirstSearch(attribute, path = [], knownStructs = {}) {
        const name = attribute.terraformName;
        const struct = attribute.type.struct;
        if (!struct) {
            return;
        }
        const structIdentifier = getAttributeIdentifier(attribute);
        // Detect if we visited this already
        const visited = Object.entries(knownStructs).find(([, attrIdentifier]) => equalAttributeIdentifiers(structIdentifier, attrIdentifier));
        if (visited) {
            // We have a loop, we don't need to search deeper
            const toBeReplacedWith = visited[0];
            const toReplace = [...path, name].join(".");
            redirects[toReplace] = toBeReplacedWith;
        }
        else {
            // Search deeper
            struct.attributes.forEach((a) => depthFirstSearch(a, [...path, name], {
                ...knownStructs,
                // We haven't visited this yet, add it to the list of known structs
                [[...path, name].join(".")]: structIdentifier,
            }));
        }
    }
    attributes.forEach((attr) => depthFirstSearch(attr));
    return redirects;
}
exports.detectAttributeLoops = detectAttributeLoops;
//# sourceMappingURL=data:application/json;base64,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