"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.determineGoModuleName = exports.ConstructsMaker = exports.generateJsiiLanguage = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs-extra"));
const path = __importStar(require("path"));
const codemaker_1 = require("codemaker");
const commons_1 = require("@cdktf/commons");
const commons_2 = require("@cdktf/commons");
const commons_3 = require("@cdktf/commons");
const provider_generator_1 = require("./generator/provider-generator");
const module_generator_1 = require("./generator/module-generator");
const glob_1 = require("glob");
const provider_schema_1 = require("@cdktf/provider-schema");
const pacmakModule = require.resolve("jsii-pacmak/bin/jsii-pacmak");
const jsiiModule = require.resolve("jsii/bin/jsii");
async function generateJsiiLanguage(code, opts, outputPath, disallowedFileGlobs = []) {
    await (0, commons_1.mkdtemp)(async (staging) => {
        // this is not typescript, so we generate in a staging directory and
        // use jsii-srcmak to compile and extract the language-specific source
        // into our project.
        await code.save(staging);
        // as the above generated the Typescript code for all providers and modules,
        // we need to filter out the ones we don't need so they don't end up in the JSII bundle over and over again.
        const filesToDelete = disallowedFileGlobs.flatMap((pattern) => glob_1.glob.sync(pattern, { cwd: staging }));
        await Promise.all(filesToDelete.map((file) => fs.remove(path.join(staging, file))));
        // Compile with JSII
        const jsiiArgs = ["--silence-warnings", "reserved-word"];
        const jsiiEntrypoint = opts.entrypoint;
        const basepath = path.join(path.dirname(jsiiEntrypoint), path.basename(jsiiEntrypoint, ".ts"));
        const moduleKey = opts.moduleKey.replace(/\./g, "").replace(/\//g, "");
        const moduleDirs = opts.deps;
        const targets = {};
        const deps = {};
        for (const dir of moduleDirs) {
            // read module metadata
            const metadata = await fs.readJson(path.join(dir, "package.json"));
            const moduleName = metadata.name;
            const moduleVersion = metadata.version;
            const targetdir = path.join(path.join(staging, "node_modules"), moduleName);
            await fs.mkdirp(path.dirname(targetdir));
            await fs.copy(dir, targetdir);
            // add to "deps" and "peer deps"
            if (!moduleName.startsWith("@types/")) {
                deps[moduleName] = moduleVersion;
            }
        }
        const pkg = {
            name: moduleKey,
            version: "0.0.0",
            author: "generated@generated.com",
            main: `${basepath}.js`,
            types: `${basepath}.d.ts`,
            license: "UNLICENSED",
            repository: { url: "http://generated", type: "git" },
            jsii: {
                outdir: "dist",
                targets: targets,
            },
            dependencies: deps,
            peerDependencies: deps,
        };
        if (opts.exports) {
            pkg.exports = opts.exports;
        }
        if (opts.python) {
            targets.python = {
                distName: "generated",
                module: opts.python.moduleName,
            };
        }
        if (opts.java) {
            targets.java = {
                package: opts.java.package,
                maven: {
                    groupId: "generated",
                    artifactId: "generated",
                },
            };
        }
        if (opts.csharp) {
            targets.dotnet = {
                namespace: opts.csharp.namespace,
                packageId: opts.csharp.namespace,
            };
        }
        if (opts.golang) {
            targets.go = {
                moduleName: opts.golang.moduleName,
                packageName: opts.golang.packageName,
            };
        }
        await fs.writeFile(path.join(staging, "package.json"), JSON.stringify(pkg, undefined, 2));
        const endJsiiTimer = (0, commons_2.logTimespan)("jsii");
        await (0, commons_1.exec)(jsiiModule, jsiiArgs, {
            cwd: staging,
        });
        endJsiiTimer();
        // extract .jsii if requested
        if (opts.jsii) {
            await fs.copy(path.join(staging, ".jsii"), opts.jsii.path);
        }
        // run pacmak to generate code
        const endJsiiPacmakTimer = (0, commons_2.logTimespan)("jsii-pacmak");
        await (0, commons_1.exec)(pacmakModule, ["--code-only"], { cwd: staging });
        endJsiiPacmakTimer();
        if (opts.python) {
            const reldir = opts.python.moduleName.replace(/\./g, "/"); // jsii replaces "." with "/"
            const source = path.resolve(path.join(staging, "dist/python/src", reldir));
            const target = path.join(opts.python.outdir, reldir);
            await fs.move(source, target, { overwrite: true });
        }
        if (opts.java) {
            const source = path.resolve(path.join(staging, "dist/java/src/"));
            const target = path.join(opts.java.outdir, "src/");
            await fs.mkdirp(target); // make sure target directory exists
            await fs.copy(source, target, { recursive: true, overwrite: false });
        }
        if (opts.csharp) {
            const reldir = opts.csharp.namespace;
            const source = path.resolve(path.join(staging, "dist/dotnet/", reldir));
            const target = path.join(opts.csharp.outdir, reldir);
            await fs.move(source, target, { overwrite: true });
        }
        if (opts.golang) {
            const reldir = opts.golang.packageName;
            const source = path.resolve(path.join(staging, "dist/go/", reldir));
            const target = path.join(opts.golang.outdir, reldir);
            await fs.move(source, target, { overwrite: true });
            // remove go.mod as this would make it a submodule
            await fs.remove(path.join(target, "go.mod"));
        }
        ["versions.json", "constraints.json"].forEach((file) => {
            try {
                fs.copySync(path.resolve(staging, file), path.resolve(outputPath, file));
            }
            catch (e) {
                commons_2.logger.debug(`Failed to copy ${file}: ${e}`);
            }
        });
    });
}
exports.generateJsiiLanguage = generateJsiiLanguage;
class ConstructsMaker {
    constructor(options, schemaCachePath, reportTelemetry = async () => { }) {
        this.options = options;
        this.schemaCachePath = schemaCachePath;
        this.reportTelemetry = reportTelemetry;
        this.codeMakerOutdir = path.resolve(this.options.codeMakerOutput);
        fs.mkdirpSync(this.codeMakerOutdir);
        this.code = new codemaker_1.CodeMaker();
        this.versions = {};
    }
    async generateTypescriptProvider(target, schema) {
        const endTSTimer = (0, commons_2.logTimespan)(`Generate Typescript for ${target.name}`);
        const generator = new provider_generator_1.TerraformProviderGenerator(this.code, schema);
        generator.generate(target);
        this.versions = { ...this.versions, ...generator.versions };
        endTSTimer();
    }
    async filterAlreadyGenerated(constraints) {
        let constraintsFile = "{}";
        try {
            constraintsFile = await fs.readFile(path.join(this.codeMakerOutdir, "constraints.json"), "utf8");
        }
        catch (e) {
            commons_2.logger.debug(`Could not find constraints.json file while filtering: ${e}. This means no providers were generated, so all constraints need to be generated.`);
            return constraints;
        }
        commons_2.logger.debug(`Found constraints.json file: ${constraintsFile}`);
        let previousConstraints = {};
        try {
            previousConstraints = JSON.parse(constraintsFile);
        }
        catch (e) {
            commons_2.logger.info(`Could not parse constraints.json file while filtering: ${e}. Generating all constraints.`);
            return constraints;
        }
        commons_2.logger.debug(`Found previous constraints: ${JSON.stringify(previousConstraints, null, 2)}`);
        if (!previousConstraints.providers ||
            typeof previousConstraints.providers !== "object") {
            commons_2.logger.info(`Could not find providers in constraints.json file, generating all constraints. The constraints file was ${JSON.stringify(previousConstraints, null, 2)}`);
            return constraints;
        }
        if (previousConstraints.cdktf !== commons_3.DISPLAY_VERSION) {
            commons_2.logger.info(`The CDKTF version has changed, generating all constraints. The previous version was ${previousConstraints.cdktf}, the current version is ${commons_3.DISPLAY_VERSION}`);
            return constraints;
        }
        const constraintsToGenerate = constraints.filter((constraint) => {
            const constraintMatches = previousConstraints.providers[constraint.fqn] === constraint.version;
            let providerFolderExists = false;
            switch (this.options.targetLanguage) {
                case commons_3.Language.TYPESCRIPT:
                    providerFolderExists = fs.existsSync(path.join(this.codeMakerOutdir, "providers", constraint.name));
                    break;
                case commons_3.Language.PYTHON:
                case commons_3.Language.JAVA:
                case commons_3.Language.CSHARP:
                    providerFolderExists = fs.existsSync(path.join(this.codeMakerOutdir, constraint.name));
                    break;
                case commons_3.Language.GO:
                    providerFolderExists = fs.existsSync(path.join(this.codeMakerOutdir, constraint.namespace || "hashicorp", constraint.name));
                    break;
            }
            const providerExists = constraintMatches && providerFolderExists;
            return !providerExists;
        });
        commons_2.logger.debug(`Constraints to generate: ${JSON.stringify(constraintsToGenerate, null, 2)}`);
        return constraintsToGenerate;
    }
    async generateTypescriptModule(target, schema) {
        const endTSTimer = (0, commons_2.logTimespan)(`Generate Typescript for ${target.name}`);
        target.spec = schema;
        new module_generator_1.ModuleGenerator(this.code, [target]);
        endTSTimer();
    }
    async generateTypescript(target, schemas) {
        var _a;
        if (target.isModule) {
            const schema = (_a = schemas.moduleSchema) === null || _a === void 0 ? void 0 : _a[target.moduleKey];
            if (!schema) {
                throw commons_2.Errors.Internal(`Could not generate schema for module ${target.moduleKey}`);
            }
            await this.generateTypescriptModule(target, schema);
        }
        else if (target.isProvider) {
            if (!schemas.providerSchema) {
                throw commons_2.Errors.Internal(`Could not generate schema for providers`);
            }
            await this.generateTypescriptProvider(target, schemas.providerSchema);
        }
        else {
            throw new Error(`Unknown target type used to generate bindings: ${target.name}`);
        }
    }
    // emits a versions.json file with a map of the used version for each provider fqpn
    updateVersionsFile(allowedConstraints) {
        commons_2.logger.debug(`Updating versions file with generated versions ${JSON.stringify(this.versions, null, 2)} with allowed constraints ${JSON.stringify(allowedConstraints, null, 2)}`);
        const filePath = "versions.json";
        let previousVersions = {};
        try {
            previousVersions = JSON.parse(fs.readFileSync(path.resolve(this.codeMakerOutdir, filePath), "utf8"));
            commons_2.logger.debug(`Read existing versions file: ${JSON.stringify(previousVersions, null, 2)}`);
        }
        catch (e) {
            // ignore
            commons_2.logger.debug(`Could not read versions file, this is expected if there are no pre-existing local providers: ${e}`);
        }
        const versions = allowedConstraints.reduce((acc, constraint) => {
            const provider = Object.entries(previousVersions).find(([name]) => 
            // This could be more refined, but it's good enough for now
            name.endsWith(constraint.fqn));
            if (provider) {
                const [name, version] = provider;
                return { ...acc, [name]: version };
            }
            return acc;
        }, {});
        commons_2.logger.debug(`Writing versions file (${filePath}): ${JSON.stringify(versions, null, 2)}`);
        this.code.openFile(filePath);
        this.code.line(JSON.stringify({ ...versions, ...this.versions }, null, 2));
        this.code.closeFile(filePath);
        return filePath;
    }
    async removeFoldersThatShouldNotExist(constraintsThatShouldExist) {
        commons_2.logger.debug(`Removing providers except for ${JSON.stringify(constraintsThatShouldExist, null, 2)}`);
        // All languages besides TS keep their providers in the same folders as modules
        // this makes it impossible for us to distinguish a no longer required provider
        // from a manually written construct or a module
        if (!this.isJavascriptTarget) {
            return;
        }
        let filesInProviders = [];
        const providersFolder = path.resolve(this.codeMakerOutdir, "providers");
        try {
            filesInProviders = await fs.readdir(providersFolder);
        }
        catch (e) {
            commons_2.logger.debug(`Error listing files in providers folder '${providersFolder}': ${e}`);
        }
        const folders = filesInProviders.filter((file) => fs
            .statSync(path.resolve(this.codeMakerOutdir, "providers", file))
            .isDirectory());
        return folders.forEach((folder) => {
            const shouldExist = constraintsThatShouldExist.some((constraint) => constraint.name === folder);
            if (!shouldExist) {
                commons_2.logger.debug(`Removing folder ${folder} from providers`);
                fs.removeSync(path.resolve(this.codeMakerOutdir, "providers", folder));
            }
        });
    }
    // emits a constraints.json file with a map of the used provider fqpns and version constraints
    // this is used for caching purposes
    emitConstraintsFile(allowedConstraints) {
        const filePath = "constraints.json";
        const content = {
            cdktf: commons_3.DISPLAY_VERSION,
            providers: allowedConstraints
                .sort((a, b) => a.fqn.localeCompare(b.fqn))
                .reduce((carry, item) => ({
                ...carry,
                [item.fqn]: item.version,
            }), {}),
        };
        this.code.openFile(filePath);
        this.code.line(JSON.stringify(content, null, 2));
        this.code.closeFile(filePath);
        return filePath;
    }
    async generateJsiiLanguage(target) {
        var _a;
        // these are the module dependencies we compile against
        const deps = ["@types/node", "constructs", "cdktf"];
        const opts = {
            entrypoint: target.fileName,
            deps: deps.map((dep) => path.dirname(require.resolve(`${dep}/package.json`))),
            moduleKey: target.moduleKey,
            exports: target.isProvider // Modules are small enough that we don't need this optimization
                ? {
                    ".": {
                        import: `./providers/${target.name}/index.js`,
                        require: `./providers/${target.name}/lazy-index.js`,
                    },
                }
                : undefined,
        };
        // used for testing.
        if (this.options.outputJsii) {
            opts.jsii = { path: this.options.outputJsii };
        }
        if (this.isPythonTarget) {
            opts.python = {
                outdir: this.codeMakerOutdir,
                moduleName: target.srcMakName,
            };
        }
        if (this.isJavaTarget) {
            if (this.options.codeMakerOutput.includes("/") ||
                this.options.codeMakerOutput.includes("\\")) {
                throw commons_2.Errors.Usage(`When using Java the "codeMakerOutput" option in the cdktf.json must be the organization identifier for your project (e.g. com.my-company), not a path. The generated Java code will be placed in a subdirectory of the given directory. If you are migrating from a < 0.19 version of cdktf you want to change the codemakerOutput to "imports".`);
            }
            opts.java = {
                outdir: ".", // generated java files aren't packaged, so just include directly in app
                package: `${this.options.codeMakerOutput}.${target.srcMakName}`,
            };
        }
        if (this.isCsharpTarget) {
            opts.csharp = {
                outdir: this.codeMakerOutdir,
                namespace: target.srcMakName,
            };
        }
        if (this.isGoTarget) {
            // TODO: check if needed for modules somehow
            // const targetType = target.isProvider ? 'provider' : 'module';
            // jsii-srcmac will produce a folder inside this dir named after "packageName"
            // so this results in e.g. .gen/hashicorp/random
            const outdir = path.join(this.codeMakerOutdir, (_a = target.namespace) !== null && _a !== void 0 ? _a : "");
            opts.golang = {
                outdir,
                moduleName: await (0, exports.determineGoModuleName)(outdir), // e.g. `github.com/org/userproject/.gen/hashicorp`
                packageName: target.srcMakName, // package will be named e.g. random for hashicorp/random
            };
        }
        if (process.env.NODE_OPTIONS &&
            !process.env.NODE_OPTIONS.includes(`--max-old-space-size`)) {
            commons_2.logger.warn(`found NODE_OPTIONS environment variable without a setting for --max-old-space-size.
The provider generation needs a substantial amount of memory (~13GB) for some providers and languages.
So cdktf-cli sets it to NODE_OPTIONS="--max-old-space-size=16384" by default. As your environment already contains
a NODE_OPTIONS variable, we won't override it. Hence, the provider generation might fail with an out of memory error.`);
        }
        else {
            // increase memory to allow generating large providers (i.e. aws or azurerm for Go)
            // srcmak is going to spawn a childprocess (for jsii-pacmak) which is going to be affected by this env var
            process.env.NODE_OPTIONS = "--max-old-space-size=16384";
        }
        const jsiiTimer = (0, commons_2.logTimespan)("JSII");
        await generateJsiiLanguage(this.code, opts, this.codeMakerOutdir, [
            target.isModule ? "providers/**" : "modules/**",
        ]);
        jsiiTimer();
    }
    async getSchemas(targets) {
        return await (0, provider_schema_1.readSchema)(targets, this.schemaCachePath);
    }
    async generate(allConstraints, constraintsToGenerate = allConstraints) {
        const targets = constraintsToGenerate.map((constraint) => commons_2.ConstructsMakerTarget.from(constraint, this.options.targetLanguage));
        const endSchemaTimer = (0, commons_2.logTimespan)("Gathering schema");
        const schemas = await this.getSchemas(constraintsToGenerate);
        endSchemaTimer();
        const endGenerateTimer = (0, commons_2.logTimespan)("Generate TS");
        await Promise.all(targets.map((target) => this.generateTypescript(target, schemas)));
        endGenerateTimer();
        this.updateVersionsFile(allConstraints);
        this.emitConstraintsFile(allConstraints);
        if (this.isJavascriptTarget) {
            await this.save();
        }
        if (!this.isJavascriptTarget || this.options.outputJsii) {
            const numberOfWorkers = Math.max(1, this.options.jsiiParallelism === -1
                ? targets.length
                : this.options.jsiiParallelism || 1);
            const work = [...targets];
            const workers = new Array(numberOfWorkers).fill(async () => {
                let target;
                while ((target = work.pop())) {
                    const endJsiiTarget = (0, commons_2.logTimespan)(`Generating JSII bindings for ${target.name}`);
                    await this.generateJsiiLanguage(target);
                    endJsiiTarget();
                }
            });
            await Promise.all(workers.map((fn) => fn()));
        }
        for (const target of targets) {
            await this.reportTelemetry({
                trackingPayload: target.trackingPayload,
                targetLanguage: target.targetLanguage,
            });
        }
        if (this.isPythonTarget) {
            const endPythonTimer = (0, commons_2.logTimespan)("Python post-processing");
            // Remove from . import ... statements from root level __init__.py
            // This removes root-level imports of namespaces, but saves 25s synth time for the aws provider alone
            const allInitPyPaths = glob_1.glob
                .sync("**/__init__.py", {
                cwd: this.codeMakerOutdir,
            })
                // sort by depth, so we start with the shallowest files
                .sort((a, b) => a.split("/").length - b.split("/").length);
            const visitedDirectories = [];
            for (const initPyPath of allInitPyPaths) {
                const directoryPath = path.dirname(initPyPath);
                if (visitedDirectories.some((dir) => directoryPath.startsWith(dir))) {
                    // we already processed this directory
                    continue;
                }
                visitedDirectories.push(directoryPath);
                const absoluteInitPyPath = path.join(this.codeMakerOutdir, initPyPath);
                const initPy = await fs.readFile(absoluteInitPyPath, "utf8");
                const initPyWithoutImports = initPy.replace(/from \. import .*\n/g, "");
                await fs.writeFile(absoluteInitPyPath, initPyWithoutImports);
            }
            endPythonTimer();
        }
    }
    async save(outdir = this.codeMakerOutdir) {
        await this.code.save(outdir);
    }
    get isJavascriptTarget() {
        return this.options.targetLanguage === commons_3.Language.TYPESCRIPT;
    }
    get isPythonTarget() {
        return this.options.targetLanguage === commons_3.Language.PYTHON;
    }
    get isJavaTarget() {
        return this.options.targetLanguage === commons_3.Language.JAVA;
    }
    get isCsharpTarget() {
        return this.options.targetLanguage === commons_3.Language.CSHARP;
    }
    get isGoTarget() {
        return this.options.targetLanguage === commons_3.Language.GO;
    }
}
exports.ConstructsMaker = ConstructsMaker;
/**
 * searches for the closest `go.mod` file and returns the nested go module name for `dir`
 * e.g. (/dir/.gen/) => cdk.tf/stack/.gen if the parent dir of .gen has a go.mod for "module cdk.tf/stack"
 *
 * @param dir the directory to start the search from (searches upwards)
 * @returns the package name for `dir`
 * @throws an Error if no go.mod was found
 */
const determineGoModuleName = async (dir) => {
    let previousDir;
    let currentDir = path.resolve(dir);
    do {
        let files = [];
        try {
            files = await fs.readdir(currentDir);
        }
        catch (e) {
            // directory might not exist yet, but we still walk upwards from there, so ignore 'ENOENT'
            if (e.code !== "ENOENT") {
                throw e;
            }
        }
        if (files.includes("go.mod")) {
            const file = path.resolve(currentDir, "go.mod");
            const gomod = await fs.readFile(file);
            const match = /^module\s*(\S*)\s*$/m.exec(gomod.toString());
            if (match && match[1]) {
                const childdir = path.relative(currentDir, dir).replace(/\\/g, "/"); // replace '\' with '/' for windows paths
                return childdir.length > 0 ? `${match[1]}/${childdir}` : match[1];
            }
            throw new Error(`Could not determine the root Go module name. Found ${file} but failed to regex match the module name directive`);
        }
        // go up one directory. As dirname('/') will return '/' we cancel the loop
        // as soon as the dir does not change anymore.
        previousDir = currentDir;
        currentDir = path.dirname(currentDir);
    } while (currentDir !== previousDir);
    throw new Error(`Could not determine the root Go module name. No go.mod found in ${dir} and any parent directories`);
};
exports.determineGoModuleName = determineGoModuleName;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY29uc3RydWN0cy1tYWtlci5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbImNvbnN0cnVjdHMtbWFrZXIudHMiXSwibmFtZXMiOltdLCJtYXBwaW5ncyI6Ijs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBQ25DLDZDQUErQjtBQUMvQiwyQ0FBNkI7QUFDN0IseUNBQXNDO0FBQ3RDLDRDQUErQztBQUMvQyw0Q0FVd0I7QUFDeEIsNENBQTJEO0FBQzNELHVFQUE0RTtBQUM1RSxtRUFBK0Q7QUFDL0QsK0JBQTRCO0FBQzVCLDREQUFvRDtBQUVwRCxNQUFNLFlBQVksR0FBRyxPQUFPLENBQUMsT0FBTyxDQUFDLDZCQUE2QixDQUFDLENBQUM7QUFDcEUsTUFBTSxVQUFVLEdBQUcsT0FBTyxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsQ0FBQztBQWlEN0MsS0FBSyxVQUFVLG9CQUFvQixDQUN4QyxJQUFlLEVBQ2YsSUFBeUIsRUFDekIsVUFBa0IsRUFDbEIsc0JBQWdDLEVBQUU7SUFFbEMsTUFBTSxJQUFBLGlCQUFPLEVBQUMsS0FBSyxFQUFFLE9BQU8sRUFBRSxFQUFFO1FBQzlCLG9FQUFvRTtRQUNwRSxzRUFBc0U7UUFDdEUsb0JBQW9CO1FBQ3BCLE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztRQUV6Qiw0RUFBNEU7UUFDNUUsNEdBQTRHO1FBQzVHLE1BQU0sYUFBYSxHQUFHLG1CQUFtQixDQUFDLE9BQU8sQ0FBQyxDQUFDLE9BQU8sRUFBRSxFQUFFLENBQzVELFdBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLEVBQUUsR0FBRyxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQ3JDLENBQUM7UUFDRixNQUFNLE9BQU8sQ0FBQyxHQUFHLENBQ2YsYUFBYSxDQUFDLEdBQUcsQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFLENBQUMsRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsQ0FBQyxDQUFDLENBQ2pFLENBQUM7UUFFRixvQkFBb0I7UUFDcEIsTUFBTSxRQUFRLEdBQUcsQ0FBQyxvQkFBb0IsRUFBRSxlQUFlLENBQUMsQ0FBQztRQUN6RCxNQUFNLGNBQWMsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDO1FBQ3ZDLE1BQU0sUUFBUSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQ3hCLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxDQUFDLEVBQzVCLElBQUksQ0FBQyxRQUFRLENBQUMsY0FBYyxFQUFFLEtBQUssQ0FBQyxDQUNyQyxDQUFDO1FBRUYsTUFBTSxTQUFTLEdBQUcsSUFBSSxDQUFDLFNBQVMsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxLQUFLLEVBQUUsRUFBRSxDQUFDLENBQUM7UUFDdkUsTUFBTSxVQUFVLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQztRQUM3QixNQUFNLE9BQU8sR0FBd0IsRUFBRSxDQUFDO1FBQ3hDLE1BQU0sSUFBSSxHQUEyQixFQUFFLENBQUM7UUFDeEMsS0FBSyxNQUFNLEdBQUcsSUFBSSxVQUFVLEVBQUUsQ0FBQztZQUM3Qix1QkFBdUI7WUFDdkIsTUFBTSxRQUFRLEdBQUcsTUFBTSxFQUFFLENBQUMsUUFBUSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsR0FBRyxFQUFFLGNBQWMsQ0FBQyxDQUFDLENBQUM7WUFDbkUsTUFBTSxVQUFVLEdBQVcsUUFBUSxDQUFDLElBQUksQ0FBQztZQUN6QyxNQUFNLGFBQWEsR0FBVyxRQUFRLENBQUMsT0FBTyxDQUFDO1lBRS9DLE1BQU0sU0FBUyxHQUFHLElBQUksQ0FBQyxJQUFJLENBQ3pCLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLGNBQWMsQ0FBQyxFQUNsQyxVQUFVLENBQ1gsQ0FBQztZQUNGLE1BQU0sRUFBRSxDQUFDLE1BQU0sQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLFNBQVMsQ0FBQyxDQUFDLENBQUM7WUFDekMsTUFBTSxFQUFFLENBQUMsSUFBSSxDQUFDLEdBQUcsRUFBRSxTQUFTLENBQUMsQ0FBQztZQUU5QixnQ0FBZ0M7WUFDaEMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUMsU0FBUyxDQUFDLEVBQUUsQ0FBQztnQkFDdEMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxHQUFHLGFBQWEsQ0FBQztZQUNuQyxDQUFDO1FBQ0gsQ0FBQztRQUNELE1BQU0sR0FBRyxHQUFHO1lBQ1YsSUFBSSxFQUFFLFNBQVM7WUFDZixPQUFPLEVBQUUsT0FBTztZQUNoQixNQUFNLEVBQUUseUJBQXlCO1lBQ2pDLElBQUksRUFBRSxHQUFHLFFBQVEsS0FBSztZQUN0QixLQUFLLEVBQUUsR0FBRyxRQUFRLE9BQU87WUFDekIsT0FBTyxFQUFFLFlBQVk7WUFDckIsVUFBVSxFQUFFLEVBQUUsR0FBRyxFQUFFLGtCQUFrQixFQUFFLElBQUksRUFBRSxLQUFLLEVBQUU7WUFDcEQsSUFBSSxFQUFFO2dCQUNKLE1BQU0sRUFBRSxNQUFNO2dCQUNkLE9BQU8sRUFBRSxPQUFPO2FBQ2pCO1lBQ0QsWUFBWSxFQUFFLElBQUk7WUFDbEIsZ0JBQWdCLEVBQUUsSUFBSTtTQUN2QixDQUFDO1FBRUYsSUFBSSxJQUFJLENBQUMsT0FBTyxFQUFFLENBQUM7WUFDaEIsR0FBMkIsQ0FBQyxPQUFPLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQztRQUN0RCxDQUFDO1FBQ0QsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDaEIsT0FBTyxDQUFDLE1BQU0sR0FBRztnQkFDZixRQUFRLEVBQUUsV0FBVztnQkFDckIsTUFBTSxFQUFFLElBQUksQ0FBQyxNQUFNLENBQUMsVUFBVTthQUMvQixDQUFDO1FBQ0osQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ2QsT0FBTyxDQUFDLElBQUksR0FBRztnQkFDYixPQUFPLEVBQUUsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPO2dCQUMxQixLQUFLLEVBQUU7b0JBQ0wsT0FBTyxFQUFFLFdBQVc7b0JBQ3BCLFVBQVUsRUFBRSxXQUFXO2lCQUN4QjthQUNGLENBQUM7UUFDSixDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDaEIsT0FBTyxDQUFDLE1BQU0sR0FBRztnQkFDZixTQUFTLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTO2dCQUNoQyxTQUFTLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTO2FBQ2pDLENBQUM7UUFDSixDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDaEIsT0FBTyxDQUFDLEVBQUUsR0FBRztnQkFDWCxVQUFVLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxVQUFVO2dCQUNsQyxXQUFXLEVBQUUsSUFBSSxDQUFDLE1BQU0sQ0FBQyxXQUFXO2FBQ3JDLENBQUM7UUFDSixDQUFDO1FBRUQsTUFBTSxFQUFFLENBQUMsU0FBUyxDQUNoQixJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxjQUFjLENBQUMsRUFDbEMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxHQUFHLEVBQUUsU0FBUyxFQUFFLENBQUMsQ0FBQyxDQUNsQyxDQUFDO1FBRUYsTUFBTSxZQUFZLEdBQUcsSUFBQSxxQkFBVyxFQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3pDLE1BQU0sSUFBQSxjQUFJLEVBQUMsVUFBVSxFQUFFLFFBQVEsRUFBRTtZQUMvQixHQUFHLEVBQUUsT0FBTztTQUNiLENBQUMsQ0FBQztRQUNILFlBQVksRUFBRSxDQUFDO1FBRWYsNkJBQTZCO1FBQzdCLElBQUksSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1lBQ2QsTUFBTSxFQUFFLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLE9BQU8sQ0FBQyxFQUFFLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLENBQUM7UUFDN0QsQ0FBQztRQUVELDhCQUE4QjtRQUM5QixNQUFNLGtCQUFrQixHQUFHLElBQUEscUJBQVcsRUFBQyxhQUFhLENBQUMsQ0FBQztRQUN0RCxNQUFNLElBQUEsY0FBSSxFQUFDLFlBQVksRUFBRSxDQUFDLGFBQWEsQ0FBQyxFQUFFLEVBQUUsR0FBRyxFQUFFLE9BQU8sRUFBRSxDQUFDLENBQUM7UUFDNUQsa0JBQWtCLEVBQUUsQ0FBQztRQUVyQixJQUFJLElBQUksQ0FBQyxNQUFNLEVBQUUsQ0FBQztZQUNoQixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLFVBQVUsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMsNkJBQTZCO1lBQ3hGLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQ3pCLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLGlCQUFpQixFQUFFLE1BQU0sQ0FBQyxDQUM5QyxDQUFDO1lBQ0YsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztZQUNyRCxNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1FBQ3JELENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxJQUFJLEVBQUUsQ0FBQztZQUNkLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQyxDQUFDO1lBQ2xFLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsTUFBTSxDQUFDLENBQUM7WUFDbkQsTUFBTSxFQUFFLENBQUMsTUFBTSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUMsb0NBQW9DO1lBQzdELE1BQU0sRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLEVBQUUsU0FBUyxFQUFFLElBQUksRUFBRSxTQUFTLEVBQUUsS0FBSyxFQUFFLENBQUMsQ0FBQztRQUN2RSxDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsTUFBTSxFQUFFLENBQUM7WUFDaEIsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUM7WUFDckMsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSxjQUFjLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztZQUN4RSxNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLENBQUMsTUFBTSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1lBQ3JELE1BQU0sRUFBRSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsTUFBTSxFQUFFLEVBQUUsU0FBUyxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7UUFDckQsQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO1lBQ2hCLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxNQUFNLENBQUMsV0FBVyxDQUFDO1lBQ3ZDLE1BQU0sTUFBTSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsVUFBVSxFQUFFLE1BQU0sQ0FBQyxDQUFDLENBQUM7WUFDcEUsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsTUFBTSxDQUFDLE1BQU0sRUFBRSxNQUFNLENBQUMsQ0FBQztZQUNyRCxNQUFNLEVBQUUsQ0FBQyxJQUFJLENBQUMsTUFBTSxFQUFFLE1BQU0sRUFBRSxFQUFFLFNBQVMsRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDO1lBQ25ELGtEQUFrRDtZQUNsRCxNQUFNLEVBQUUsQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxNQUFNLEVBQUUsUUFBUSxDQUFDLENBQUMsQ0FBQztRQUMvQyxDQUFDO1FBRUQsQ0FBQyxlQUFlLEVBQUUsa0JBQWtCLENBQUMsQ0FBQyxPQUFPLENBQUMsQ0FBQyxJQUFJLEVBQUUsRUFBRTtZQUNyRCxJQUFJLENBQUM7Z0JBQ0gsRUFBRSxDQUFDLFFBQVEsQ0FDVCxJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsRUFDM0IsSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLEVBQUUsSUFBSSxDQUFDLENBQy9CLENBQUM7WUFDSixDQUFDO1lBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztnQkFDWCxnQkFBTSxDQUFDLEtBQUssQ0FBQyxrQkFBa0IsSUFBSSxLQUFLLENBQUMsRUFBRSxDQUFDLENBQUM7WUFDL0MsQ0FBQztRQUNILENBQUMsQ0FBQyxDQUFDO0lBQ0wsQ0FBQyxDQUFDLENBQUM7QUFDTCxDQUFDO0FBcktELG9EQXFLQztBQWVELE1BQWEsZUFBZTtJQUsxQixZQUNtQixPQUFtQixFQUNuQixlQUF3QixFQUN4QixrQkFHSyxLQUFLLElBQUksRUFBRSxHQUFFLENBQUM7UUFMbkIsWUFBTyxHQUFQLE9BQU8sQ0FBWTtRQUNuQixvQkFBZSxHQUFmLGVBQWUsQ0FBUztRQUN4QixvQkFBZSxHQUFmLGVBQWUsQ0FHSTtRQUVwQyxJQUFJLENBQUMsZUFBZSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUNsRSxFQUFFLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxlQUFlLENBQUMsQ0FBQztRQUNwQyxJQUFJLENBQUMsSUFBSSxHQUFHLElBQUkscUJBQVMsRUFBRSxDQUFDO1FBQzVCLElBQUksQ0FBQyxRQUFRLEdBQUcsRUFBRSxDQUFDO0lBQ3JCLENBQUM7SUFDTyxLQUFLLENBQUMsMEJBQTBCLENBQ3RDLE1BQXFDLEVBQ3JDLE1BQXNCO1FBRXRCLE1BQU0sVUFBVSxHQUFHLElBQUEscUJBQVcsRUFBQywyQkFBMkIsTUFBTSxDQUFDLElBQUksRUFBRSxDQUFDLENBQUM7UUFDekUsTUFBTSxTQUFTLEdBQUcsSUFBSSwrQ0FBMEIsQ0FBQyxJQUFJLENBQUMsSUFBSSxFQUFFLE1BQU0sQ0FBQyxDQUFDO1FBQ3BFLFNBQVMsQ0FBQyxRQUFRLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFM0IsSUFBSSxDQUFDLFFBQVEsR0FBRyxFQUFFLEdBQUcsSUFBSSxDQUFDLFFBQVEsRUFBRSxHQUFHLFNBQVMsQ0FBQyxRQUFRLEVBQUUsQ0FBQztRQUM1RCxVQUFVLEVBQUUsQ0FBQztJQUNmLENBQUM7SUFFTSxLQUFLLENBQUMsc0JBQXNCLENBQ2pDLFdBQTRDO1FBRTVDLElBQUksZUFBZSxHQUFHLElBQUksQ0FBQztRQUMzQixJQUFJLENBQUM7WUFDSCxlQUFlLEdBQUcsTUFBTSxFQUFFLENBQUMsUUFBUSxDQUNqQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsa0JBQWtCLENBQUMsRUFDbkQsTUFBTSxDQUNQLENBQUM7UUFDSixDQUFDO1FBQUMsT0FBTyxDQUFDLEVBQUUsQ0FBQztZQUNYLGdCQUFNLENBQUMsS0FBSyxDQUNWLHlEQUF5RCxDQUFDLG9GQUFvRixDQUMvSSxDQUFDO1lBQ0YsT0FBTyxXQUFXLENBQUM7UUFDckIsQ0FBQztRQUNELGdCQUFNLENBQUMsS0FBSyxDQUFDLGdDQUFnQyxlQUFlLEVBQUUsQ0FBQyxDQUFDO1FBRWhFLElBQUksbUJBQW1CLEdBQTRCLEVBQUUsQ0FBQztRQUN0RCxJQUFJLENBQUM7WUFDSCxtQkFBbUIsR0FBRyxJQUFJLENBQUMsS0FBSyxDQUFDLGVBQWUsQ0FBQyxDQUFDO1FBQ3BELENBQUM7UUFBQyxPQUFPLENBQUMsRUFBRSxDQUFDO1lBQ1gsZ0JBQU0sQ0FBQyxJQUFJLENBQ1QsMERBQTBELENBQUMsK0JBQStCLENBQzNGLENBQUM7WUFDRixPQUFPLFdBQVcsQ0FBQztRQUNyQixDQUFDO1FBRUQsZ0JBQU0sQ0FBQyxLQUFLLENBQ1YsK0JBQStCLElBQUksQ0FBQyxTQUFTLENBQzNDLG1CQUFtQixFQUNuQixJQUFJLEVBQ0osQ0FBQyxDQUNGLEVBQUUsQ0FDSixDQUFDO1FBRUYsSUFDRSxDQUFDLG1CQUFtQixDQUFDLFNBQVM7WUFDOUIsT0FBTyxtQkFBbUIsQ0FBQyxTQUFTLEtBQUssUUFBUSxFQUNqRCxDQUFDO1lBQ0QsZ0JBQU0sQ0FBQyxJQUFJLENBQ1QsMkdBQTJHLElBQUksQ0FBQyxTQUFTLENBQ3ZILG1CQUFtQixFQUNuQixJQUFJLEVBQ0osQ0FBQyxDQUNGLEVBQUUsQ0FDSixDQUFDO1lBQ0YsT0FBTyxXQUFXLENBQUM7UUFDckIsQ0FBQztRQUVELElBQUksbUJBQW1CLENBQUMsS0FBSyxLQUFLLHlCQUFlLEVBQUUsQ0FBQztZQUNsRCxnQkFBTSxDQUFDLElBQUksQ0FDVCx1RkFBdUYsbUJBQW1CLENBQUMsS0FBSyw0QkFBNEIseUJBQWUsRUFBRSxDQUM5SixDQUFDO1lBQ0YsT0FBTyxXQUFXLENBQUM7UUFDckIsQ0FBQztRQUVELE1BQU0scUJBQXFCLEdBQUcsV0FBVyxDQUFDLE1BQU0sQ0FBQyxDQUFDLFVBQVUsRUFBRSxFQUFFO1lBQzlELE1BQU0saUJBQWlCLEdBQ3JCLG1CQUFtQixDQUFDLFNBQVUsQ0FBQyxVQUFVLENBQUMsR0FBRyxDQUFDLEtBQUssVUFBVSxDQUFDLE9BQU8sQ0FBQztZQUN4RSxJQUFJLG9CQUFvQixHQUFHLEtBQUssQ0FBQztZQUVqQyxRQUFRLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLENBQUM7Z0JBQ3BDLEtBQUssa0JBQVEsQ0FBQyxVQUFVO29CQUN0QixvQkFBb0IsR0FBRyxFQUFFLENBQUMsVUFBVSxDQUNsQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsV0FBVyxFQUFFLFVBQVUsQ0FBQyxJQUFJLENBQUMsQ0FDOUQsQ0FBQztvQkFDRixNQUFNO2dCQUNSLEtBQUssa0JBQVEsQ0FBQyxNQUFNLENBQUM7Z0JBQ3JCLEtBQUssa0JBQVEsQ0FBQyxJQUFJLENBQUM7Z0JBQ25CLEtBQUssa0JBQVEsQ0FBQyxNQUFNO29CQUNsQixvQkFBb0IsR0FBRyxFQUFFLENBQUMsVUFBVSxDQUNsQyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsVUFBVSxDQUFDLElBQUksQ0FBQyxDQUNqRCxDQUFDO29CQUNGLE1BQU07Z0JBQ1IsS0FBSyxrQkFBUSxDQUFDLEVBQUU7b0JBQ2Qsb0JBQW9CLEdBQUcsRUFBRSxDQUFDLFVBQVUsQ0FDbEMsSUFBSSxDQUFDLElBQUksQ0FDUCxJQUFJLENBQUMsZUFBZSxFQUNwQixVQUFVLENBQUMsU0FBUyxJQUFJLFdBQVcsRUFDbkMsVUFBVSxDQUFDLElBQUksQ0FDaEIsQ0FDRixDQUFDO29CQUNGLE1BQU07WUFDVixDQUFDO1lBRUQsTUFBTSxjQUFjLEdBQUcsaUJBQWlCLElBQUksb0JBQW9CLENBQUM7WUFDakUsT0FBTyxDQUFDLGNBQWMsQ0FBQztRQUN6QixDQUFDLENBQUMsQ0FBQztRQUVILGdCQUFNLENBQUMsS0FBSyxDQUNWLDRCQUE0QixJQUFJLENBQUMsU0FBUyxDQUN4QyxxQkFBcUIsRUFDckIsSUFBSSxFQUNKLENBQUMsQ0FDRixFQUFFLENBQ0osQ0FBQztRQUVGLE9BQU8scUJBQXFCLENBQUM7SUFDL0IsQ0FBQztJQUVPLEtBQUssQ0FBQyx3QkFBd0IsQ0FDcEMsTUFBbUMsRUFDbkMsTUFBb0I7UUFFcEIsTUFBTSxVQUFVLEdBQUcsSUFBQSxxQkFBVyxFQUFDLDJCQUEyQixNQUFNLENBQUMsSUFBSSxFQUFFLENBQUMsQ0FBQztRQUN6RSxNQUFNLENBQUMsSUFBSSxHQUFHLE1BQU0sQ0FBQztRQUNyQixJQUFJLGtDQUFlLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDLE1BQU0sQ0FBQyxDQUFDLENBQUM7UUFDekMsVUFBVSxFQUFFLENBQUM7SUFDZixDQUFDO0lBRU8sS0FBSyxDQUFDLGtCQUFrQixDQUM5QixNQUE2QixFQUM3QixPQUErQzs7UUFFL0MsSUFBSSxNQUFNLENBQUMsUUFBUSxFQUFFLENBQUM7WUFDcEIsTUFBTSxNQUFNLEdBQUcsTUFBQSxPQUFPLENBQUMsWUFBWSwwQ0FBRyxNQUFNLENBQUMsU0FBUyxDQUFDLENBQUM7WUFDeEQsSUFBSSxDQUFDLE1BQU0sRUFBRSxDQUFDO2dCQUNaLE1BQU0sZ0JBQU0sQ0FBQyxRQUFRLENBQ25CLHdDQUF3QyxNQUFNLENBQUMsU0FBUyxFQUFFLENBQzNELENBQUM7WUFDSixDQUFDO1lBRUQsTUFBTSxJQUFJLENBQUMsd0JBQXdCLENBQ2pDLE1BQXFDLEVBQ3JDLE1BQU0sQ0FDUCxDQUFDO1FBQ0osQ0FBQzthQUFNLElBQUksTUFBTSxDQUFDLFVBQVUsRUFBRSxDQUFDO1lBQzdCLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxFQUFFLENBQUM7Z0JBQzVCLE1BQU0sZ0JBQU0sQ0FBQyxRQUFRLENBQUMseUNBQXlDLENBQUMsQ0FBQztZQUNuRSxDQUFDO1lBRUQsTUFBTSxJQUFJLENBQUMsMEJBQTBCLENBQ25DLE1BQXVDLEVBQ3ZDLE9BQU8sQ0FBQyxjQUFjLENBQ3ZCLENBQUM7UUFDSixDQUFDO2FBQU0sQ0FBQztZQUNOLE1BQU0sSUFBSSxLQUFLLENBQ2Isa0RBQWtELE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FDaEUsQ0FBQztRQUNKLENBQUM7SUFDSCxDQUFDO0lBRUQsbUZBQW1GO0lBQzNFLGtCQUFrQixDQUN4QixrQkFBbUQ7UUFFbkQsZ0JBQU0sQ0FBQyxLQUFLLENBQ1Ysa0RBQWtELElBQUksQ0FBQyxTQUFTLENBQzlELElBQUksQ0FBQyxRQUFRLEVBQ2IsSUFBSSxFQUNKLENBQUMsQ0FDRiw2QkFBNkIsSUFBSSxDQUFDLFNBQVMsQ0FDMUMsa0JBQWtCLEVBQ2xCLElBQUksRUFDSixDQUFDLENBQ0YsRUFBRSxDQUNKLENBQUM7UUFDRixNQUFNLFFBQVEsR0FBRyxlQUFlLENBQUM7UUFDakMsSUFBSSxnQkFBZ0IsR0FBMkIsRUFBRSxDQUFDO1FBQ2xELElBQUksQ0FBQztZQUNILGdCQUFnQixHQUFHLElBQUksQ0FBQyxLQUFLLENBQzNCLEVBQUUsQ0FBQyxZQUFZLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLFFBQVEsQ0FBQyxFQUFFLE1BQU0sQ0FBQyxDQUN0RSxDQUFDO1lBRUYsZ0JBQU0sQ0FBQyxLQUFLLENBQ1YsZ0NBQWdDLElBQUksQ0FBQyxTQUFTLENBQzVDLGdCQUFnQixFQUNoQixJQUFJLEVBQ0osQ0FBQyxDQUNGLEVBQUUsQ0FDSixDQUFDO1FBQ0osQ0FBQztRQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDWCxTQUFTO1lBQ1QsZ0JBQU0sQ0FBQyxLQUFLLENBQ1YsZ0dBQWdHLENBQUMsRUFBRSxDQUNwRyxDQUFDO1FBQ0osQ0FBQztRQUVELE1BQU0sUUFBUSxHQUFHLGtCQUFrQixDQUFDLE1BQU0sQ0FBQyxDQUFDLEdBQUcsRUFBRSxVQUFVLEVBQUUsRUFBRTtZQUM3RCxNQUFNLFFBQVEsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLGdCQUFnQixDQUFDLENBQUMsSUFBSSxDQUFDLENBQUMsQ0FBQyxJQUFJLENBQUMsRUFBRSxFQUFFO1lBQ2hFLDJEQUEyRDtZQUMzRCxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FDOUIsQ0FBQztZQUVGLElBQUksUUFBUSxFQUFFLENBQUM7Z0JBQ2IsTUFBTSxDQUFDLElBQUksRUFBRSxPQUFPLENBQUMsR0FBRyxRQUFRLENBQUM7Z0JBQ2pDLE9BQU8sRUFBRSxHQUFHLEdBQUcsRUFBRSxDQUFDLElBQUksQ0FBQyxFQUFFLE9BQU8sRUFBRSxDQUFDO1lBQ3JDLENBQUM7WUFFRCxPQUFPLEdBQUcsQ0FBQztRQUNiLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQztRQUVQLGdCQUFNLENBQUMsS0FBSyxDQUNWLDBCQUEwQixRQUFRLE1BQU0sSUFBSSxDQUFDLFNBQVMsQ0FDcEQsUUFBUSxFQUNSLElBQUksRUFDSixDQUFDLENBQ0YsRUFBRSxDQUNKLENBQUM7UUFFRixJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUM3QixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLEVBQUUsR0FBRyxRQUFRLEVBQUUsR0FBRyxJQUFJLENBQUMsUUFBUSxFQUFFLEVBQUUsSUFBSSxFQUFFLENBQUMsQ0FBQyxDQUFDLENBQUM7UUFDM0UsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDOUIsT0FBTyxRQUFRLENBQUM7SUFDbEIsQ0FBQztJQUVNLEtBQUssQ0FBQywrQkFBK0IsQ0FDMUMsMEJBQTJEO1FBRTNELGdCQUFNLENBQUMsS0FBSyxDQUNWLGlDQUFpQyxJQUFJLENBQUMsU0FBUyxDQUM3QywwQkFBMEIsRUFDMUIsSUFBSSxFQUNKLENBQUMsQ0FDRixFQUFFLENBQ0osQ0FBQztRQUVGLCtFQUErRTtRQUMvRSwrRUFBK0U7UUFDL0UsZ0RBQWdEO1FBQ2hELElBQUksQ0FBQyxJQUFJLENBQUMsa0JBQWtCLEVBQUUsQ0FBQztZQUM3QixPQUFPO1FBQ1QsQ0FBQztRQUVELElBQUksZ0JBQWdCLEdBQWEsRUFBRSxDQUFDO1FBQ3BDLE1BQU0sZUFBZSxHQUFHLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGVBQWUsRUFBRSxXQUFXLENBQUMsQ0FBQztRQUN4RSxJQUFJLENBQUM7WUFDSCxnQkFBZ0IsR0FBRyxNQUFNLEVBQUUsQ0FBQyxPQUFPLENBQUMsZUFBZSxDQUFDLENBQUM7UUFDdkQsQ0FBQztRQUFDLE9BQU8sQ0FBQyxFQUFFLENBQUM7WUFDWCxnQkFBTSxDQUFDLEtBQUssQ0FDViw0Q0FBNEMsZUFBZSxNQUFNLENBQUMsRUFBRSxDQUNyRSxDQUFDO1FBQ0osQ0FBQztRQUVELE1BQU0sT0FBTyxHQUFHLGdCQUFnQixDQUFDLE1BQU0sQ0FBQyxDQUFDLElBQUksRUFBRSxFQUFFLENBQy9DLEVBQUU7YUFDQyxRQUFRLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLFdBQVcsRUFBRSxJQUFJLENBQUMsQ0FBQzthQUMvRCxXQUFXLEVBQUUsQ0FDakIsQ0FBQztRQUVGLE9BQU8sT0FBTyxDQUFDLE9BQU8sQ0FBQyxDQUFDLE1BQU0sRUFBRSxFQUFFO1lBQ2hDLE1BQU0sV0FBVyxHQUFHLDBCQUEwQixDQUFDLElBQUksQ0FDakQsQ0FBQyxVQUFVLEVBQUUsRUFBRSxDQUFDLFVBQVUsQ0FBQyxJQUFJLEtBQUssTUFBTSxDQUMzQyxDQUFDO1lBRUYsSUFBSSxDQUFDLFdBQVcsRUFBRSxDQUFDO2dCQUNqQixnQkFBTSxDQUFDLEtBQUssQ0FBQyxtQkFBbUIsTUFBTSxpQkFBaUIsQ0FBQyxDQUFDO2dCQUN6RCxFQUFFLENBQUMsVUFBVSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGVBQWUsRUFBRSxXQUFXLEVBQUUsTUFBTSxDQUFDLENBQUMsQ0FBQztZQUN6RSxDQUFDO1FBQ0gsQ0FBQyxDQUFDLENBQUM7SUFDTCxDQUFDO0lBRUQsOEZBQThGO0lBQzlGLG9DQUFvQztJQUM1QixtQkFBbUIsQ0FDekIsa0JBQW1EO1FBRW5ELE1BQU0sUUFBUSxHQUFHLGtCQUFrQixDQUFDO1FBRXBDLE1BQU0sT0FBTyxHQUFtQjtZQUM5QixLQUFLLEVBQUUseUJBQWU7WUFDdEIsU0FBUyxFQUFFLGtCQUFrQjtpQkFDMUIsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsQ0FBQyxDQUFDLEdBQUcsQ0FBQyxDQUFDO2lCQUMxQyxNQUFNLENBQ0wsQ0FBQyxLQUFLLEVBQUUsSUFBSSxFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUNoQixHQUFHLEtBQUs7Z0JBQ1IsQ0FBQyxJQUFJLENBQUMsR0FBRyxDQUFDLEVBQUUsSUFBSSxDQUFDLE9BQU87YUFDekIsQ0FBQyxFQUNGLEVBQUUsQ0FDSDtTQUNKLENBQUM7UUFFRixJQUFJLENBQUMsSUFBSSxDQUFDLFFBQVEsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUM3QixJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsU0FBUyxDQUFDLE9BQU8sRUFBRSxJQUFJLEVBQUUsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUNqRCxJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsQ0FBQyxRQUFRLENBQUMsQ0FBQztRQUM5QixPQUFPLFFBQVEsQ0FBQztJQUNsQixDQUFDO0lBRU8sS0FBSyxDQUFDLG9CQUFvQixDQUFDLE1BQTZCOztRQUM5RCx1REFBdUQ7UUFDdkQsTUFBTSxJQUFJLEdBQUcsQ0FBQyxhQUFhLEVBQUUsWUFBWSxFQUFFLE9BQU8sQ0FBQyxDQUFDO1FBQ3BELE1BQU0sSUFBSSxHQUF3QjtZQUNoQyxVQUFVLEVBQUUsTUFBTSxDQUFDLFFBQVE7WUFDM0IsSUFBSSxFQUFFLElBQUksQ0FBQyxHQUFHLENBQUMsQ0FBQyxHQUFHLEVBQUUsRUFBRSxDQUNyQixJQUFJLENBQUMsT0FBTyxDQUFDLE9BQU8sQ0FBQyxPQUFPLENBQUMsR0FBRyxHQUFHLGVBQWUsQ0FBQyxDQUFDLENBQ3JEO1lBQ0QsU0FBUyxFQUFFLE1BQU0sQ0FBQyxTQUFTO1lBQzNCLE9BQU8sRUFBRSxNQUFNLENBQUMsVUFBVSxDQUFDLGdFQUFnRTtnQkFDekYsQ0FBQyxDQUFDO29CQUNFLEdBQUcsRUFBRTt3QkFDSCxNQUFNLEVBQUUsZUFBZSxNQUFNLENBQUMsSUFBSSxXQUFXO3dCQUM3QyxPQUFPLEVBQUUsZUFBZSxNQUFNLENBQUMsSUFBSSxnQkFBZ0I7cUJBQ3BEO2lCQUNGO2dCQUNILENBQUMsQ0FBQyxTQUFTO1NBQ2QsQ0FBQztRQUVGLG9CQUFvQjtRQUNwQixJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDNUIsSUFBSSxDQUFDLElBQUksR0FBRyxFQUFFLElBQUksRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxDQUFDO1FBQ2hELENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxjQUFjLEVBQUUsQ0FBQztZQUN4QixJQUFJLENBQUMsTUFBTSxHQUFHO2dCQUNaLE1BQU0sRUFBRSxJQUFJLENBQUMsZUFBZTtnQkFDNUIsVUFBVSxFQUFFLE1BQU0sQ0FBQyxVQUFVO2FBQzlCLENBQUM7UUFDSixDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsWUFBWSxFQUFFLENBQUM7WUFDdEIsSUFDRSxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsR0FBRyxDQUFDO2dCQUMxQyxJQUFJLENBQUMsT0FBTyxDQUFDLGVBQWUsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLEVBQzNDLENBQUM7Z0JBQ0QsTUFBTSxnQkFBTSxDQUFDLEtBQUssQ0FDaEIsa1ZBQWtWLENBQ25WLENBQUM7WUFDSixDQUFDO1lBRUQsSUFBSSxDQUFDLElBQUksR0FBRztnQkFDVixNQUFNLEVBQUUsR0FBRyxFQUFFLHdFQUF3RTtnQkFDckYsT0FBTyxFQUFFLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxlQUFlLElBQUksTUFBTSxDQUFDLFVBQVUsRUFBRTthQUNoRSxDQUFDO1FBQ0osQ0FBQztRQUVELElBQUksSUFBSSxDQUFDLGNBQWMsRUFBRSxDQUFDO1lBQ3hCLElBQUksQ0FBQyxNQUFNLEdBQUc7Z0JBQ1osTUFBTSxFQUFFLElBQUksQ0FBQyxlQUFlO2dCQUM1QixTQUFTLEVBQUUsTUFBTSxDQUFDLFVBQVU7YUFDN0IsQ0FBQztRQUNKLENBQUM7UUFFRCxJQUFJLElBQUksQ0FBQyxVQUFVLEVBQUUsQ0FBQztZQUNwQiw0Q0FBNEM7WUFDNUMsZ0VBQWdFO1lBRWhFLDhFQUE4RTtZQUM5RSxnREFBZ0Q7WUFDaEQsTUFBTSxNQUFNLEdBQUcsSUFBSSxDQUFDLElBQUksQ0FBQyxJQUFJLENBQUMsZUFBZSxFQUFFLE1BQUEsTUFBTSxDQUFDLFNBQVMsbUNBQUksRUFBRSxDQUFDLENBQUM7WUFFdkUsSUFBSSxDQUFDLE1BQU0sR0FBRztnQkFDWixNQUFNO2dCQUNOLFVBQVUsRUFBRSxNQUFNLElBQUEsNkJBQXFCLEVBQUMsTUFBTSxDQUFDLEVBQUUsbURBQW1EO2dCQUNwRyxXQUFXLEVBQUUsTUFBTSxDQUFDLFVBQVUsRUFBRSx5REFBeUQ7YUFDMUYsQ0FBQztRQUNKLENBQUM7UUFFRCxJQUNFLE9BQU8sQ0FBQyxHQUFHLENBQUMsWUFBWTtZQUN4QixDQUFDLE9BQU8sQ0FBQyxHQUFHLENBQUMsWUFBWSxDQUFDLFFBQVEsQ0FBQyxzQkFBc0IsQ0FBQyxFQUMxRCxDQUFDO1lBQ0QsZ0JBQU0sQ0FBQyxJQUFJLENBQUM7OztzSEFHb0csQ0FBQyxDQUFDO1FBQ3BILENBQUM7YUFBTSxDQUFDO1lBQ04sbUZBQW1GO1lBQ25GLDBHQUEwRztZQUMxRyxPQUFPLENBQUMsR0FBRyxDQUFDLFlBQVksR0FBRyw0QkFBNEIsQ0FBQztRQUMxRCxDQUFDO1FBRUQsTUFBTSxTQUFTLEdBQUcsSUFBQSxxQkFBVyxFQUFDLE1BQU0sQ0FBQyxDQUFDO1FBQ3RDLE1BQU0sb0JBQW9CLENBQUMsSUFBSSxDQUFDLElBQUksRUFBRSxJQUFJLEVBQUUsSUFBSSxDQUFDLGVBQWUsRUFBRTtZQUNoRSxNQUFNLENBQUMsUUFBUSxDQUFDLENBQUMsQ0FBQyxjQUFjLENBQUMsQ0FBQyxDQUFDLFlBQVk7U0FDaEQsQ0FBQyxDQUFDO1FBQ0gsU0FBUyxFQUFFLENBQUM7SUFDZCxDQUFDO0lBRU0sS0FBSyxDQUFDLFVBQVUsQ0FBQyxPQUF3QztRQUM5RCxPQUFPLE1BQU0sSUFBQSw0QkFBVSxFQUFDLE9BQU8sRUFBRSxJQUFJLENBQUMsZUFBZSxDQUFDLENBQUM7SUFDekQsQ0FBQztJQUVNLEtBQUssQ0FBQyxRQUFRLENBQ25CLGNBQStDLEVBQy9DLHFCQUFxQixHQUFHLGNBQWM7UUFFdEMsTUFBTSxPQUFPLEdBQUcscUJBQXFCLENBQUMsR0FBRyxDQUFDLENBQUMsVUFBVSxFQUFFLEVBQUUsQ0FDdkQsK0JBQXFCLENBQUMsSUFBSSxDQUFDLFVBQVUsRUFBRSxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsQ0FBQyxDQUNwRSxDQUFDO1FBRUYsTUFBTSxjQUFjLEdBQUcsSUFBQSxxQkFBVyxFQUFDLGtCQUFrQixDQUFDLENBQUM7UUFDdkQsTUFBTSxPQUFPLEdBQUcsTUFBTSxJQUFJLENBQUMsVUFBVSxDQUFDLHFCQUFxQixDQUFDLENBQUM7UUFDN0QsY0FBYyxFQUFFLENBQUM7UUFFakIsTUFBTSxnQkFBZ0IsR0FBRyxJQUFBLHFCQUFXLEVBQUMsYUFBYSxDQUFDLENBQUM7UUFDcEQsTUFBTSxPQUFPLENBQUMsR0FBRyxDQUNmLE9BQU8sQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEVBQUUsRUFBRSxDQUFDLElBQUksQ0FBQyxrQkFBa0IsQ0FBQyxNQUFNLEVBQUUsT0FBTyxDQUFDLENBQUMsQ0FDbEUsQ0FBQztRQUNGLGdCQUFnQixFQUFFLENBQUM7UUFFbkIsSUFBSSxDQUFDLGtCQUFrQixDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBQ3hDLElBQUksQ0FBQyxtQkFBbUIsQ0FBQyxjQUFjLENBQUMsQ0FBQztRQUV6QyxJQUFJLElBQUksQ0FBQyxrQkFBa0IsRUFBRSxDQUFDO1lBQzVCLE1BQU0sSUFBSSxDQUFDLElBQUksRUFBRSxDQUFDO1FBQ3BCLENBQUM7UUFFRCxJQUFJLENBQUMsSUFBSSxDQUFDLGtCQUFrQixJQUFJLElBQUksQ0FBQyxPQUFPLENBQUMsVUFBVSxFQUFFLENBQUM7WUFDeEQsTUFBTSxlQUFlLEdBQUcsSUFBSSxDQUFDLEdBQUcsQ0FDOUIsQ0FBQyxFQUNELElBQUksQ0FBQyxPQUFPLENBQUMsZUFBZSxLQUFLLENBQUMsQ0FBQztnQkFDakMsQ0FBQyxDQUFDLE9BQU8sQ0FBQyxNQUFNO2dCQUNoQixDQUFDLENBQUMsSUFBSSxDQUFDLE9BQU8sQ0FBQyxlQUFlLElBQUksQ0FBQyxDQUN0QyxDQUFDO1lBRUYsTUFBTSxJQUFJLEdBQUcsQ0FBQyxHQUFHLE9BQU8sQ0FBQyxDQUFDO1lBQzFCLE1BQU0sT0FBTyxHQUFHLElBQUksS0FBSyxDQUFDLGVBQWUsQ0FBQyxDQUFDLElBQUksQ0FBQyxLQUFLLElBQUksRUFBRTtnQkFDekQsSUFBSSxNQUF5QyxDQUFDO2dCQUM5QyxPQUFPLENBQUMsTUFBTSxHQUFHLElBQUksQ0FBQyxHQUFHLEVBQUUsQ0FBQyxFQUFFLENBQUM7b0JBQzdCLE1BQU0sYUFBYSxHQUFHLElBQUEscUJBQVcsRUFDL0IsZ0NBQWdDLE1BQU0sQ0FBQyxJQUFJLEVBQUUsQ0FDOUMsQ0FBQztvQkFDRixNQUFNLElBQUksQ0FBQyxvQkFBb0IsQ0FBQyxNQUFNLENBQUMsQ0FBQztvQkFDeEMsYUFBYSxFQUFFLENBQUM7Z0JBQ2xCLENBQUM7WUFDSCxDQUFDLENBQUMsQ0FBQztZQUVILE1BQU0sT0FBTyxDQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsR0FBRyxDQUFDLENBQUMsRUFBRSxFQUFFLEVBQUUsQ0FBQyxFQUFFLEVBQUUsQ0FBQyxDQUFDLENBQUM7UUFDL0MsQ0FBQztRQUVELEtBQUssTUFBTSxNQUFNLElBQUksT0FBTyxFQUFFLENBQUM7WUFDN0IsTUFBTSxJQUFJLENBQUMsZUFBZSxDQUFDO2dCQUN6QixlQUFlLEVBQUUsTUFBTSxDQUFDLGVBQWU7Z0JBQ3ZDLGNBQWMsRUFBRSxNQUFNLENBQUMsY0FBYzthQUN0QyxDQUFDLENBQUM7UUFDTCxDQUFDO1FBRUQsSUFBSSxJQUFJLENBQUMsY0FBYyxFQUFFLENBQUM7WUFDeEIsTUFBTSxjQUFjLEdBQUcsSUFBQSxxQkFBVyxFQUFDLHdCQUF3QixDQUFDLENBQUM7WUFDN0Qsa0VBQWtFO1lBQ2xFLHFHQUFxRztZQUNyRyxNQUFNLGNBQWMsR0FBRyxXQUFJO2lCQUN4QixJQUFJLENBQUMsZ0JBQWdCLEVBQUU7Z0JBQ3RCLEdBQUcsRUFBRSxJQUFJLENBQUMsZUFBZTthQUMxQixDQUFDO2dCQUNGLHVEQUF1RDtpQkFDdEQsSUFBSSxDQUFDLENBQUMsQ0FBQyxFQUFFLENBQUMsRUFBRSxFQUFFLENBQUMsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLEtBQUssQ0FBQyxHQUFHLENBQUMsQ0FBQyxNQUFNLENBQUMsQ0FBQztZQUU3RCxNQUFNLGtCQUFrQixHQUFhLEVBQUUsQ0FBQztZQUN4QyxLQUFLLE1BQU0sVUFBVSxJQUFJLGNBQWMsRUFBRSxDQUFDO2dCQUN4QyxNQUFNLGFBQWEsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO2dCQUMvQyxJQUFJLGtCQUFrQixDQUFDLElBQUksQ0FBQyxDQUFDLEdBQUcsRUFBRSxFQUFFLENBQUMsYUFBYSxDQUFDLFVBQVUsQ0FBQyxHQUFHLENBQUMsQ0FBQyxFQUFFLENBQUM7b0JBQ3BFLHNDQUFzQztvQkFDdEMsU0FBUztnQkFDWCxDQUFDO2dCQUNELGtCQUFrQixDQUFDLElBQUksQ0FBQyxhQUFhLENBQUMsQ0FBQztnQkFFdkMsTUFBTSxrQkFBa0IsR0FBRyxJQUFJLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxlQUFlLEVBQUUsVUFBVSxDQUFDLENBQUM7Z0JBQ3ZFLE1BQU0sTUFBTSxHQUFHLE1BQU0sRUFBRSxDQUFDLFFBQVEsQ0FBQyxrQkFBa0IsRUFBRSxNQUFNLENBQUMsQ0FBQztnQkFDN0QsTUFBTSxvQkFBb0IsR0FBRyxNQUFNLENBQUMsT0FBTyxDQUFDLHNCQUFzQixFQUFFLEVBQUUsQ0FBQyxDQUFDO2dCQUN4RSxNQUFNLEVBQUUsQ0FBQyxTQUFTLENBQUMsa0JBQWtCLEVBQUUsb0JBQW9CLENBQUMsQ0FBQztZQUMvRCxDQUFDO1lBRUQsY0FBYyxFQUFFLENBQUM7UUFDbkIsQ0FBQztJQUNILENBQUM7SUFFTyxLQUFLLENBQUMsSUFBSSxDQUFDLE1BQU0sR0FBRyxJQUFJLENBQUMsZUFBZTtRQUM5QyxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsSUFBSSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQy9CLENBQUM7SUFFRCxJQUFZLGtCQUFrQjtRQUM1QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxLQUFLLGtCQUFRLENBQUMsVUFBVSxDQUFDO0lBQzdELENBQUM7SUFFRCxJQUFZLGNBQWM7UUFDeEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsS0FBSyxrQkFBUSxDQUFDLE1BQU0sQ0FBQztJQUN6RCxDQUFDO0lBRUQsSUFBWSxZQUFZO1FBQ3RCLE9BQU8sSUFBSSxDQUFDLE9BQU8sQ0FBQyxjQUFjLEtBQUssa0JBQVEsQ0FBQyxJQUFJLENBQUM7SUFDdkQsQ0FBQztJQUVELElBQVksY0FBYztRQUN4QixPQUFPLElBQUksQ0FBQyxPQUFPLENBQUMsY0FBYyxLQUFLLGtCQUFRLENBQUMsTUFBTSxDQUFDO0lBQ3pELENBQUM7SUFFRCxJQUFZLFVBQVU7UUFDcEIsT0FBTyxJQUFJLENBQUMsT0FBTyxDQUFDLGNBQWMsS0FBSyxrQkFBUSxDQUFDLEVBQUUsQ0FBQztJQUNyRCxDQUFDO0NBQ0Y7QUE5ZkQsMENBOGZDO0FBRUQ7Ozs7Ozs7R0FPRztBQUNJLE1BQU0scUJBQXFCLEdBQUcsS0FBSyxFQUFFLEdBQVcsRUFBbUIsRUFBRTtJQUMxRSxJQUFJLFdBQVcsQ0FBQztJQUNoQixJQUFJLFVBQVUsR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBRW5DLEdBQUcsQ0FBQztRQUNGLElBQUksS0FBSyxHQUFhLEVBQUUsQ0FBQztRQUN6QixJQUFJLENBQUM7WUFDSCxLQUFLLEdBQUcsTUFBTSxFQUFFLENBQUMsT0FBTyxDQUFDLFVBQVUsQ0FBQyxDQUFDO1FBQ3ZDLENBQUM7UUFBQyxPQUFPLENBQU0sRUFBRSxDQUFDO1lBQ2hCLDBGQUEwRjtZQUMxRixJQUFJLENBQUMsQ0FBQyxJQUFJLEtBQUssUUFBUSxFQUFFLENBQUM7Z0JBQ3hCLE1BQU0sQ0FBQyxDQUFDO1lBQ1YsQ0FBQztRQUNILENBQUM7UUFDRCxJQUFJLEtBQUssQ0FBQyxRQUFRLENBQUMsUUFBUSxDQUFDLEVBQUUsQ0FBQztZQUM3QixNQUFNLElBQUksR0FBRyxJQUFJLENBQUMsT0FBTyxDQUFDLFVBQVUsRUFBRSxRQUFRLENBQUMsQ0FBQztZQUNoRCxNQUFNLEtBQUssR0FBRyxNQUFNLEVBQUUsQ0FBQyxRQUFRLENBQUMsSUFBSSxDQUFDLENBQUM7WUFDdEMsTUFBTSxLQUFLLEdBQUcsc0JBQXNCLENBQUMsSUFBSSxDQUFDLEtBQUssQ0FBQyxRQUFRLEVBQUUsQ0FBQyxDQUFDO1lBQzVELElBQUksS0FBSyxJQUFJLEtBQUssQ0FBQyxDQUFDLENBQUMsRUFBRSxDQUFDO2dCQUN0QixNQUFNLFFBQVEsR0FBRyxJQUFJLENBQUMsUUFBUSxDQUFDLFVBQVUsRUFBRSxHQUFHLENBQUMsQ0FBQyxPQUFPLENBQUMsS0FBSyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUMseUNBQXlDO2dCQUM5RyxPQUFPLFFBQVEsQ0FBQyxNQUFNLEdBQUcsQ0FBQyxDQUFDLENBQUMsQ0FBQyxHQUFHLEtBQUssQ0FBQyxDQUFDLENBQUMsSUFBSSxRQUFRLEVBQUUsQ0FBQyxDQUFDLENBQUMsS0FBSyxDQUFDLENBQUMsQ0FBQyxDQUFDO1lBQ3BFLENBQUM7WUFDRCxNQUFNLElBQUksS0FBSyxDQUNiLHNEQUFzRCxJQUFJLHNEQUFzRCxDQUNqSCxDQUFDO1FBQ0osQ0FBQztRQUNELDBFQUEwRTtRQUMxRSw4Q0FBOEM7UUFDOUMsV0FBVyxHQUFHLFVBQVUsQ0FBQztRQUN6QixVQUFVLEdBQUcsSUFBSSxDQUFDLE9BQU8sQ0FBQyxVQUFVLENBQUMsQ0FBQztJQUN4QyxDQUFDLFFBQVEsVUFBVSxLQUFLLFdBQVcsRUFBRTtJQUVyQyxNQUFNLElBQUksS0FBSyxDQUNiLG1FQUFtRSxHQUFHLDZCQUE2QixDQUNwRyxDQUFDO0FBQ0osQ0FBQyxDQUFDO0FBbkNXLFFBQUEscUJBQXFCLHlCQW1DaEMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuaW1wb3J0ICogYXMgZnMgZnJvbSBcImZzLWV4dHJhXCI7XG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gXCJwYXRoXCI7XG5pbXBvcnQgeyBDb2RlTWFrZXIgfSBmcm9tIFwiY29kZW1ha2VyXCI7XG5pbXBvcnQgeyBleGVjLCBta2R0ZW1wIH0gZnJvbSBcIkBjZGt0Zi9jb21tb25zXCI7XG5pbXBvcnQge1xuICBUZXJyYWZvcm1EZXBlbmRlbmN5Q29uc3RyYWludCxcbiAgbG9nZ2VyLFxuICBsb2dUaW1lc3BhbixcbiAgQ29uc3RydWN0c01ha2VyUHJvdmlkZXJUYXJnZXQsXG4gIENvbnN0cnVjdHNNYWtlck1vZHVsZVRhcmdldCxcbiAgQ29uc3RydWN0c01ha2VyVGFyZ2V0LFxuICBQcm92aWRlclNjaGVtYSxcbiAgTW9kdWxlU2NoZW1hLFxuICBFcnJvcnMsXG59IGZyb20gXCJAY2RrdGYvY29tbW9uc1wiO1xuaW1wb3J0IHsgRElTUExBWV9WRVJTSU9OLCBMYW5ndWFnZSB9IGZyb20gXCJAY2RrdGYvY29tbW9uc1wiO1xuaW1wb3J0IHsgVGVycmFmb3JtUHJvdmlkZXJHZW5lcmF0b3IgfSBmcm9tIFwiLi9nZW5lcmF0b3IvcHJvdmlkZXItZ2VuZXJhdG9yXCI7XG5pbXBvcnQgeyBNb2R1bGVHZW5lcmF0b3IgfSBmcm9tIFwiLi9nZW5lcmF0b3IvbW9kdWxlLWdlbmVyYXRvclwiO1xuaW1wb3J0IHsgZ2xvYiB9IGZyb20gXCJnbG9iXCI7XG5pbXBvcnQgeyByZWFkU2NoZW1hIH0gZnJvbSBcIkBjZGt0Zi9wcm92aWRlci1zY2hlbWFcIjtcblxuY29uc3QgcGFjbWFrTW9kdWxlID0gcmVxdWlyZS5yZXNvbHZlKFwianNpaS1wYWNtYWsvYmluL2pzaWktcGFjbWFrXCIpO1xuY29uc3QganNpaU1vZHVsZSA9IHJlcXVpcmUucmVzb2x2ZShcImpzaWkvYmluL2pzaWlcIik7XG5cbmV4cG9ydCBpbnRlcmZhY2UgR2VuZXJhdGVKU0lJT3B0aW9ucyB7XG4gIGVudHJ5cG9pbnQ6IHN0cmluZztcbiAgZGVwczogc3RyaW5nW107XG4gIG1vZHVsZUtleTogc3RyaW5nO1xuICBleHBvcnRzPzogUmVjb3JkPHN0cmluZywgRXhwb3J0RGVmaW5pdGlvbiB8IHN0cmluZz47XG4gIGpzaWk/OiBKc2lpT3V0cHV0T3B0aW9ucztcbiAgcHl0aG9uPzogUHl0aG9uT3V0cHV0T3B0aW9ucztcbiAgamF2YT86IEphdmFPdXRwdXRPcHRpb25zO1xuICBjc2hhcnA/OiBDU2hhcnBPdXRwdXRPcHRpb25zO1xuICBnb2xhbmc/OiBHb0xhbmdPdXRwdXRPcHRpb25zO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEpzaWlPdXRwdXRPcHRpb25zIHtcbiAgcGF0aDogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIFB5dGhvbk91dHB1dE9wdGlvbnMge1xuICBvdXRkaXI6IHN0cmluZztcbiAgbW9kdWxlTmFtZTogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEphdmFPdXRwdXRPcHRpb25zIHtcbiAgb3V0ZGlyOiBzdHJpbmc7XG4gIHBhY2thZ2U6IHN0cmluZztcbn1cblxuZXhwb3J0IGludGVyZmFjZSBDU2hhcnBPdXRwdXRPcHRpb25zIHtcbiAgb3V0ZGlyOiBzdHJpbmc7XG4gIG5hbWVzcGFjZTogc3RyaW5nO1xufVxuXG5leHBvcnQgaW50ZXJmYWNlIEdvTGFuZ091dHB1dE9wdGlvbnMge1xuICBvdXRkaXI6IHN0cmluZztcbiAgbW9kdWxlTmFtZTogc3RyaW5nO1xuICBwYWNrYWdlTmFtZTogc3RyaW5nO1xufVxuXG4vKipcbiAqIFNlZSBodHRwczovL25vZGVqcy5vcmcvYXBpL3BhY2thZ2VzLmh0bWwjY29uZGl0aW9uYWwtZXhwb3J0cyBmb3IgbW9yZSBpbmZvcm1hdGlvblxuICovXG5leHBvcnQgaW50ZXJmYWNlIEV4cG9ydERlZmluaXRpb24ge1xuICBub2RlPzogc3RyaW5nO1xuICBpbXBvcnQ/OiBzdHJpbmc7XG4gIHJlcXVpcmU/OiBzdHJpbmc7XG4gIGRlZmF1bHQ/OiBzdHJpbmc7XG59XG5cbmV4cG9ydCBhc3luYyBmdW5jdGlvbiBnZW5lcmF0ZUpzaWlMYW5ndWFnZShcbiAgY29kZTogQ29kZU1ha2VyLFxuICBvcHRzOiBHZW5lcmF0ZUpTSUlPcHRpb25zLFxuICBvdXRwdXRQYXRoOiBzdHJpbmcsXG4gIGRpc2FsbG93ZWRGaWxlR2xvYnM6IHN0cmluZ1tdID0gW10sXG4pIHtcbiAgYXdhaXQgbWtkdGVtcChhc3luYyAoc3RhZ2luZykgPT4ge1xuICAgIC8vIHRoaXMgaXMgbm90IHR5cGVzY3JpcHQsIHNvIHdlIGdlbmVyYXRlIGluIGEgc3RhZ2luZyBkaXJlY3RvcnkgYW5kXG4gICAgLy8gdXNlIGpzaWktc3JjbWFrIHRvIGNvbXBpbGUgYW5kIGV4dHJhY3QgdGhlIGxhbmd1YWdlLXNwZWNpZmljIHNvdXJjZVxuICAgIC8vIGludG8gb3VyIHByb2plY3QuXG4gICAgYXdhaXQgY29kZS5zYXZlKHN0YWdpbmcpO1xuXG4gICAgLy8gYXMgdGhlIGFib3ZlIGdlbmVyYXRlZCB0aGUgVHlwZXNjcmlwdCBjb2RlIGZvciBhbGwgcHJvdmlkZXJzIGFuZCBtb2R1bGVzLFxuICAgIC8vIHdlIG5lZWQgdG8gZmlsdGVyIG91dCB0aGUgb25lcyB3ZSBkb24ndCBuZWVkIHNvIHRoZXkgZG9uJ3QgZW5kIHVwIGluIHRoZSBKU0lJIGJ1bmRsZSBvdmVyIGFuZCBvdmVyIGFnYWluLlxuICAgIGNvbnN0IGZpbGVzVG9EZWxldGUgPSBkaXNhbGxvd2VkRmlsZUdsb2JzLmZsYXRNYXAoKHBhdHRlcm4pID0+XG4gICAgICBnbG9iLnN5bmMocGF0dGVybiwgeyBjd2Q6IHN0YWdpbmcgfSksXG4gICAgKTtcbiAgICBhd2FpdCBQcm9taXNlLmFsbChcbiAgICAgIGZpbGVzVG9EZWxldGUubWFwKChmaWxlKSA9PiBmcy5yZW1vdmUocGF0aC5qb2luKHN0YWdpbmcsIGZpbGUpKSksXG4gICAgKTtcblxuICAgIC8vIENvbXBpbGUgd2l0aCBKU0lJXG4gICAgY29uc3QganNpaUFyZ3MgPSBbXCItLXNpbGVuY2Utd2FybmluZ3NcIiwgXCJyZXNlcnZlZC13b3JkXCJdO1xuICAgIGNvbnN0IGpzaWlFbnRyeXBvaW50ID0gb3B0cy5lbnRyeXBvaW50O1xuICAgIGNvbnN0IGJhc2VwYXRoID0gcGF0aC5qb2luKFxuICAgICAgcGF0aC5kaXJuYW1lKGpzaWlFbnRyeXBvaW50KSxcbiAgICAgIHBhdGguYmFzZW5hbWUoanNpaUVudHJ5cG9pbnQsIFwiLnRzXCIpLFxuICAgICk7XG5cbiAgICBjb25zdCBtb2R1bGVLZXkgPSBvcHRzLm1vZHVsZUtleS5yZXBsYWNlKC9cXC4vZywgXCJcIikucmVwbGFjZSgvXFwvL2csIFwiXCIpO1xuICAgIGNvbnN0IG1vZHVsZURpcnMgPSBvcHRzLmRlcHM7XG4gICAgY29uc3QgdGFyZ2V0czogUmVjb3JkPHN0cmluZywgYW55PiA9IHt9O1xuICAgIGNvbnN0IGRlcHM6IFJlY29yZDxzdHJpbmcsIHN0cmluZz4gPSB7fTtcbiAgICBmb3IgKGNvbnN0IGRpciBvZiBtb2R1bGVEaXJzKSB7XG4gICAgICAvLyByZWFkIG1vZHVsZSBtZXRhZGF0YVxuICAgICAgY29uc3QgbWV0YWRhdGEgPSBhd2FpdCBmcy5yZWFkSnNvbihwYXRoLmpvaW4oZGlyLCBcInBhY2thZ2UuanNvblwiKSk7XG4gICAgICBjb25zdCBtb2R1bGVOYW1lOiBzdHJpbmcgPSBtZXRhZGF0YS5uYW1lO1xuICAgICAgY29uc3QgbW9kdWxlVmVyc2lvbjogc3RyaW5nID0gbWV0YWRhdGEudmVyc2lvbjtcblxuICAgICAgY29uc3QgdGFyZ2V0ZGlyID0gcGF0aC5qb2luKFxuICAgICAgICBwYXRoLmpvaW4oc3RhZ2luZywgXCJub2RlX21vZHVsZXNcIiksXG4gICAgICAgIG1vZHVsZU5hbWUsXG4gICAgICApO1xuICAgICAgYXdhaXQgZnMubWtkaXJwKHBhdGguZGlybmFtZSh0YXJnZXRkaXIpKTtcbiAgICAgIGF3YWl0IGZzLmNvcHkoZGlyLCB0YXJnZXRkaXIpO1xuXG4gICAgICAvLyBhZGQgdG8gXCJkZXBzXCIgYW5kIFwicGVlciBkZXBzXCJcbiAgICAgIGlmICghbW9kdWxlTmFtZS5zdGFydHNXaXRoKFwiQHR5cGVzL1wiKSkge1xuICAgICAgICBkZXBzW21vZHVsZU5hbWVdID0gbW9kdWxlVmVyc2lvbjtcbiAgICAgIH1cbiAgICB9XG4gICAgY29uc3QgcGtnID0ge1xuICAgICAgbmFtZTogbW9kdWxlS2V5LFxuICAgICAgdmVyc2lvbjogXCIwLjAuMFwiLFxuICAgICAgYXV0aG9yOiBcImdlbmVyYXRlZEBnZW5lcmF0ZWQuY29tXCIsXG4gICAgICBtYWluOiBgJHtiYXNlcGF0aH0uanNgLFxuICAgICAgdHlwZXM6IGAke2Jhc2VwYXRofS5kLnRzYCxcbiAgICAgIGxpY2Vuc2U6IFwiVU5MSUNFTlNFRFwiLFxuICAgICAgcmVwb3NpdG9yeTogeyB1cmw6IFwiaHR0cDovL2dlbmVyYXRlZFwiLCB0eXBlOiBcImdpdFwiIH0sXG4gICAgICBqc2lpOiB7XG4gICAgICAgIG91dGRpcjogXCJkaXN0XCIsXG4gICAgICAgIHRhcmdldHM6IHRhcmdldHMsXG4gICAgICB9LFxuICAgICAgZGVwZW5kZW5jaWVzOiBkZXBzLFxuICAgICAgcGVlckRlcGVuZGVuY2llczogZGVwcyxcbiAgICB9O1xuXG4gICAgaWYgKG9wdHMuZXhwb3J0cykge1xuICAgICAgKHBrZyBhcyBSZWNvcmQ8c3RyaW5nLCBhbnk+KS5leHBvcnRzID0gb3B0cy5leHBvcnRzO1xuICAgIH1cbiAgICBpZiAob3B0cy5weXRob24pIHtcbiAgICAgIHRhcmdldHMucHl0aG9uID0ge1xuICAgICAgICBkaXN0TmFtZTogXCJnZW5lcmF0ZWRcIixcbiAgICAgICAgbW9kdWxlOiBvcHRzLnB5dGhvbi5tb2R1bGVOYW1lLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICBpZiAob3B0cy5qYXZhKSB7XG4gICAgICB0YXJnZXRzLmphdmEgPSB7XG4gICAgICAgIHBhY2thZ2U6IG9wdHMuamF2YS5wYWNrYWdlLFxuICAgICAgICBtYXZlbjoge1xuICAgICAgICAgIGdyb3VwSWQ6IFwiZ2VuZXJhdGVkXCIsXG4gICAgICAgICAgYXJ0aWZhY3RJZDogXCJnZW5lcmF0ZWRcIixcbiAgICAgICAgfSxcbiAgICAgIH07XG4gICAgfVxuXG4gICAgaWYgKG9wdHMuY3NoYXJwKSB7XG4gICAgICB0YXJnZXRzLmRvdG5ldCA9IHtcbiAgICAgICAgbmFtZXNwYWNlOiBvcHRzLmNzaGFycC5uYW1lc3BhY2UsXG4gICAgICAgIHBhY2thZ2VJZDogb3B0cy5jc2hhcnAubmFtZXNwYWNlLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICBpZiAob3B0cy5nb2xhbmcpIHtcbiAgICAgIHRhcmdldHMuZ28gPSB7XG4gICAgICAgIG1vZHVsZU5hbWU6IG9wdHMuZ29sYW5nLm1vZHVsZU5hbWUsXG4gICAgICAgIHBhY2thZ2VOYW1lOiBvcHRzLmdvbGFuZy5wYWNrYWdlTmFtZSxcbiAgICAgIH07XG4gICAgfVxuXG4gICAgYXdhaXQgZnMud3JpdGVGaWxlKFxuICAgICAgcGF0aC5qb2luKHN0YWdpbmcsIFwicGFja2FnZS5qc29uXCIpLFxuICAgICAgSlNPTi5zdHJpbmdpZnkocGtnLCB1bmRlZmluZWQsIDIpLFxuICAgICk7XG5cbiAgICBjb25zdCBlbmRKc2lpVGltZXIgPSBsb2dUaW1lc3BhbihcImpzaWlcIik7XG4gICAgYXdhaXQgZXhlYyhqc2lpTW9kdWxlLCBqc2lpQXJncywge1xuICAgICAgY3dkOiBzdGFnaW5nLFxuICAgIH0pO1xuICAgIGVuZEpzaWlUaW1lcigpO1xuXG4gICAgLy8gZXh0cmFjdCAuanNpaSBpZiByZXF1ZXN0ZWRcbiAgICBpZiAob3B0cy5qc2lpKSB7XG4gICAgICBhd2FpdCBmcy5jb3B5KHBhdGguam9pbihzdGFnaW5nLCBcIi5qc2lpXCIpLCBvcHRzLmpzaWkucGF0aCk7XG4gICAgfVxuXG4gICAgLy8gcnVuIHBhY21hayB0byBnZW5lcmF0ZSBjb2RlXG4gICAgY29uc3QgZW5kSnNpaVBhY21ha1RpbWVyID0gbG9nVGltZXNwYW4oXCJqc2lpLXBhY21ha1wiKTtcbiAgICBhd2FpdCBleGVjKHBhY21ha01vZHVsZSwgW1wiLS1jb2RlLW9ubHlcIl0sIHsgY3dkOiBzdGFnaW5nIH0pO1xuICAgIGVuZEpzaWlQYWNtYWtUaW1lcigpO1xuXG4gICAgaWYgKG9wdHMucHl0aG9uKSB7XG4gICAgICBjb25zdCByZWxkaXIgPSBvcHRzLnB5dGhvbi5tb2R1bGVOYW1lLnJlcGxhY2UoL1xcLi9nLCBcIi9cIik7IC8vIGpzaWkgcmVwbGFjZXMgXCIuXCIgd2l0aCBcIi9cIlxuICAgICAgY29uc3Qgc291cmNlID0gcGF0aC5yZXNvbHZlKFxuICAgICAgICBwYXRoLmpvaW4oc3RhZ2luZywgXCJkaXN0L3B5dGhvbi9zcmNcIiwgcmVsZGlyKSxcbiAgICAgICk7XG4gICAgICBjb25zdCB0YXJnZXQgPSBwYXRoLmpvaW4ob3B0cy5weXRob24ub3V0ZGlyLCByZWxkaXIpO1xuICAgICAgYXdhaXQgZnMubW92ZShzb3VyY2UsIHRhcmdldCwgeyBvdmVyd3JpdGU6IHRydWUgfSk7XG4gICAgfVxuXG4gICAgaWYgKG9wdHMuamF2YSkge1xuICAgICAgY29uc3Qgc291cmNlID0gcGF0aC5yZXNvbHZlKHBhdGguam9pbihzdGFnaW5nLCBcImRpc3QvamF2YS9zcmMvXCIpKTtcbiAgICAgIGNvbnN0IHRhcmdldCA9IHBhdGguam9pbihvcHRzLmphdmEub3V0ZGlyLCBcInNyYy9cIik7XG4gICAgICBhd2FpdCBmcy5ta2RpcnAodGFyZ2V0KTsgLy8gbWFrZSBzdXJlIHRhcmdldCBkaXJlY3RvcnkgZXhpc3RzXG4gICAgICBhd2FpdCBmcy5jb3B5KHNvdXJjZSwgdGFyZ2V0LCB7IHJlY3Vyc2l2ZTogdHJ1ZSwgb3ZlcndyaXRlOiBmYWxzZSB9KTtcbiAgICB9XG5cbiAgICBpZiAob3B0cy5jc2hhcnApIHtcbiAgICAgIGNvbnN0IHJlbGRpciA9IG9wdHMuY3NoYXJwLm5hbWVzcGFjZTtcbiAgICAgIGNvbnN0IHNvdXJjZSA9IHBhdGgucmVzb2x2ZShwYXRoLmpvaW4oc3RhZ2luZywgXCJkaXN0L2RvdG5ldC9cIiwgcmVsZGlyKSk7XG4gICAgICBjb25zdCB0YXJnZXQgPSBwYXRoLmpvaW4ob3B0cy5jc2hhcnAub3V0ZGlyLCByZWxkaXIpO1xuICAgICAgYXdhaXQgZnMubW92ZShzb3VyY2UsIHRhcmdldCwgeyBvdmVyd3JpdGU6IHRydWUgfSk7XG4gICAgfVxuXG4gICAgaWYgKG9wdHMuZ29sYW5nKSB7XG4gICAgICBjb25zdCByZWxkaXIgPSBvcHRzLmdvbGFuZy5wYWNrYWdlTmFtZTtcbiAgICAgIGNvbnN0IHNvdXJjZSA9IHBhdGgucmVzb2x2ZShwYXRoLmpvaW4oc3RhZ2luZywgXCJkaXN0L2dvL1wiLCByZWxkaXIpKTtcbiAgICAgIGNvbnN0IHRhcmdldCA9IHBhdGguam9pbihvcHRzLmdvbGFuZy5vdXRkaXIsIHJlbGRpcik7XG4gICAgICBhd2FpdCBmcy5tb3ZlKHNvdXJjZSwgdGFyZ2V0LCB7IG92ZXJ3cml0ZTogdHJ1ZSB9KTtcbiAgICAgIC8vIHJlbW92ZSBnby5tb2QgYXMgdGhpcyB3b3VsZCBtYWtlIGl0IGEgc3VibW9kdWxlXG4gICAgICBhd2FpdCBmcy5yZW1vdmUocGF0aC5qb2luKHRhcmdldCwgXCJnby5tb2RcIikpO1xuICAgIH1cblxuICAgIFtcInZlcnNpb25zLmpzb25cIiwgXCJjb25zdHJhaW50cy5qc29uXCJdLmZvckVhY2goKGZpbGUpID0+IHtcbiAgICAgIHRyeSB7XG4gICAgICAgIGZzLmNvcHlTeW5jKFxuICAgICAgICAgIHBhdGgucmVzb2x2ZShzdGFnaW5nLCBmaWxlKSxcbiAgICAgICAgICBwYXRoLnJlc29sdmUob3V0cHV0UGF0aCwgZmlsZSksXG4gICAgICAgICk7XG4gICAgICB9IGNhdGNoIChlKSB7XG4gICAgICAgIGxvZ2dlci5kZWJ1ZyhgRmFpbGVkIHRvIGNvcHkgJHtmaWxlfTogJHtlfWApO1xuICAgICAgfVxuICAgIH0pO1xuICB9KTtcbn1cblxudHlwZSBDb25zdHJhaW50RmlsZSA9IHsgcHJvdmlkZXJzOiBSZWNvcmQ8c3RyaW5nLCBzdHJpbmc+OyBjZGt0Zjogc3RyaW5nIH07XG5cbmV4cG9ydCBpbnRlcmZhY2UgR2V0T3B0aW9ucyB7XG4gIHJlYWRvbmx5IHRhcmdldExhbmd1YWdlOiBMYW5ndWFnZTtcbiAgcmVhZG9ubHkgY29kZU1ha2VyT3V0cHV0OiBzdHJpbmc7XG4gIHJlYWRvbmx5IGpzaWlQYXJhbGxlbGlzbT86IG51bWJlcjtcbiAgLyoqXG4gICAqIFBhdGggdG8gY29weSB0aGUgb3V0cHV0IC5qc2lpIGZpbGUuXG4gICAqIEBkZWZhdWx0IC0ganNpaSBmaWxlIGlzIG5vdCBlbWl0dGVkXG4gICAqL1xuICByZWFkb25seSBvdXRwdXRKc2lpPzogc3RyaW5nO1xufVxuXG5leHBvcnQgY2xhc3MgQ29uc3RydWN0c01ha2VyIHtcbiAgcHJpdmF0ZSByZWFkb25seSBjb2RlTWFrZXJPdXRkaXI6IHN0cmluZztcbiAgcHJpdmF0ZSByZWFkb25seSBjb2RlOiBDb2RlTWFrZXI7XG4gIHByaXZhdGUgdmVyc2lvbnM6IHsgW3Byb3ZpZGVyTmFtZTogc3RyaW5nXTogc3RyaW5nIHwgdW5kZWZpbmVkIH07XG5cbiAgY29uc3RydWN0b3IoXG4gICAgcHJpdmF0ZSByZWFkb25seSBvcHRpb25zOiBHZXRPcHRpb25zLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgc2NoZW1hQ2FjaGVQYXRoPzogc3RyaW5nLFxuICAgIHByaXZhdGUgcmVhZG9ubHkgcmVwb3J0VGVsZW1ldHJ5OiAocGF5bG9hZDoge1xuICAgICAgdGFyZ2V0TGFuZ3VhZ2U6IHN0cmluZztcbiAgICAgIHRyYWNraW5nUGF5bG9hZDogUmVjb3JkPHN0cmluZywgYW55PjtcbiAgICB9KSA9PiBQcm9taXNlPHZvaWQ+ID0gYXN5bmMgKCkgPT4ge30sXG4gICkge1xuICAgIHRoaXMuY29kZU1ha2VyT3V0ZGlyID0gcGF0aC5yZXNvbHZlKHRoaXMub3B0aW9ucy5jb2RlTWFrZXJPdXRwdXQpO1xuICAgIGZzLm1rZGlycFN5bmModGhpcy5jb2RlTWFrZXJPdXRkaXIpO1xuICAgIHRoaXMuY29kZSA9IG5ldyBDb2RlTWFrZXIoKTtcbiAgICB0aGlzLnZlcnNpb25zID0ge307XG4gIH1cbiAgcHJpdmF0ZSBhc3luYyBnZW5lcmF0ZVR5cGVzY3JpcHRQcm92aWRlcihcbiAgICB0YXJnZXQ6IENvbnN0cnVjdHNNYWtlclByb3ZpZGVyVGFyZ2V0LFxuICAgIHNjaGVtYTogUHJvdmlkZXJTY2hlbWEsXG4gICkge1xuICAgIGNvbnN0IGVuZFRTVGltZXIgPSBsb2dUaW1lc3BhbihgR2VuZXJhdGUgVHlwZXNjcmlwdCBmb3IgJHt0YXJnZXQubmFtZX1gKTtcbiAgICBjb25zdCBnZW5lcmF0b3IgPSBuZXcgVGVycmFmb3JtUHJvdmlkZXJHZW5lcmF0b3IodGhpcy5jb2RlLCBzY2hlbWEpO1xuICAgIGdlbmVyYXRvci5nZW5lcmF0ZSh0YXJnZXQpO1xuXG4gICAgdGhpcy52ZXJzaW9ucyA9IHsgLi4udGhpcy52ZXJzaW9ucywgLi4uZ2VuZXJhdG9yLnZlcnNpb25zIH07XG4gICAgZW5kVFNUaW1lcigpO1xuICB9XG5cbiAgcHVibGljIGFzeW5jIGZpbHRlckFscmVhZHlHZW5lcmF0ZWQoXG4gICAgY29uc3RyYWludHM6IFRlcnJhZm9ybURlcGVuZGVuY3lDb25zdHJhaW50W10sXG4gICkge1xuICAgIGxldCBjb25zdHJhaW50c0ZpbGUgPSBcInt9XCI7XG4gICAgdHJ5IHtcbiAgICAgIGNvbnN0cmFpbnRzRmlsZSA9IGF3YWl0IGZzLnJlYWRGaWxlKFxuICAgICAgICBwYXRoLmpvaW4odGhpcy5jb2RlTWFrZXJPdXRkaXIsIFwiY29uc3RyYWludHMuanNvblwiKSxcbiAgICAgICAgXCJ1dGY4XCIsXG4gICAgICApO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIGxvZ2dlci5kZWJ1ZyhcbiAgICAgICAgYENvdWxkIG5vdCBmaW5kIGNvbnN0cmFpbnRzLmpzb24gZmlsZSB3aGlsZSBmaWx0ZXJpbmc6ICR7ZX0uIFRoaXMgbWVhbnMgbm8gcHJvdmlkZXJzIHdlcmUgZ2VuZXJhdGVkLCBzbyBhbGwgY29uc3RyYWludHMgbmVlZCB0byBiZSBnZW5lcmF0ZWQuYCxcbiAgICAgICk7XG4gICAgICByZXR1cm4gY29uc3RyYWludHM7XG4gICAgfVxuICAgIGxvZ2dlci5kZWJ1ZyhgRm91bmQgY29uc3RyYWludHMuanNvbiBmaWxlOiAke2NvbnN0cmFpbnRzRmlsZX1gKTtcblxuICAgIGxldCBwcmV2aW91c0NvbnN0cmFpbnRzOiBQYXJ0aWFsPENvbnN0cmFpbnRGaWxlPiA9IHt9O1xuICAgIHRyeSB7XG4gICAgICBwcmV2aW91c0NvbnN0cmFpbnRzID0gSlNPTi5wYXJzZShjb25zdHJhaW50c0ZpbGUpO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIGxvZ2dlci5pbmZvKFxuICAgICAgICBgQ291bGQgbm90IHBhcnNlIGNvbnN0cmFpbnRzLmpzb24gZmlsZSB3aGlsZSBmaWx0ZXJpbmc6ICR7ZX0uIEdlbmVyYXRpbmcgYWxsIGNvbnN0cmFpbnRzLmAsXG4gICAgICApO1xuICAgICAgcmV0dXJuIGNvbnN0cmFpbnRzO1xuICAgIH1cblxuICAgIGxvZ2dlci5kZWJ1ZyhcbiAgICAgIGBGb3VuZCBwcmV2aW91cyBjb25zdHJhaW50czogJHtKU09OLnN0cmluZ2lmeShcbiAgICAgICAgcHJldmlvdXNDb25zdHJhaW50cyxcbiAgICAgICAgbnVsbCxcbiAgICAgICAgMixcbiAgICAgICl9YCxcbiAgICApO1xuXG4gICAgaWYgKFxuICAgICAgIXByZXZpb3VzQ29uc3RyYWludHMucHJvdmlkZXJzIHx8XG4gICAgICB0eXBlb2YgcHJldmlvdXNDb25zdHJhaW50cy5wcm92aWRlcnMgIT09IFwib2JqZWN0XCJcbiAgICApIHtcbiAgICAgIGxvZ2dlci5pbmZvKFxuICAgICAgICBgQ291bGQgbm90IGZpbmQgcHJvdmlkZXJzIGluIGNvbnN0cmFpbnRzLmpzb24gZmlsZSwgZ2VuZXJhdGluZyBhbGwgY29uc3RyYWludHMuIFRoZSBjb25zdHJhaW50cyBmaWxlIHdhcyAke0pTT04uc3RyaW5naWZ5KFxuICAgICAgICAgIHByZXZpb3VzQ29uc3RyYWludHMsXG4gICAgICAgICAgbnVsbCxcbiAgICAgICAgICAyLFxuICAgICAgICApfWAsXG4gICAgICApO1xuICAgICAgcmV0dXJuIGNvbnN0cmFpbnRzO1xuICAgIH1cblxuICAgIGlmIChwcmV2aW91c0NvbnN0cmFpbnRzLmNka3RmICE9PSBESVNQTEFZX1ZFUlNJT04pIHtcbiAgICAgIGxvZ2dlci5pbmZvKFxuICAgICAgICBgVGhlIENES1RGIHZlcnNpb24gaGFzIGNoYW5nZWQsIGdlbmVyYXRpbmcgYWxsIGNvbnN0cmFpbnRzLiBUaGUgcHJldmlvdXMgdmVyc2lvbiB3YXMgJHtwcmV2aW91c0NvbnN0cmFpbnRzLmNka3RmfSwgdGhlIGN1cnJlbnQgdmVyc2lvbiBpcyAke0RJU1BMQVlfVkVSU0lPTn1gLFxuICAgICAgKTtcbiAgICAgIHJldHVybiBjb25zdHJhaW50cztcbiAgICB9XG5cbiAgICBjb25zdCBjb25zdHJhaW50c1RvR2VuZXJhdGUgPSBjb25zdHJhaW50cy5maWx0ZXIoKGNvbnN0cmFpbnQpID0+IHtcbiAgICAgIGNvbnN0IGNvbnN0cmFpbnRNYXRjaGVzID1cbiAgICAgICAgcHJldmlvdXNDb25zdHJhaW50cy5wcm92aWRlcnMhW2NvbnN0cmFpbnQuZnFuXSA9PT0gY29uc3RyYWludC52ZXJzaW9uO1xuICAgICAgbGV0IHByb3ZpZGVyRm9sZGVyRXhpc3RzID0gZmFsc2U7XG5cbiAgICAgIHN3aXRjaCAodGhpcy5vcHRpb25zLnRhcmdldExhbmd1YWdlKSB7XG4gICAgICAgIGNhc2UgTGFuZ3VhZ2UuVFlQRVNDUklQVDpcbiAgICAgICAgICBwcm92aWRlckZvbGRlckV4aXN0cyA9IGZzLmV4aXN0c1N5bmMoXG4gICAgICAgICAgICBwYXRoLmpvaW4odGhpcy5jb2RlTWFrZXJPdXRkaXIsIFwicHJvdmlkZXJzXCIsIGNvbnN0cmFpbnQubmFtZSksXG4gICAgICAgICAgKTtcbiAgICAgICAgICBicmVhaztcbiAgICAgICAgY2FzZSBMYW5ndWFnZS5QWVRIT046XG4gICAgICAgIGNhc2UgTGFuZ3VhZ2UuSkFWQTpcbiAgICAgICAgY2FzZSBMYW5ndWFnZS5DU0hBUlA6XG4gICAgICAgICAgcHJvdmlkZXJGb2xkZXJFeGlzdHMgPSBmcy5leGlzdHNTeW5jKFxuICAgICAgICAgICAgcGF0aC5qb2luKHRoaXMuY29kZU1ha2VyT3V0ZGlyLCBjb25zdHJhaW50Lm5hbWUpLFxuICAgICAgICAgICk7XG4gICAgICAgICAgYnJlYWs7XG4gICAgICAgIGNhc2UgTGFuZ3VhZ2UuR086XG4gICAgICAgICAgcHJvdmlkZXJGb2xkZXJFeGlzdHMgPSBmcy5leGlzdHNTeW5jKFxuICAgICAgICAgICAgcGF0aC5qb2luKFxuICAgICAgICAgICAgICB0aGlzLmNvZGVNYWtlck91dGRpcixcbiAgICAgICAgICAgICAgY29uc3RyYWludC5uYW1lc3BhY2UgfHwgXCJoYXNoaWNvcnBcIixcbiAgICAgICAgICAgICAgY29uc3RyYWludC5uYW1lLFxuICAgICAgICAgICAgKSxcbiAgICAgICAgICApO1xuICAgICAgICAgIGJyZWFrO1xuICAgICAgfVxuXG4gICAgICBjb25zdCBwcm92aWRlckV4aXN0cyA9IGNvbnN0cmFpbnRNYXRjaGVzICYmIHByb3ZpZGVyRm9sZGVyRXhpc3RzO1xuICAgICAgcmV0dXJuICFwcm92aWRlckV4aXN0cztcbiAgICB9KTtcblxuICAgIGxvZ2dlci5kZWJ1ZyhcbiAgICAgIGBDb25zdHJhaW50cyB0byBnZW5lcmF0ZTogJHtKU09OLnN0cmluZ2lmeShcbiAgICAgICAgY29uc3RyYWludHNUb0dlbmVyYXRlLFxuICAgICAgICBudWxsLFxuICAgICAgICAyLFxuICAgICAgKX1gLFxuICAgICk7XG5cbiAgICByZXR1cm4gY29uc3RyYWludHNUb0dlbmVyYXRlO1xuICB9XG5cbiAgcHJpdmF0ZSBhc3luYyBnZW5lcmF0ZVR5cGVzY3JpcHRNb2R1bGUoXG4gICAgdGFyZ2V0OiBDb25zdHJ1Y3RzTWFrZXJNb2R1bGVUYXJnZXQsXG4gICAgc2NoZW1hOiBNb2R1bGVTY2hlbWEsXG4gICkge1xuICAgIGNvbnN0IGVuZFRTVGltZXIgPSBsb2dUaW1lc3BhbihgR2VuZXJhdGUgVHlwZXNjcmlwdCBmb3IgJHt0YXJnZXQubmFtZX1gKTtcbiAgICB0YXJnZXQuc3BlYyA9IHNjaGVtYTtcbiAgICBuZXcgTW9kdWxlR2VuZXJhdG9yKHRoaXMuY29kZSwgW3RhcmdldF0pO1xuICAgIGVuZFRTVGltZXIoKTtcbiAgfVxuXG4gIHByaXZhdGUgYXN5bmMgZ2VuZXJhdGVUeXBlc2NyaXB0KFxuICAgIHRhcmdldDogQ29uc3RydWN0c01ha2VyVGFyZ2V0LFxuICAgIHNjaGVtYXM6IEF3YWl0ZWQ8UmV0dXJuVHlwZTx0eXBlb2YgcmVhZFNjaGVtYT4+LFxuICApIHtcbiAgICBpZiAodGFyZ2V0LmlzTW9kdWxlKSB7XG4gICAgICBjb25zdCBzY2hlbWEgPSBzY2hlbWFzLm1vZHVsZVNjaGVtYT8uW3RhcmdldC5tb2R1bGVLZXldO1xuICAgICAgaWYgKCFzY2hlbWEpIHtcbiAgICAgICAgdGhyb3cgRXJyb3JzLkludGVybmFsKFxuICAgICAgICAgIGBDb3VsZCBub3QgZ2VuZXJhdGUgc2NoZW1hIGZvciBtb2R1bGUgJHt0YXJnZXQubW9kdWxlS2V5fWAsXG4gICAgICAgICk7XG4gICAgICB9XG5cbiAgICAgIGF3YWl0IHRoaXMuZ2VuZXJhdGVUeXBlc2NyaXB0TW9kdWxlKFxuICAgICAgICB0YXJnZXQgYXMgQ29uc3RydWN0c01ha2VyTW9kdWxlVGFyZ2V0LFxuICAgICAgICBzY2hlbWEsXG4gICAgICApO1xuICAgIH0gZWxzZSBpZiAodGFyZ2V0LmlzUHJvdmlkZXIpIHtcbiAgICAgIGlmICghc2NoZW1hcy5wcm92aWRlclNjaGVtYSkge1xuICAgICAgICB0aHJvdyBFcnJvcnMuSW50ZXJuYWwoYENvdWxkIG5vdCBnZW5lcmF0ZSBzY2hlbWEgZm9yIHByb3ZpZGVyc2ApO1xuICAgICAgfVxuXG4gICAgICBhd2FpdCB0aGlzLmdlbmVyYXRlVHlwZXNjcmlwdFByb3ZpZGVyKFxuICAgICAgICB0YXJnZXQgYXMgQ29uc3RydWN0c01ha2VyUHJvdmlkZXJUYXJnZXQsXG4gICAgICAgIHNjaGVtYXMucHJvdmlkZXJTY2hlbWEsXG4gICAgICApO1xuICAgIH0gZWxzZSB7XG4gICAgICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgICAgIGBVbmtub3duIHRhcmdldCB0eXBlIHVzZWQgdG8gZ2VuZXJhdGUgYmluZGluZ3M6ICR7dGFyZ2V0Lm5hbWV9YCxcbiAgICAgICk7XG4gICAgfVxuICB9XG5cbiAgLy8gZW1pdHMgYSB2ZXJzaW9ucy5qc29uIGZpbGUgd2l0aCBhIG1hcCBvZiB0aGUgdXNlZCB2ZXJzaW9uIGZvciBlYWNoIHByb3ZpZGVyIGZxcG5cbiAgcHJpdmF0ZSB1cGRhdGVWZXJzaW9uc0ZpbGUoXG4gICAgYWxsb3dlZENvbnN0cmFpbnRzOiBUZXJyYWZvcm1EZXBlbmRlbmN5Q29uc3RyYWludFtdLFxuICApIHtcbiAgICBsb2dnZXIuZGVidWcoXG4gICAgICBgVXBkYXRpbmcgdmVyc2lvbnMgZmlsZSB3aXRoIGdlbmVyYXRlZCB2ZXJzaW9ucyAke0pTT04uc3RyaW5naWZ5KFxuICAgICAgICB0aGlzLnZlcnNpb25zLFxuICAgICAgICBudWxsLFxuICAgICAgICAyLFxuICAgICAgKX0gd2l0aCBhbGxvd2VkIGNvbnN0cmFpbnRzICR7SlNPTi5zdHJpbmdpZnkoXG4gICAgICAgIGFsbG93ZWRDb25zdHJhaW50cyxcbiAgICAgICAgbnVsbCxcbiAgICAgICAgMixcbiAgICAgICl9YCxcbiAgICApO1xuICAgIGNvbnN0IGZpbGVQYXRoID0gXCJ2ZXJzaW9ucy5qc29uXCI7XG4gICAgbGV0IHByZXZpb3VzVmVyc2lvbnM6IFJlY29yZDxzdHJpbmcsIHN0cmluZz4gPSB7fTtcbiAgICB0cnkge1xuICAgICAgcHJldmlvdXNWZXJzaW9ucyA9IEpTT04ucGFyc2UoXG4gICAgICAgIGZzLnJlYWRGaWxlU3luYyhwYXRoLnJlc29sdmUodGhpcy5jb2RlTWFrZXJPdXRkaXIsIGZpbGVQYXRoKSwgXCJ1dGY4XCIpLFxuICAgICAgKTtcblxuICAgICAgbG9nZ2VyLmRlYnVnKFxuICAgICAgICBgUmVhZCBleGlzdGluZyB2ZXJzaW9ucyBmaWxlOiAke0pTT04uc3RyaW5naWZ5KFxuICAgICAgICAgIHByZXZpb3VzVmVyc2lvbnMsXG4gICAgICAgICAgbnVsbCxcbiAgICAgICAgICAyLFxuICAgICAgICApfWAsXG4gICAgICApO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIC8vIGlnbm9yZVxuICAgICAgbG9nZ2VyLmRlYnVnKFxuICAgICAgICBgQ291bGQgbm90IHJlYWQgdmVyc2lvbnMgZmlsZSwgdGhpcyBpcyBleHBlY3RlZCBpZiB0aGVyZSBhcmUgbm8gcHJlLWV4aXN0aW5nIGxvY2FsIHByb3ZpZGVyczogJHtlfWAsXG4gICAgICApO1xuICAgIH1cblxuICAgIGNvbnN0IHZlcnNpb25zID0gYWxsb3dlZENvbnN0cmFpbnRzLnJlZHVjZSgoYWNjLCBjb25zdHJhaW50KSA9PiB7XG4gICAgICBjb25zdCBwcm92aWRlciA9IE9iamVjdC5lbnRyaWVzKHByZXZpb3VzVmVyc2lvbnMpLmZpbmQoKFtuYW1lXSkgPT5cbiAgICAgICAgLy8gVGhpcyBjb3VsZCBiZSBtb3JlIHJlZmluZWQsIGJ1dCBpdCdzIGdvb2QgZW5vdWdoIGZvciBub3dcbiAgICAgICAgbmFtZS5lbmRzV2l0aChjb25zdHJhaW50LmZxbiksXG4gICAgICApO1xuXG4gICAgICBpZiAocHJvdmlkZXIpIHtcbiAgICAgICAgY29uc3QgW25hbWUsIHZlcnNpb25dID0gcHJvdmlkZXI7XG4gICAgICAgIHJldHVybiB7IC4uLmFjYywgW25hbWVdOiB2ZXJzaW9uIH07XG4gICAgICB9XG5cbiAgICAgIHJldHVybiBhY2M7XG4gICAgfSwge30pO1xuXG4gICAgbG9nZ2VyLmRlYnVnKFxuICAgICAgYFdyaXRpbmcgdmVyc2lvbnMgZmlsZSAoJHtmaWxlUGF0aH0pOiAke0pTT04uc3RyaW5naWZ5KFxuICAgICAgICB2ZXJzaW9ucyxcbiAgICAgICAgbnVsbCxcbiAgICAgICAgMixcbiAgICAgICl9YCxcbiAgICApO1xuXG4gICAgdGhpcy5jb2RlLm9wZW5GaWxlKGZpbGVQYXRoKTtcbiAgICB0aGlzLmNvZGUubGluZShKU09OLnN0cmluZ2lmeSh7IC4uLnZlcnNpb25zLCAuLi50aGlzLnZlcnNpb25zIH0sIG51bGwsIDIpKTtcbiAgICB0aGlzLmNvZGUuY2xvc2VGaWxlKGZpbGVQYXRoKTtcbiAgICByZXR1cm4gZmlsZVBhdGg7XG4gIH1cblxuICBwdWJsaWMgYXN5bmMgcmVtb3ZlRm9sZGVyc1RoYXRTaG91bGROb3RFeGlzdChcbiAgICBjb25zdHJhaW50c1RoYXRTaG91bGRFeGlzdDogVGVycmFmb3JtRGVwZW5kZW5jeUNvbnN0cmFpbnRbXSxcbiAgKSB7XG4gICAgbG9nZ2VyLmRlYnVnKFxuICAgICAgYFJlbW92aW5nIHByb3ZpZGVycyBleGNlcHQgZm9yICR7SlNPTi5zdHJpbmdpZnkoXG4gICAgICAgIGNvbnN0cmFpbnRzVGhhdFNob3VsZEV4aXN0LFxuICAgICAgICBudWxsLFxuICAgICAgICAyLFxuICAgICAgKX1gLFxuICAgICk7XG5cbiAgICAvLyBBbGwgbGFuZ3VhZ2VzIGJlc2lkZXMgVFMga2VlcCB0aGVpciBwcm92aWRlcnMgaW4gdGhlIHNhbWUgZm9sZGVycyBhcyBtb2R1bGVzXG4gICAgLy8gdGhpcyBtYWtlcyBpdCBpbXBvc3NpYmxlIGZvciB1cyB0byBkaXN0aW5ndWlzaCBhIG5vIGxvbmdlciByZXF1aXJlZCBwcm92aWRlclxuICAgIC8vIGZyb20gYSBtYW51YWxseSB3cml0dGVuIGNvbnN0cnVjdCBvciBhIG1vZHVsZVxuICAgIGlmICghdGhpcy5pc0phdmFzY3JpcHRUYXJnZXQpIHtcbiAgICAgIHJldHVybjtcbiAgICB9XG5cbiAgICBsZXQgZmlsZXNJblByb3ZpZGVyczogc3RyaW5nW10gPSBbXTtcbiAgICBjb25zdCBwcm92aWRlcnNGb2xkZXIgPSBwYXRoLnJlc29sdmUodGhpcy5jb2RlTWFrZXJPdXRkaXIsIFwicHJvdmlkZXJzXCIpO1xuICAgIHRyeSB7XG4gICAgICBmaWxlc0luUHJvdmlkZXJzID0gYXdhaXQgZnMucmVhZGRpcihwcm92aWRlcnNGb2xkZXIpO1xuICAgIH0gY2F0Y2ggKGUpIHtcbiAgICAgIGxvZ2dlci5kZWJ1ZyhcbiAgICAgICAgYEVycm9yIGxpc3RpbmcgZmlsZXMgaW4gcHJvdmlkZXJzIGZvbGRlciAnJHtwcm92aWRlcnNGb2xkZXJ9JzogJHtlfWAsXG4gICAgICApO1xuICAgIH1cblxuICAgIGNvbnN0IGZvbGRlcnMgPSBmaWxlc0luUHJvdmlkZXJzLmZpbHRlcigoZmlsZSkgPT5cbiAgICAgIGZzXG4gICAgICAgIC5zdGF0U3luYyhwYXRoLnJlc29sdmUodGhpcy5jb2RlTWFrZXJPdXRkaXIsIFwicHJvdmlkZXJzXCIsIGZpbGUpKVxuICAgICAgICAuaXNEaXJlY3RvcnkoKSxcbiAgICApO1xuXG4gICAgcmV0dXJuIGZvbGRlcnMuZm9yRWFjaCgoZm9sZGVyKSA9PiB7XG4gICAgICBjb25zdCBzaG91bGRFeGlzdCA9IGNvbnN0cmFpbnRzVGhhdFNob3VsZEV4aXN0LnNvbWUoXG4gICAgICAgIChjb25zdHJhaW50KSA9PiBjb25zdHJhaW50Lm5hbWUgPT09IGZvbGRlcixcbiAgICAgICk7XG5cbiAgICAgIGlmICghc2hvdWxkRXhpc3QpIHtcbiAgICAgICAgbG9nZ2VyLmRlYnVnKGBSZW1vdmluZyBmb2xkZXIgJHtmb2xkZXJ9IGZyb20gcHJvdmlkZXJzYCk7XG4gICAgICAgIGZzLnJlbW92ZVN5bmMocGF0aC5yZXNvbHZlKHRoaXMuY29kZU1ha2VyT3V0ZGlyLCBcInByb3ZpZGVyc1wiLCBmb2xkZXIpKTtcbiAgICAgIH1cbiAgICB9KTtcbiAgfVxuXG4gIC8vIGVtaXRzIGEgY29uc3RyYWludHMuanNvbiBmaWxlIHdpdGggYSBtYXAgb2YgdGhlIHVzZWQgcHJvdmlkZXIgZnFwbnMgYW5kIHZlcnNpb24gY29uc3RyYWludHNcbiAgLy8gdGhpcyBpcyB1c2VkIGZvciBjYWNoaW5nIHB1cnBvc2VzXG4gIHByaXZhdGUgZW1pdENvbnN0cmFpbnRzRmlsZShcbiAgICBhbGxvd2VkQ29uc3RyYWludHM6IFRlcnJhZm9ybURlcGVuZGVuY3lDb25zdHJhaW50W10sXG4gICkge1xuICAgIGNvbnN0IGZpbGVQYXRoID0gXCJjb25zdHJhaW50cy5qc29uXCI7XG5cbiAgICBjb25zdCBjb250ZW50OiBDb25zdHJhaW50RmlsZSA9IHtcbiAgICAgIGNka3RmOiBESVNQTEFZX1ZFUlNJT04sXG4gICAgICBwcm92aWRlcnM6IGFsbG93ZWRDb25zdHJhaW50c1xuICAgICAgICAuc29ydCgoYSwgYikgPT4gYS5mcW4ubG9jYWxlQ29tcGFyZShiLmZxbikpXG4gICAgICAgIC5yZWR1Y2UoXG4gICAgICAgICAgKGNhcnJ5LCBpdGVtKSA9PiAoe1xuICAgICAgICAgICAgLi4uY2FycnksXG4gICAgICAgICAgICBbaXRlbS5mcW5dOiBpdGVtLnZlcnNpb24sXG4gICAgICAgICAgfSksXG4gICAgICAgICAge30sXG4gICAgICAgICksXG4gICAgfTtcblxuICAgIHRoaXMuY29kZS5vcGVuRmlsZShmaWxlUGF0aCk7XG4gICAgdGhpcy5jb2RlLmxpbmUoSlNPTi5zdHJpbmdpZnkoY29udGVudCwgbnVsbCwgMikpO1xuICAgIHRoaXMuY29kZS5jbG9zZUZpbGUoZmlsZVBhdGgpO1xuICAgIHJldHVybiBmaWxlUGF0aDtcbiAgfVxuXG4gIHByaXZhdGUgYXN5bmMgZ2VuZXJhdGVKc2lpTGFuZ3VhZ2UodGFyZ2V0OiBDb25zdHJ1Y3RzTWFrZXJUYXJnZXQpIHtcbiAgICAvLyB0aGVzZSBhcmUgdGhlIG1vZHVsZSBkZXBlbmRlbmNpZXMgd2UgY29tcGlsZSBhZ2FpbnN0XG4gICAgY29uc3QgZGVwcyA9IFtcIkB0eXBlcy9ub2RlXCIsIFwiY29uc3RydWN0c1wiLCBcImNka3RmXCJdO1xuICAgIGNvbnN0IG9wdHM6IEdlbmVyYXRlSlNJSU9wdGlvbnMgPSB7XG4gICAgICBlbnRyeXBvaW50OiB0YXJnZXQuZmlsZU5hbWUsXG4gICAgICBkZXBzOiBkZXBzLm1hcCgoZGVwKSA9PlxuICAgICAgICBwYXRoLmRpcm5hbWUocmVxdWlyZS5yZXNvbHZlKGAke2RlcH0vcGFja2FnZS5qc29uYCkpLFxuICAgICAgKSxcbiAgICAgIG1vZHVsZUtleTogdGFyZ2V0Lm1vZHVsZUtleSxcbiAgICAgIGV4cG9ydHM6IHRhcmdldC5pc1Byb3ZpZGVyIC8vIE1vZHVsZXMgYXJlIHNtYWxsIGVub3VnaCB0aGF0IHdlIGRvbid0IG5lZWQgdGhpcyBvcHRpbWl6YXRpb25cbiAgICAgICAgPyB7XG4gICAgICAgICAgICBcIi5cIjoge1xuICAgICAgICAgICAgICBpbXBvcnQ6IGAuL3Byb3ZpZGVycy8ke3RhcmdldC5uYW1lfS9pbmRleC5qc2AsXG4gICAgICAgICAgICAgIHJlcXVpcmU6IGAuL3Byb3ZpZGVycy8ke3RhcmdldC5uYW1lfS9sYXp5LWluZGV4LmpzYCxcbiAgICAgICAgICAgIH0sXG4gICAgICAgICAgfVxuICAgICAgICA6IHVuZGVmaW5lZCxcbiAgICB9O1xuXG4gICAgLy8gdXNlZCBmb3IgdGVzdGluZy5cbiAgICBpZiAodGhpcy5vcHRpb25zLm91dHB1dEpzaWkpIHtcbiAgICAgIG9wdHMuanNpaSA9IHsgcGF0aDogdGhpcy5vcHRpb25zLm91dHB1dEpzaWkgfTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5pc1B5dGhvblRhcmdldCkge1xuICAgICAgb3B0cy5weXRob24gPSB7XG4gICAgICAgIG91dGRpcjogdGhpcy5jb2RlTWFrZXJPdXRkaXIsXG4gICAgICAgIG1vZHVsZU5hbWU6IHRhcmdldC5zcmNNYWtOYW1lLFxuICAgICAgfTtcbiAgICB9XG5cbiAgICBpZiAodGhpcy5pc0phdmFUYXJnZXQpIHtcbiAgICAgIGlmIChcbiAgICAgICAgdGhpcy5vcHRpb25zLmNvZGVNYWtlck91dHB1dC5pbmNsdWRlcyhcIi9cIikgfHxcbiAgICAgICAgdGhpcy5vcHRpb25zLmNvZGVNYWtlck91dHB1dC5pbmNsdWRlcyhcIlxcXFxcIilcbiAgICAgICkge1xuICAgICAgICB0aHJvdyBFcnJvcnMuVXNhZ2UoXG4gICAgICAgICAgYFdoZW4gdXNpbmcgSmF2YSB0aGUgXCJjb2RlTWFrZXJPdXRwdXRcIiBvcHRpb24gaW4gdGhlIGNka3RmLmpzb24gbXVzdCBiZSB0aGUgb3JnYW5pemF0aW9uIGlkZW50aWZpZXIgZm9yIHlvdXIgcHJvamVjdCAoZS5nLiBjb20ubXktY29tcGFueSksIG5vdCBhIHBhdGguIFRoZSBnZW5lcmF0ZWQgSmF2YSBjb2RlIHdpbGwgYmUgcGxhY2VkIGluIGEgc3ViZGlyZWN0b3J5IG9mIHRoZSBnaXZlbiBkaXJlY3RvcnkuIElmIHlvdSBhcmUgbWlncmF0aW5nIGZyb20gYSA8IDAuMTkgdmVyc2lvbiBvZiBjZGt0ZiB5b3Ugd2FudCB0byBjaGFuZ2UgdGhlIGNvZGVtYWtlck91dHB1dCB0byBcImltcG9ydHNcIi5gLFxuICAgICAgICApO1xuICAgICAgfVxuXG4gICAgICBvcHRzLmphdmEgPSB7XG4gICAgICAgIG91dGRpcjogXCIuXCIsIC8vIGdlbmVyYXRlZCBqYXZhIGZpbGVzIGFyZW4ndCBwYWNrYWdlZCwgc28ganVzdCBpbmNsdWRlIGRpcmVjdGx5IGluIGFwcFxuICAgICAgICBwYWNrYWdlOiBgJHt0aGlzLm9wdGlvbnMuY29kZU1ha2VyT3V0cHV0fS4ke3RhcmdldC5zcmNNYWtOYW1lfWAsXG4gICAgICB9O1xuICAgIH1cblxuICAgIGlmICh0aGlzLmlzQ3NoYXJwVGFyZ2V0KSB7XG4gICAgICBvcHRzLmNzaGFycCA9IHtcbiAgICAgICAgb3V0ZGlyOiB0aGlzLmNvZGVNYWtlck91dGRpcixcbiAgICAgICAgbmFtZXNwYWNlOiB0YXJnZXQuc3JjTWFrTmFtZSxcbiAgICAgIH07XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuaXNHb1RhcmdldCkge1xuICAgICAgLy8gVE9ETzogY2hlY2sgaWYgbmVlZGVkIGZvciBtb2R1bGVzIHNvbWVob3dcbiAgICAgIC8vIGNvbnN0IHRhcmdldFR5cGUgPSB0YXJnZXQuaXNQcm92aWRlciA/ICdwcm92aWRlcicgOiAnbW9kdWxlJztcblxuICAgICAgLy8ganNpaS1zcmNtYWMgd2lsbCBwcm9kdWNlIGEgZm9sZGVyIGluc2lkZSB0aGlzIGRpciBuYW1lZCBhZnRlciBcInBhY2thZ2VOYW1lXCJcbiAgICAgIC8vIHNvIHRoaXMgcmVzdWx0cyBpbiBlLmcuIC5nZW4vaGFzaGljb3JwL3JhbmRvbVxuICAgICAgY29uc3Qgb3V0ZGlyID0gcGF0aC5qb2luKHRoaXMuY29kZU1ha2VyT3V0ZGlyLCB0YXJnZXQubmFtZXNwYWNlID8/IFwiXCIpO1xuXG4gICAgICBvcHRzLmdvbGFuZyA9IHtcbiAgICAgICAgb3V0ZGlyLFxuICAgICAgICBtb2R1bGVOYW1lOiBhd2FpdCBkZXRlcm1pbmVHb01vZHVsZU5hbWUob3V0ZGlyKSwgLy8gZS5nLiBgZ2l0aHViLmNvbS9vcmcvdXNlcnByb2plY3QvLmdlbi9oYXNoaWNvcnBgXG4gICAgICAgIHBhY2thZ2VOYW1lOiB0YXJnZXQuc3JjTWFrTmFtZSwgLy8gcGFja2FnZSB3aWxsIGJlIG5hbWVkIGUuZy4gcmFuZG9tIGZvciBoYXNoaWNvcnAvcmFuZG9tXG4gICAgICB9O1xuICAgIH1cblxuICAgIGlmIChcbiAgICAgIHByb2Nlc3MuZW52Lk5PREVfT1BUSU9OUyAmJlxuICAgICAgIXByb2Nlc3MuZW52Lk5PREVfT1BUSU9OUy5pbmNsdWRlcyhgLS1tYXgtb2xkLXNwYWNlLXNpemVgKVxuICAgICkge1xuICAgICAgbG9nZ2VyLndhcm4oYGZvdW5kIE5PREVfT1BUSU9OUyBlbnZpcm9ubWVudCB2YXJpYWJsZSB3aXRob3V0IGEgc2V0dGluZyBmb3IgLS1tYXgtb2xkLXNwYWNlLXNpemUuXG5UaGUgcHJvdmlkZXIgZ2VuZXJhdGlvbiBuZWVkcyBhIHN1YnN0YW50aWFsIGFtb3VudCBvZiBtZW1vcnkgKH4xM0dCKSBmb3Igc29tZSBwcm92aWRlcnMgYW5kIGxhbmd1YWdlcy5cblNvIGNka3RmLWNsaSBzZXRzIGl0IHRvIE5PREVfT1BUSU9OUz1cIi0tbWF4LW9sZC1zcGFjZS1zaXplPTE2Mzg0XCIgYnkgZGVmYXVsdC4gQXMgeW91ciBlbnZpcm9ubWVudCBhbHJlYWR5IGNvbnRhaW5zXG5hIE5PREVfT1BUSU9OUyB2YXJpYWJsZSwgd2Ugd29uJ3Qgb3ZlcnJpZGUgaXQuIEhlbmNlLCB0aGUgcHJvdmlkZXIgZ2VuZXJhdGlvbiBtaWdodCBmYWlsIHdpdGggYW4gb3V0IG9mIG1lbW9yeSBlcnJvci5gKTtcbiAgICB9IGVsc2Uge1xuICAgICAgLy8gaW5jcmVhc2UgbWVtb3J5IHRvIGFsbG93IGdlbmVyYXRpbmcgbGFyZ2UgcHJvdmlkZXJzIChpLmUuIGF3cyBvciBhenVyZXJtIGZvciBHbylcbiAgICAgIC8vIHNyY21hayBpcyBnb2luZyB0byBzcGF3biBhIGNoaWxkcHJvY2VzcyAoZm9yIGpzaWktcGFjbWFrKSB3aGljaCBpcyBnb2luZyB0byBiZSBhZmZlY3RlZCBieSB0aGlzIGVudiB2YXJcbiAgICAgIHByb2Nlc3MuZW52Lk5PREVfT1BUSU9OUyA9IFwiLS1tYXgtb2xkLXNwYWNlLXNpemU9MTYzODRcIjtcbiAgICB9XG5cbiAgICBjb25zdCBqc2lpVGltZXIgPSBsb2dUaW1lc3BhbihcIkpTSUlcIik7XG4gICAgYXdhaXQgZ2VuZXJhdGVKc2lpTGFuZ3VhZ2UodGhpcy5jb2RlLCBvcHRzLCB0aGlzLmNvZGVNYWtlck91dGRpciwgW1xuICAgICAgdGFyZ2V0LmlzTW9kdWxlID8gXCJwcm92aWRlcnMvKipcIiA6IFwibW9kdWxlcy8qKlwiLFxuICAgIF0pO1xuICAgIGpzaWlUaW1lcigpO1xuICB9XG5cbiAgcHVibGljIGFzeW5jIGdldFNjaGVtYXModGFyZ2V0czogVGVycmFmb3JtRGVwZW5kZW5jeUNvbnN0cmFpbnRbXSkge1xuICAgIHJldHVybiBhd2FpdCByZWFkU2NoZW1hKHRhcmdldHMsIHRoaXMuc2NoZW1hQ2FjaGVQYXRoKTtcbiAgfVxuXG4gIHB1YmxpYyBhc3luYyBnZW5lcmF0ZShcbiAgICBhbGxDb25zdHJhaW50czogVGVycmFmb3JtRGVwZW5kZW5jeUNvbnN0cmFpbnRbXSxcbiAgICBjb25zdHJhaW50c1RvR2VuZXJhdGUgPSBhbGxDb25zdHJhaW50cyxcbiAgKSB7XG4gICAgY29uc3QgdGFyZ2V0cyA9IGNvbnN0cmFpbnRzVG9HZW5lcmF0ZS5tYXAoKGNvbnN0cmFpbnQpID0+XG4gICAgICBDb25zdHJ1Y3RzTWFrZXJUYXJnZXQuZnJvbShjb25zdHJhaW50LCB0aGlzLm9wdGlvbnMudGFyZ2V0TGFuZ3VhZ2UpLFxuICAgICk7XG5cbiAgICBjb25zdCBlbmRTY2hlbWFUaW1lciA9IGxvZ1RpbWVzcGFuKFwiR2F0aGVyaW5nIHNjaGVtYVwiKTtcbiAgICBjb25zdCBzY2hlbWFzID0gYXdhaXQgdGhpcy5nZXRTY2hlbWFzKGNvbnN0cmFpbnRzVG9HZW5lcmF0ZSk7XG4gICAgZW5kU2NoZW1hVGltZXIoKTtcblxuICAgIGNvbnN0IGVuZEdlbmVyYXRlVGltZXIgPSBsb2dUaW1lc3BhbihcIkdlbmVyYXRlIFRTXCIpO1xuICAgIGF3YWl0IFByb21pc2UuYWxsKFxuICAgICAgdGFyZ2V0cy5tYXAoKHRhcmdldCkgPT4gdGhpcy5nZW5lcmF0ZVR5cGVzY3JpcHQodGFyZ2V0LCBzY2hlbWFzKSksXG4gICAgKTtcbiAgICBlbmRHZW5lcmF0ZVRpbWVyKCk7XG5cbiAgICB0aGlzLnVwZGF0ZVZlcnNpb25zRmlsZShhbGxDb25zdHJhaW50cyk7XG4gICAgdGhpcy5lbWl0Q29uc3RyYWludHNGaWxlKGFsbENvbnN0cmFpbnRzKTtcblxuICAgIGlmICh0aGlzLmlzSmF2YXNjcmlwdFRhcmdldCkge1xuICAgICAgYXdhaXQgdGhpcy5zYXZlKCk7XG4gICAgfVxuXG4gICAgaWYgKCF0aGlzLmlzSmF2YXNjcmlwdFRhcmdldCB8fCB0aGlzLm9wdGlvbnMub3V0cHV0SnNpaSkge1xuICAgICAgY29uc3QgbnVtYmVyT2ZXb3JrZXJzID0gTWF0aC5tYXgoXG4gICAgICAgIDEsXG4gICAgICAgIHRoaXMub3B0aW9ucy5qc2lpUGFyYWxsZWxpc20gPT09IC0xXG4gICAgICAgICAgPyB0YXJnZXRzLmxlbmd0aFxuICAgICAgICAgIDogdGhpcy5vcHRpb25zLmpzaWlQYXJhbGxlbGlzbSB8fCAxLFxuICAgICAgKTtcblxuICAgICAgY29uc3Qgd29yayA9IFsuLi50YXJnZXRzXTtcbiAgICAgIGNvbnN0IHdvcmtlcnMgPSBuZXcgQXJyYXkobnVtYmVyT2ZXb3JrZXJzKS5maWxsKGFzeW5jICgpID0+IHtcbiAgICAgICAgbGV0IHRhcmdldDogQ29uc3RydWN0c01ha2VyVGFyZ2V0IHwgdW5kZWZpbmVkO1xuICAgICAgICB3aGlsZSAoKHRhcmdldCA9IHdvcmsucG9wKCkpKSB7XG4gICAgICAgICAgY29uc3QgZW5kSnNpaVRhcmdldCA9IGxvZ1RpbWVzcGFuKFxuICAgICAgICAgICAgYEdlbmVyYXRpbmcgSlNJSSBiaW5kaW5ncyBmb3IgJHt0YXJnZXQubmFtZX1gLFxuICAgICAgICAgICk7XG4gICAgICAgICAgYXdhaXQgdGhpcy5nZW5lcmF0ZUpzaWlMYW5ndWFnZSh0YXJnZXQpO1xuICAgICAgICAgIGVuZEpzaWlUYXJnZXQoKTtcbiAgICAgICAgfVxuICAgICAgfSk7XG5cbiAgICAgIGF3YWl0IFByb21pc2UuYWxsKHdvcmtlcnMubWFwKChmbikgPT4gZm4oKSkpO1xuICAgIH1cblxuICAgIGZvciAoY29uc3QgdGFyZ2V0IG9mIHRhcmdldHMpIHtcbiAgICAgIGF3YWl0IHRoaXMucmVwb3J0VGVsZW1ldHJ5KHtcbiAgICAgICAgdHJhY2tpbmdQYXlsb2FkOiB0YXJnZXQudHJhY2tpbmdQYXlsb2FkLFxuICAgICAgICB0YXJnZXRMYW5ndWFnZTogdGFyZ2V0LnRhcmdldExhbmd1YWdlLFxuICAgICAgfSk7XG4gICAgfVxuXG4gICAgaWYgKHRoaXMuaXNQeXRob25UYXJnZXQpIHtcbiAgICAgIGNvbnN0IGVuZFB5dGhvblRpbWVyID0gbG9nVGltZXNwYW4oXCJQeXRob24gcG9zdC1wcm9jZXNzaW5nXCIpO1xuICAgICAgLy8gUmVtb3ZlIGZyb20gLiBpbXBvcnQgLi4uIHN0YXRlbWVudHMgZnJvbSByb290IGxldmVsIF9faW5pdF9fLnB5XG4gICAgICAvLyBUaGlzIHJlbW92ZXMgcm9vdC1sZXZlbCBpbXBvcnRzIG9mIG5hbWVzcGFjZXMsIGJ1dCBzYXZlcyAyNXMgc3ludGggdGltZSBmb3IgdGhlIGF3cyBwcm92aWRlciBhbG9uZVxuICAgICAgY29uc3QgYWxsSW5pdFB5UGF0aHMgPSBnbG9iXG4gICAgICAgIC5zeW5jKFwiKiovX19pbml0X18ucHlcIiwge1xuICAgICAgICAgIGN3ZDogdGhpcy5jb2RlTWFrZXJPdXRkaXIsXG4gICAgICAgIH0pXG4gICAgICAgIC8vIHNvcnQgYnkgZGVwdGgsIHNvIHdlIHN0YXJ0IHdpdGggdGhlIHNoYWxsb3dlc3QgZmlsZXNcbiAgICAgICAgLnNvcnQoKGEsIGIpID0+IGEuc3BsaXQoXCIvXCIpLmxlbmd0aCAtIGIuc3BsaXQoXCIvXCIpLmxlbmd0aCk7XG5cbiAgICAgIGNvbnN0IHZpc2l0ZWREaXJlY3Rvcmllczogc3RyaW5nW10gPSBbXTtcbiAgICAgIGZvciAoY29uc3QgaW5pdFB5UGF0aCBvZiBhbGxJbml0UHlQYXRocykge1xuICAgICAgICBjb25zdCBkaXJlY3RvcnlQYXRoID0gcGF0aC5kaXJuYW1lKGluaXRQeVBhdGgpO1xuICAgICAgICBpZiAodmlzaXRlZERpcmVjdG9yaWVzLnNvbWUoKGRpcikgPT4gZGlyZWN0b3J5UGF0aC5zdGFydHNXaXRoKGRpcikpKSB7XG4gICAgICAgICAgLy8gd2UgYWxyZWFkeSBwcm9jZXNzZWQgdGhpcyBkaXJlY3RvcnlcbiAgICAgICAgICBjb250aW51ZTtcbiAgICAgICAgfVxuICAgICAgICB2aXNpdGVkRGlyZWN0b3JpZXMucHVzaChkaXJlY3RvcnlQYXRoKTtcblxuICAgICAgICBjb25zdCBhYnNvbHV0ZUluaXRQeVBhdGggPSBwYXRoLmpvaW4odGhpcy5jb2RlTWFrZXJPdXRkaXIsIGluaXRQeVBhdGgpO1xuICAgICAgICBjb25zdCBpbml0UHkgPSBhd2FpdCBmcy5yZWFkRmlsZShhYnNvbHV0ZUluaXRQeVBhdGgsIFwidXRmOFwiKTtcbiAgICAgICAgY29uc3QgaW5pdFB5V2l0aG91dEltcG9ydHMgPSBpbml0UHkucmVwbGFjZSgvZnJvbSBcXC4gaW1wb3J0IC4qXFxuL2csIFwiXCIpO1xuICAgICAgICBhd2FpdCBmcy53cml0ZUZpbGUoYWJzb2x1dGVJbml0UHlQYXRoLCBpbml0UHlXaXRob3V0SW1wb3J0cyk7XG4gICAgICB9XG5cbiAgICAgIGVuZFB5dGhvblRpbWVyKCk7XG4gICAgfVxuICB9XG5cbiAgcHJpdmF0ZSBhc3luYyBzYXZlKG91dGRpciA9IHRoaXMuY29kZU1ha2VyT3V0ZGlyKSB7XG4gICAgYXdhaXQgdGhpcy5jb2RlLnNhdmUob3V0ZGlyKTtcbiAgfVxuXG4gIHByaXZhdGUgZ2V0IGlzSmF2YXNjcmlwdFRhcmdldCgpIHtcbiAgICByZXR1cm4gdGhpcy5vcHRpb25zLnRhcmdldExhbmd1YWdlID09PSBMYW5ndWFnZS5UWVBFU0NSSVBUO1xuICB9XG5cbiAgcHJpdmF0ZSBnZXQgaXNQeXRob25UYXJnZXQoKSB7XG4gICAgcmV0dXJuIHRoaXMub3B0aW9ucy50YXJnZXRMYW5ndWFnZSA9PT0gTGFuZ3VhZ2UuUFlUSE9OO1xuICB9XG5cbiAgcHJpdmF0ZSBnZXQgaXNKYXZhVGFyZ2V0KCkge1xuICAgIHJldHVybiB0aGlzLm9wdGlvbnMudGFyZ2V0TGFuZ3VhZ2UgPT09IExhbmd1YWdlLkpBVkE7XG4gIH1cblxuICBwcml2YXRlIGdldCBpc0NzaGFycFRhcmdldCgpIHtcbiAgICByZXR1cm4gdGhpcy5vcHRpb25zLnRhcmdldExhbmd1YWdlID09PSBMYW5ndWFnZS5DU0hBUlA7XG4gIH1cblxuICBwcml2YXRlIGdldCBpc0dvVGFyZ2V0KCkge1xuICAgIHJldHVybiB0aGlzLm9wdGlvbnMudGFyZ2V0TGFuZ3VhZ2UgPT09IExhbmd1YWdlLkdPO1xuICB9XG59XG5cbi8qKlxuICogc2VhcmNoZXMgZm9yIHRoZSBjbG9zZXN0IGBnby5tb2RgIGZpbGUgYW5kIHJldHVybnMgdGhlIG5lc3RlZCBnbyBtb2R1bGUgbmFtZSBmb3IgYGRpcmBcbiAqIGUuZy4gKC9kaXIvLmdlbi8pID0+IGNkay50Zi9zdGFjay8uZ2VuIGlmIHRoZSBwYXJlbnQgZGlyIG9mIC5nZW4gaGFzIGEgZ28ubW9kIGZvciBcIm1vZHVsZSBjZGsudGYvc3RhY2tcIlxuICpcbiAqIEBwYXJhbSBkaXIgdGhlIGRpcmVjdG9yeSB0byBzdGFydCB0aGUgc2VhcmNoIGZyb20gKHNlYXJjaGVzIHVwd2FyZHMpXG4gKiBAcmV0dXJucyB0aGUgcGFja2FnZSBuYW1lIGZvciBgZGlyYFxuICogQHRocm93cyBhbiBFcnJvciBpZiBubyBnby5tb2Qgd2FzIGZvdW5kXG4gKi9cbmV4cG9ydCBjb25zdCBkZXRlcm1pbmVHb01vZHVsZU5hbWUgPSBhc3luYyAoZGlyOiBzdHJpbmcpOiBQcm9taXNlPHN0cmluZz4gPT4ge1xuICBsZXQgcHJldmlvdXNEaXI7XG4gIGxldCBjdXJyZW50RGlyID0gcGF0aC5yZXNvbHZlKGRpcik7XG5cbiAgZG8ge1xuICAgIGxldCBmaWxlczogc3RyaW5nW10gPSBbXTtcbiAgICB0cnkge1xuICAgICAgZmlsZXMgPSBhd2FpdCBmcy5yZWFkZGlyKGN1cnJlbnREaXIpO1xuICAgIH0gY2F0Y2ggKGU6IGFueSkge1xuICAgICAgLy8gZGlyZWN0b3J5IG1pZ2h0IG5vdCBleGlzdCB5ZXQsIGJ1dCB3ZSBzdGlsbCB3YWxrIHVwd2FyZHMgZnJvbSB0aGVyZSwgc28gaWdub3JlICdFTk9FTlQnXG4gICAgICBpZiAoZS5jb2RlICE9PSBcIkVOT0VOVFwiKSB7XG4gICAgICAgIHRocm93IGU7XG4gICAgICB9XG4gICAgfVxuICAgIGlmIChmaWxlcy5pbmNsdWRlcyhcImdvLm1vZFwiKSkge1xuICAgICAgY29uc3QgZmlsZSA9IHBhdGgucmVzb2x2ZShjdXJyZW50RGlyLCBcImdvLm1vZFwiKTtcbiAgICAgIGNvbnN0IGdvbW9kID0gYXdhaXQgZnMucmVhZEZpbGUoZmlsZSk7XG4gICAgICBjb25zdCBtYXRjaCA9IC9ebW9kdWxlXFxzKihcXFMqKVxccyokL20uZXhlYyhnb21vZC50b1N0cmluZygpKTtcbiAgICAgIGlmIChtYXRjaCAmJiBtYXRjaFsxXSkge1xuICAgICAgICBjb25zdCBjaGlsZGRpciA9IHBhdGgucmVsYXRpdmUoY3VycmVudERpciwgZGlyKS5yZXBsYWNlKC9cXFxcL2csIFwiL1wiKTsgLy8gcmVwbGFjZSAnXFwnIHdpdGggJy8nIGZvciB3aW5kb3dzIHBhdGhzXG4gICAgICAgIHJldHVybiBjaGlsZGRpci5sZW5ndGggPiAwID8gYCR7bWF0Y2hbMV19LyR7Y2hpbGRkaXJ9YCA6IG1hdGNoWzFdO1xuICAgICAgfVxuICAgICAgdGhyb3cgbmV3IEVycm9yKFxuICAgICAgICBgQ291bGQgbm90IGRldGVybWluZSB0aGUgcm9vdCBHbyBtb2R1bGUgbmFtZS4gRm91bmQgJHtmaWxlfSBidXQgZmFpbGVkIHRvIHJlZ2V4IG1hdGNoIHRoZSBtb2R1bGUgbmFtZSBkaXJlY3RpdmVgLFxuICAgICAgKTtcbiAgICB9XG4gICAgLy8gZ28gdXAgb25lIGRpcmVjdG9yeS4gQXMgZGlybmFtZSgnLycpIHdpbGwgcmV0dXJuICcvJyB3ZSBjYW5jZWwgdGhlIGxvb3BcbiAgICAvLyBhcyBzb29uIGFzIHRoZSBkaXIgZG9lcyBub3QgY2hhbmdlIGFueW1vcmUuXG4gICAgcHJldmlvdXNEaXIgPSBjdXJyZW50RGlyO1xuICAgIGN1cnJlbnREaXIgPSBwYXRoLmRpcm5hbWUoY3VycmVudERpcik7XG4gIH0gd2hpbGUgKGN1cnJlbnREaXIgIT09IHByZXZpb3VzRGlyKTtcblxuICB0aHJvdyBuZXcgRXJyb3IoXG4gICAgYENvdWxkIG5vdCBkZXRlcm1pbmUgdGhlIHJvb3QgR28gbW9kdWxlIG5hbWUuIE5vIGdvLm1vZCBmb3VuZCBpbiAke2Rpcn0gYW5kIGFueSBwYXJlbnQgZGlyZWN0b3JpZXNgLFxuICApO1xufTtcbiJdfQ==