import { CodeMaker } from "codemaker";
import { TerraformDependencyConstraint } from "@cdktf/commons";
import { Language } from "@cdktf/commons";
export interface GenerateJSIIOptions {
    entrypoint: string;
    deps: string[];
    moduleKey: string;
    exports?: Record<string, ExportDefinition | string>;
    jsii?: JsiiOutputOptions;
    python?: PythonOutputOptions;
    java?: JavaOutputOptions;
    csharp?: CSharpOutputOptions;
    golang?: GoLangOutputOptions;
}
export interface JsiiOutputOptions {
    path: string;
}
export interface PythonOutputOptions {
    outdir: string;
    moduleName: string;
}
export interface JavaOutputOptions {
    outdir: string;
    package: string;
}
export interface CSharpOutputOptions {
    outdir: string;
    namespace: string;
}
export interface GoLangOutputOptions {
    outdir: string;
    moduleName: string;
    packageName: string;
}
/**
 * See https://nodejs.org/api/packages.html#conditional-exports for more information
 */
export interface ExportDefinition {
    node?: string;
    import?: string;
    require?: string;
    default?: string;
}
export declare function generateJsiiLanguage(code: CodeMaker, opts: GenerateJSIIOptions, outputPath: string, disallowedFileGlobs?: string[]): Promise<void>;
export interface GetOptions {
    readonly targetLanguage: Language;
    readonly codeMakerOutput: string;
    readonly jsiiParallelism?: number;
    /**
     * Path to copy the output .jsii file.
     * @default - jsii file is not emitted
     */
    readonly outputJsii?: string;
}
export declare class ConstructsMaker {
    private readonly options;
    private readonly schemaCachePath?;
    private readonly reportTelemetry;
    private readonly codeMakerOutdir;
    private readonly code;
    private versions;
    constructor(options: GetOptions, schemaCachePath?: string | undefined, reportTelemetry?: (payload: {
        targetLanguage: string;
        trackingPayload: Record<string, any>;
    }) => Promise<void>);
    private generateTypescriptProvider;
    filterAlreadyGenerated(constraints: TerraformDependencyConstraint[]): Promise<TerraformDependencyConstraint[]>;
    private generateTypescriptModule;
    private generateTypescript;
    private updateVersionsFile;
    removeFoldersThatShouldNotExist(constraintsThatShouldExist: TerraformDependencyConstraint[]): Promise<void>;
    private emitConstraintsFile;
    private generateJsiiLanguage;
    getSchemas(targets: TerraformDependencyConstraint[]): Promise<import("@cdktf/provider-schema/src/read").Schema>;
    generate(allConstraints: TerraformDependencyConstraint[], constraintsToGenerate?: TerraformDependencyConstraint[]): Promise<void>;
    private save;
    private get isJavascriptTarget();
    private get isPythonTarget();
    private get isJavaTarget();
    private get isCsharpTarget();
    private get isGoTarget();
}
/**
 * searches for the closest `go.mod` file and returns the nested go module name for `dir`
 * e.g. (/dir/.gen/) => cdk.tf/stack/.gen if the parent dir of .gen has a go.mod for "module cdk.tf/stack"
 *
 * @param dir the directory to start the search from (searches upwards)
 * @returns the package name for `dir`
 * @throws an Error if no go.mod was found
 */
export declare const determineGoModuleName: (dir: string) => Promise<string>;
