"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.expectModuleToMatchSnapshot = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const commons_1 = require("@cdktf/commons");
const constructs_maker_1 = require("../constructs-maker");
const path = __importStar(require("path"));
function expectModuleToMatchSnapshot(testName, testCategory, fixtureNames) {
    test(testName, async () => {
        await (0, commons_1.withTempDir)(`${testName.replace(/\s*/, "-")}.test`, async () => {
            const curdir = process.cwd();
            fs.mkdirSync("module");
            fixtureNames.forEach((fixtureName) => {
                fs.copyFileSync(path.join(__dirname, testCategory, "fixtures", fixtureName), path.join(curdir, "module", fixtureName));
            });
            const constraint = new commons_1.TerraformModuleConstraint({
                source: "./module",
                name: "module",
                fqn: "module",
            });
            fs.mkdirSync("work");
            const workdir = path.join(curdir, "work");
            const maker = new constructs_maker_1.ConstructsMaker({
                codeMakerOutput: workdir,
                targetLanguage: commons_1.Language.TYPESCRIPT,
            }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
            await maker.generate([constraint]);
            const output = fs.readFileSync(path.join(workdir, "modules/module.ts"), "utf-8");
            expect(output).toMatchSnapshot();
        });
    });
}
exports.expectModuleToMatchSnapshot = expectModuleToMatchSnapshot;
//# sourceMappingURL=data:application/json;base64,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