"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs-extra"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const commons_1 = require("@cdktf/commons");
const constructs_maker_1 = require("../../constructs-maker");
jest.setTimeout(600000);
global.setImmediate =
    global.setImmediate ||
        ((fn, ...args) => global.setTimeout(fn, 0, ...args));
describe("versions.json file generation", () => {
    const languages = [commons_1.Language.TYPESCRIPT, commons_1.Language.PYTHON];
    const constraints = [
        {
            fqn: "hashicorp/aws",
            name: "aws",
            source: "hashicorp/aws",
            version: "4.0.0",
        },
        {
            fqn: "hashicorp/random",
            name: "random",
            source: "hashicorp/random",
            version: "3.1.3",
        },
        {
            fqn: "kreuzwerker/docker",
            name: "docker",
            source: "kreuzwerker/docker",
            version: "2.16.0",
        },
    ];
    beforeAll(() => { });
    test.each(languages)("generates a file for the %s language", async (language) => {
        const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "versions-file.test"));
        const options = {
            codeMakerOutput: workdir,
            targetLanguage: language,
        };
        // Ignore warnings to pop up from the generate function
        process.env.NODE_OPTIONS = "--max-old-space-size=16384";
        const constructMaker = new constructs_maker_1.ConstructsMaker(options, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
        await constructMaker.generate(constraints);
        const output = fs.readFileSync(path.join(workdir, "versions.json"), "utf-8");
        expect(Object.keys(JSON.parse(output))).toEqual(expect.arrayContaining(constraints.map((c) => `registry.terraform.io/${c.fqn}`)));
    });
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidmVyc2lvbnMtZmlsZS50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsidmVyc2lvbnMtZmlsZS50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBQ25DLDZDQUErQjtBQUMvQix1Q0FBeUI7QUFDekIsMkNBQTZCO0FBQzdCLDRDQUF5RTtBQUN6RSw2REFBcUU7QUFFckUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFPLENBQUMsQ0FBQztBQUN6QixNQUFNLENBQUMsWUFBWTtJQUNqQixNQUFNLENBQUMsWUFBWTtRQUNuQixDQUFDLENBQUMsRUFBTyxFQUFFLEdBQUcsSUFBVyxFQUFFLEVBQUUsQ0FBQyxNQUFNLENBQUMsVUFBVSxDQUFDLEVBQUUsRUFBRSxDQUFDLEVBQUUsR0FBRyxJQUFJLENBQUMsQ0FBQyxDQUFDO0FBRW5FLFFBQVEsQ0FBQywrQkFBK0IsRUFBRSxHQUFHLEVBQUU7SUFDN0MsTUFBTSxTQUFTLEdBQUcsQ0FBQyxrQkFBUSxDQUFDLFVBQVUsRUFBRSxrQkFBUSxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBRXpELE1BQU0sV0FBVyxHQUFvQztRQUNuRDtZQUNFLEdBQUcsRUFBRSxlQUFlO1lBQ3BCLElBQUksRUFBRSxLQUFLO1lBQ1gsTUFBTSxFQUFFLGVBQWU7WUFDdkIsT0FBTyxFQUFFLE9BQU87U0FDakI7UUFDRDtZQUNFLEdBQUcsRUFBRSxrQkFBa0I7WUFDdkIsSUFBSSxFQUFFLFFBQVE7WUFDZCxNQUFNLEVBQUUsa0JBQWtCO1lBQzFCLE9BQU8sRUFBRSxPQUFPO1NBQ2pCO1FBQ0Q7WUFDRSxHQUFHLEVBQUUsb0JBQW9CO1lBQ3pCLElBQUksRUFBRSxRQUFRO1lBQ2QsTUFBTSxFQUFFLG9CQUFvQjtZQUM1QixPQUFPLEVBQUUsUUFBUTtTQUNsQjtLQUNGLENBQUM7SUFFRixTQUFTLENBQUMsR0FBRyxFQUFFLEdBQUUsQ0FBQyxDQUFDLENBQUM7SUFFcEIsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsQ0FDbEIsc0NBQXNDLEVBQ3RDLEtBQUssRUFBRSxRQUFRLEVBQUUsRUFBRTtRQUNqQixNQUFNLE9BQU8sR0FBRyxFQUFFLENBQUMsV0FBVyxDQUM1QixJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsRUFBRSxvQkFBb0IsQ0FBQyxDQUM3QyxDQUFDO1FBRUYsTUFBTSxPQUFPLEdBQWU7WUFDMUIsZUFBZSxFQUFFLE9BQU87WUFDeEIsY0FBYyxFQUFFLFFBQVE7U0FDekIsQ0FBQztRQUVGLHVEQUF1RDtRQUN2RCxPQUFPLENBQUMsR0FBRyxDQUFDLFlBQVksR0FBRyw0QkFBNEIsQ0FBQztRQUN4RCxNQUFNLGNBQWMsR0FBRyxJQUFJLGtDQUFlLENBQ3hDLE9BQU8sRUFDUCxPQUFPLENBQUMsR0FBRyxDQUFDLDZDQUE2QyxDQUMxRCxDQUFDO1FBRUYsTUFBTSxjQUFjLENBQUMsUUFBUSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBRTNDLE1BQU0sTUFBTSxHQUFHLEVBQUUsQ0FBQyxZQUFZLENBQzVCLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxFQUFFLGVBQWUsQ0FBQyxFQUNuQyxPQUFPLENBQ1IsQ0FBQztRQUNGLE1BQU0sQ0FBQyxNQUFNLENBQUMsSUFBSSxDQUFDLElBQUksQ0FBQyxLQUFLLENBQUMsTUFBTSxDQUFDLENBQUMsQ0FBQyxDQUFDLE9BQU8sQ0FDN0MsTUFBTSxDQUFDLGVBQWUsQ0FDcEIsV0FBVyxDQUFDLEdBQUcsQ0FBQyxDQUFDLENBQUMsRUFBRSxFQUFFLENBQUMseUJBQXlCLENBQUMsQ0FBQyxHQUFHLEVBQUUsQ0FBQyxDQUN6RCxDQUNGLENBQUM7SUFDSixDQUFDLENBQ0YsQ0FBQztBQUNKLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluY1xuLy8gU1BEWC1MaWNlbnNlLUlkZW50aWZpZXI6IE1QTC0yLjBcbmltcG9ydCAqIGFzIGZzIGZyb20gXCJmcy1leHRyYVwiO1xuaW1wb3J0ICogYXMgb3MgZnJvbSBcIm9zXCI7XG5pbXBvcnQgKiBhcyBwYXRoIGZyb20gXCJwYXRoXCI7XG5pbXBvcnQgeyBMYW5ndWFnZSwgVGVycmFmb3JtRGVwZW5kZW5jeUNvbnN0cmFpbnQgfSBmcm9tIFwiQGNka3RmL2NvbW1vbnNcIjtcbmltcG9ydCB7IENvbnN0cnVjdHNNYWtlciwgR2V0T3B0aW9ucyB9IGZyb20gXCIuLi8uLi9jb25zdHJ1Y3RzLW1ha2VyXCI7XG5cbmplc3Quc2V0VGltZW91dCg2MDBfMDAwKTtcbmdsb2JhbC5zZXRJbW1lZGlhdGUgPVxuICBnbG9iYWwuc2V0SW1tZWRpYXRlIHx8XG4gICgoZm46IGFueSwgLi4uYXJnczogYW55W10pID0+IGdsb2JhbC5zZXRUaW1lb3V0KGZuLCAwLCAuLi5hcmdzKSk7XG5cbmRlc2NyaWJlKFwidmVyc2lvbnMuanNvbiBmaWxlIGdlbmVyYXRpb25cIiwgKCkgPT4ge1xuICBjb25zdCBsYW5ndWFnZXMgPSBbTGFuZ3VhZ2UuVFlQRVNDUklQVCwgTGFuZ3VhZ2UuUFlUSE9OXTtcblxuICBjb25zdCBjb25zdHJhaW50czogVGVycmFmb3JtRGVwZW5kZW5jeUNvbnN0cmFpbnRbXSA9IFtcbiAgICB7XG4gICAgICBmcW46IFwiaGFzaGljb3JwL2F3c1wiLFxuICAgICAgbmFtZTogXCJhd3NcIixcbiAgICAgIHNvdXJjZTogXCJoYXNoaWNvcnAvYXdzXCIsXG4gICAgICB2ZXJzaW9uOiBcIjQuMC4wXCIsXG4gICAgfSxcbiAgICB7XG4gICAgICBmcW46IFwiaGFzaGljb3JwL3JhbmRvbVwiLFxuICAgICAgbmFtZTogXCJyYW5kb21cIixcbiAgICAgIHNvdXJjZTogXCJoYXNoaWNvcnAvcmFuZG9tXCIsXG4gICAgICB2ZXJzaW9uOiBcIjMuMS4zXCIsXG4gICAgfSxcbiAgICB7XG4gICAgICBmcW46IFwia3JldXp3ZXJrZXIvZG9ja2VyXCIsXG4gICAgICBuYW1lOiBcImRvY2tlclwiLFxuICAgICAgc291cmNlOiBcImtyZXV6d2Vya2VyL2RvY2tlclwiLFxuICAgICAgdmVyc2lvbjogXCIyLjE2LjBcIixcbiAgICB9LFxuICBdO1xuXG4gIGJlZm9yZUFsbCgoKSA9PiB7fSk7XG5cbiAgdGVzdC5lYWNoKGxhbmd1YWdlcykoXG4gICAgXCJnZW5lcmF0ZXMgYSBmaWxlIGZvciB0aGUgJXMgbGFuZ3VhZ2VcIixcbiAgICBhc3luYyAobGFuZ3VhZ2UpID0+IHtcbiAgICAgIGNvbnN0IHdvcmtkaXIgPSBmcy5ta2R0ZW1wU3luYyhcbiAgICAgICAgcGF0aC5qb2luKG9zLnRtcGRpcigpLCBcInZlcnNpb25zLWZpbGUudGVzdFwiKSxcbiAgICAgICk7XG5cbiAgICAgIGNvbnN0IG9wdGlvbnM6IEdldE9wdGlvbnMgPSB7XG4gICAgICAgIGNvZGVNYWtlck91dHB1dDogd29ya2RpcixcbiAgICAgICAgdGFyZ2V0TGFuZ3VhZ2U6IGxhbmd1YWdlLFxuICAgICAgfTtcblxuICAgICAgLy8gSWdub3JlIHdhcm5pbmdzIHRvIHBvcCB1cCBmcm9tIHRoZSBnZW5lcmF0ZSBmdW5jdGlvblxuICAgICAgcHJvY2Vzcy5lbnYuTk9ERV9PUFRJT05TID0gXCItLW1heC1vbGQtc3BhY2Utc2l6ZT0xNjM4NFwiO1xuICAgICAgY29uc3QgY29uc3RydWN0TWFrZXIgPSBuZXcgQ29uc3RydWN0c01ha2VyKFxuICAgICAgICBvcHRpb25zLFxuICAgICAgICBwcm9jZXNzLmVudi5DREtURl9FWFBFUklNRU5UQUxfUFJPVklERVJfU0NIRU1BX0NBQ0hFX1BBVEgsXG4gICAgICApO1xuXG4gICAgICBhd2FpdCBjb25zdHJ1Y3RNYWtlci5nZW5lcmF0ZShjb25zdHJhaW50cyk7XG5cbiAgICAgIGNvbnN0IG91dHB1dCA9IGZzLnJlYWRGaWxlU3luYyhcbiAgICAgICAgcGF0aC5qb2luKHdvcmtkaXIsIFwidmVyc2lvbnMuanNvblwiKSxcbiAgICAgICAgXCJ1dGYtOFwiLFxuICAgICAgKTtcbiAgICAgIGV4cGVjdChPYmplY3Qua2V5cyhKU09OLnBhcnNlKG91dHB1dCkpKS50b0VxdWFsKFxuICAgICAgICBleHBlY3QuYXJyYXlDb250YWluaW5nKFxuICAgICAgICAgIGNvbnN0cmFpbnRzLm1hcCgoYykgPT4gYHJlZ2lzdHJ5LnRlcnJhZm9ybS5pby8ke2MuZnFufWApLFxuICAgICAgICApLFxuICAgICAgKTtcbiAgICB9LFxuICApO1xufSk7XG4iXX0=