"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const provider_generator_1 = require("../../generator/provider-generator");
const codemaker_1 = require("codemaker");
test("computed optional complex attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "computed-complex-option.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "computed-optional-complex.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/computed-optional-complex/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("computed complex attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "computed-complex.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "computed-complex.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/computed-complex/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("computed complex nested attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "computed-complex-nested.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "computed-complex-nested.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/computed-complex-nested/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("string list attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "string-list.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "string-list.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/string-list/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("number list attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "number-list.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "number-list.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/number-list/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("boolean list attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "boolean-list.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "boolean-list.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/boolean-list/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("string map attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "string-map.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "string-map.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/string-map/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("number map attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "number-map.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "number-map.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/number-map/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("boolean map attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "boolean-map.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "boolean-map.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/boolean-map/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("deeply nested block types", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "block-types.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "deeply-nested-block-types.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/deeply-nested-block-types/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("single block type", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "single-block-type.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "single-block-type.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/single-block-type/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("set / list block type", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "set-list-block.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "block-type-set-list.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/block-type-set-list/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("computed nested complex list block type", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "nested-computed-list-block.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "block-type-nested-computed-list.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/block-type-nested-computed-list/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("primitive string", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "primitive-string.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "primitive-string.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/primitive-string/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("primitive number", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "primitive-number.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "primitive-number.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/primitive-number/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("primitive boolean", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "primitive-boolean.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "primitive-boolean.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/primitive-boolean/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("primitive dynamic", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "primitive-dynamic.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "primitive-dynamic.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/primitive-dynamic/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("ignored attributes", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "ignored-attributes.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "ignored-attributes.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/ignored-attributes/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("incompatible attribute names", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "incompatible-attribute-names.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "incompatible-attribute-names.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/incompatible-attribute-names/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("incompatible resource names", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "incompatible-resource-names.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "incompatible-resource-names.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const files = fs.readdirSync(path.join(workdir, "providers/test"));
    const topLevelFiles = ["index.ts", "lazy-index.ts"];
    expect(files).toMatchInlineSnapshot(`
    [
      "function-resource",
      "index.ts",
      "lazy-index.ts",
      "license-resource",
      "object-resource",
      "provider-resource",
      "static-resource",
      "string-resource",
      "version-resource",
    ]
  `);
    for (const file of files) {
        const output = fs.readFileSync(path.join(workdir, "providers/test/", file, topLevelFiles.includes(file) ? "" : "index.ts"), "utf-8");
        expect(output).toMatchSnapshot(file); // use filename as snapshot indicator to not depend on order of files (e.g. if new file appears)
    }
});
test("list of string map attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "list-of-string-map.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "list-of-string-map.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/list-of-string-map/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("map of string list attribute", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "map-of-string-list.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "map-of-string-list.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/map-of-string-list/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("reset and input name conflicts", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "name-conflict.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "name-conflict.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/name-conflict/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("list of list attributes", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "list-list-object.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "list-list-object.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/test/complex/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("list of list of strings", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "list-list-string.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "list-list-string.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    // const resourceOutput = fs.readFileSync(
    //   path.join(workdir, "providers/test/airbyte-connection/index.ts"),
    //   "utf-8"
    // );
    // expect(resourceOutput).toMatchSnapshot();
    const datasourceOutput = fs.readFileSync(path.join(workdir, "providers/test/data-airbyte-source-schema-catalog/index.ts"), "utf-8");
    expect(datasourceOutput).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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