"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const provider_generator_1 = require("../../generator/provider-generator");
const codemaker_1 = require("codemaker");
test("skips block type attributes in the disallow list", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "skip-attributes.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "aws_quicksight_template.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/quicksight-template/index.ts"), "utf-8");
    expect(output).toMatchSnapshot(`quicksight-template`);
    // There should also be no index structs
    expect(fs.existsSync(path.join(workdir, "providers/aws/quicksight-template/index-structs"))).toBe(false);
});
test("skips attribute type attributes in the disallow list", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "skip-attributes.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "data_aws_quicksight_analysis.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/data-aws-quicksight-analysis/index.ts"), "utf-8");
    expect(output).toMatchSnapshot(`data-quicksight-analysis`);
    // There should also be no index structs
    expect(fs.existsSync(path.join(workdir, "providers/aws/data-aws-quicksight-analysis/index-structs"))).toBe(false);
});
//# sourceMappingURL=data:application/json;base64,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