"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const provider_generator_1 = require("../../generator/provider-generator");
const codemaker_1 = require("codemaker");
test("generate a cloudfront distribution resource", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "cloudfront.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "aws_cloudfront_distribution.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/cloudfront-distribution/index.ts"), "utf-8");
    expect(output).toMatchSnapshot("cloudfront");
});
test("generate a s3 bucket resource", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "s3.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "aws_s3_bucket.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/s3-bucket/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("generate a fms admin account with an empty options interface", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "fms.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "aws_fms_admin_account.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/fms-admin-account/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("generate a security group", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "sg.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "aws_security_group.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/security-group/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("generate a datadog spans metric", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "sg.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "datadog_spans_metric.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/datadog/spans-metric/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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