"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const commons_1 = require("@cdktf/commons");
const constructs_maker_1 = require("../../constructs-maker");
const util_1 = require("../util");
const child_process_1 = require("child_process");
const onTf1_6AndNewer = (name, fn, timeout) => {
    const terraformBinaryName = process.env.TERRAFORM_BINARY_NAME || "terraform";
    const output = (0, child_process_1.execSync)(`${terraformBinaryName} version -json`);
    if (!output) {
        throw new Error("Could not determine Terraform version");
    }
    const tfVersion = JSON.parse(output.toString()).terraform_version;
    const [major, minor] = tfVersion.toString().split(".");
    if (Number(major) < 1 || (Number(major) === 1 && Number(minor) < 6)) {
        test.skip(`${name} (requires Terraform >= 1.6.0; but is ${tfVersion})`, fn, timeout);
    }
    else {
        test(name, fn, timeout);
    }
};
test("generate some modules", async () => {
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "module-generator.test"));
    const constraint = new commons_1.TerraformModuleConstraint("terraform-aws-modules/eks/aws@7.0.1");
    const maker = new constructs_maker_1.ConstructsMaker({
        codeMakerOutput: workdir,
        targetLanguage: commons_1.Language.TYPESCRIPT,
    }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
    await maker.generate([constraint]);
    const output = fs.readFileSync(path.join(workdir, "modules/terraform-aws-modules/aws/eks.ts"), "utf-8");
    expect(output).toMatchSnapshot();
}, 120000);
(0, util_1.expectModuleToMatchSnapshot)("no module outputs", "generator", [
    "module-no-outputs.test.fixture.tf",
]);
(0, util_1.expectModuleToMatchSnapshot)("typeless variables", "generator", [
    "module-no-variable-type.test.fixture.tf",
]);
(0, util_1.expectModuleToMatchSnapshot)("no newline", "generator", [
    "module-no-newline-1.test.fixture.tf",
    "module-no-newline-2.test.fixture.tf",
]);
test("generate multiple aws modules", async () => {
    jest.setTimeout(120000);
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "module-generator-aws.test"));
    const constraints = [
        new commons_1.TerraformModuleConstraint("terraform-aws-modules/vpc/aws@2.78.0"),
        new commons_1.TerraformModuleConstraint("terraform-aws-modules/rds-aurora/aws@4.1.0"),
    ];
    const maker = new constructs_maker_1.ConstructsMaker({
        codeMakerOutput: workdir,
        targetLanguage: commons_1.Language.TYPESCRIPT,
    }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
    await maker.generate(constraints);
    const vpcOutput = fs.readFileSync(path.join(workdir, "modules/terraform-aws-modules/aws/vpc.ts"), "utf-8");
    expect(vpcOutput).toMatchSnapshot();
    const rdsOutput = fs.readFileSync(path.join(workdir, "modules/terraform-aws-modules/aws/rds-aurora.ts"), "utf-8");
    expect(rdsOutput).toMatchSnapshot();
}, 120000);
test("generate nested module", async () => {
    jest.setTimeout(120000);
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "module-generator-nested.test"));
    const constraint = new commons_1.TerraformModuleConstraint("terraform-aws-modules/vpc/aws//modules/vpc-endpoints@3.19.0");
    const maker = new constructs_maker_1.ConstructsMaker({
        codeMakerOutput: workdir,
        targetLanguage: commons_1.Language.TYPESCRIPT,
    }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
    await maker.generate([constraint]);
    const output = fs.readFileSync(path.join(workdir, "modules/terraform-aws-modules/aws/vpc/modules/vpc-endpoints.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
(0, util_1.expectModuleToMatchSnapshot)("getX variables", "generator", [
    "module-get-x.test.fixture.tf",
]);
(0, util_1.expectModuleToMatchSnapshot)("handle */* in module variable default string", "generator", ["module-with-star-default.test.fixture.tf"]);
onTf1_6AndNewer("generate module that can't be initialized", async () => {
    jest.setTimeout(120000);
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "module-generator.test-no-init"));
    const constraint = new commons_1.TerraformModuleConstraint("milliHQ/next-js/aws@1.0.0-canary.5");
    const maker = new constructs_maker_1.ConstructsMaker({
        codeMakerOutput: workdir,
        targetLanguage: commons_1.Language.TYPESCRIPT,
    }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
    await maker.generate([constraint]);
    const output = fs.readFileSync(path.join(workdir, "modules/milliHQ/aws/next-js.ts"), "utf-8");
    // yes, this is a lot of code, but this test is skipped for some Terraform versions
    // which then shows snapshots as obsolete which fails the test
    // this way, there's no such problem if the test is skipped
    expect(output).toMatchInlineSnapshot(`
      "// generated by cdktf get
      // milliHQ/next-js/aws
      import { TerraformModule, TerraformModuleUserConfig } from 'cdktf';
      import { Construct } from 'constructs';
      export interface NextJsConfig extends TerraformModuleUserConfig {
        /**
        * ACM certificate arn for custom_domain
        */
        readonly cloudfrontAcmCertificateArn?: string;
        /**
        * Aliases for custom_domain
        *
        */
        readonly cloudfrontAliases?: string[];
        /**
        * Header keys that should be used to calculate the cache key in CloudFront.
        * Authorization
        */
        readonly cloudfrontCacheKeyHeaders?: string[];
        /**
        * Controls whether the main CloudFront distribution should be created.
        * true
        */
        readonly cloudfrontCreateDistribution?: boolean;
        /**
        * When using an external CloudFront distribution provide its arn.
        */
        readonly cloudfrontExternalArn?: string;
        /**
        * When using an external CloudFront distribution provide its id.
        */
        readonly cloudfrontExternalId?: string;
        /**
        * The minimum version of the SSL protocol that you want CloudFront to use for HTTPS connections. One of SSLv3, TLSv1, TLSv1_2016, TLSv1.1_2016, TLSv1.2_2018 or TLSv1.2_2019.
        * TLSv1
        */
        readonly cloudfrontMinimumProtocolVersion?: string;
        /**
        * Id of a custom request policy that overrides the default policy (AllViewer). Can be custom or managed.
        */
        readonly cloudfrontOriginRequestPolicy?: string;
        /**
        * Price class for the CloudFront distributions (main & proxy config). One of PriceClass_All, PriceClass_200, PriceClass_100.
        * PriceClass_100
        */
        readonly cloudfrontPriceClass?: string;
        /**
        * Id of a response headers policy. Can be custom or managed. Default is empty.
        */
        readonly cloudfrontResponseHeadersPolicy?: string;
        /**
        * An optional webacl2 arn or webacl id to associate with the cloudfront distribution
        */
        readonly cloudfrontWebaclId?: string;
        /**
        * Controls whether resources for image optimization support should be created or not.
        * true
        */
        readonly createImageOptimization?: boolean;
        /**
        * Use locally built packages rather than download them from npm.
        */
        readonly debugUseLocalPackages?: boolean;
        /**
        * Identifier for the deployment group (only lowercase alphanumeric characters and hyphens are allowed).
        * tf-next
        */
        readonly deploymentName?: string;
        /**
        * Controls whether it should be possible to run multiple deployments in parallel (requires multiple_deployments_base_domain).
        */
        readonly enableMultipleDeployments?: boolean;
        /**
        * Amount of memory in MB the worker Lambda Function for image optimization can use. Valid value between 128 MB to 10,240 MB, in 1 MB increments.
        * 2,048
        */
        readonly imageOptimizationLambdaMemorySize?: number;
        /**
        * Whether to deploy additional lambda JSON policies. If false, lambda_policy_json will not be attached to the lambda function. (Necessary since policy strings are only known after apply when using Terraforms data.aws_iam_policy_document)
        */
        readonly lambdaAttachPolicyJson?: boolean;
        /**
        * Set to true if the Lambda functions should be attached to a VPC. Use this setting if VPC resources should be accessed by the Lambda functions. When setting this to true, use vpc_security_group_ids and vpc_subnet_ids to specify the VPC networking. Note that attaching to a VPC would introduce a delay on to cold starts
        */
        readonly lambdaAttachToVpc?: boolean;
        /**
        * Additional policy document as JSON to attach to the Lambda Function role
        */
        readonly lambdaPolicyJson?: string;
        /**
        * ARN of IAM policy that scopes aws_iam_role access for the lambda
        */
        readonly lambdaRolePermissionsBoundary?: string;
        /**
        * Default wildcard domain where new deployments should be available. Should be in the form of *.example.com.
        */
        readonly multipleDeploymentsBaseDomain?: string;
        /**
        * Tag metadata to label AWS resources that support tags.
        * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
        */
        readonly tags?: { [key: string]: string };
        /**
        * Tag metadata to label AWS S3 buckets. Overrides tags with the same name in input variable tags.
        * The property type contains a map, they have special handling, please see {@link cdk.tf/module-map-inputs the docs}
        */
        readonly tagsS3Bucket?: { [key: string]: string };
        /**
        * The list of Security Group IDs to be used by the Lambda functions. lambda_attach_to_vpc should be set to true for these to be applied.
        *
        */
        readonly vpcSecurityGroupIds?: string[];
        /**
        * The list of VPC subnet IDs to attach the Lambda functions. lambda_attach_to_vpc should be set to true for these to be applied.
        *
        */
        readonly vpcSubnetIds?: string[];
      }
      /**
      * Defines an NextJs based on a Terraform module
      *
      * Docs at Terraform Registry: {@link https://registry.terraform.io/modules/milliHQ/next-js/aws/1.0.0-canary.5 milliHQ/next-js/aws}
      */
      export class NextJs extends TerraformModule {
        private readonly inputs: { [name: string]: any } = { }
        public constructor(scope: Construct, id: string, config: NextJsConfig = {}) {
          super(scope, id, {
            ...config,
            source: 'milliHQ/next-js/aws',
            version: '1.0.0-canary.5',
          });
          this.cloudfrontAcmCertificateArn = config.cloudfrontAcmCertificateArn;
          this.cloudfrontAliases = config.cloudfrontAliases;
          this.cloudfrontCacheKeyHeaders = config.cloudfrontCacheKeyHeaders;
          this.cloudfrontCreateDistribution = config.cloudfrontCreateDistribution;
          this.cloudfrontExternalArn = config.cloudfrontExternalArn;
          this.cloudfrontExternalId = config.cloudfrontExternalId;
          this.cloudfrontMinimumProtocolVersion = config.cloudfrontMinimumProtocolVersion;
          this.cloudfrontOriginRequestPolicy = config.cloudfrontOriginRequestPolicy;
          this.cloudfrontPriceClass = config.cloudfrontPriceClass;
          this.cloudfrontResponseHeadersPolicy = config.cloudfrontResponseHeadersPolicy;
          this.cloudfrontWebaclId = config.cloudfrontWebaclId;
          this.createImageOptimization = config.createImageOptimization;
          this.debugUseLocalPackages = config.debugUseLocalPackages;
          this.deploymentName = config.deploymentName;
          this.enableMultipleDeployments = config.enableMultipleDeployments;
          this.imageOptimizationLambdaMemorySize = config.imageOptimizationLambdaMemorySize;
          this.lambdaAttachPolicyJson = config.lambdaAttachPolicyJson;
          this.lambdaAttachToVpc = config.lambdaAttachToVpc;
          this.lambdaPolicyJson = config.lambdaPolicyJson;
          this.lambdaRolePermissionsBoundary = config.lambdaRolePermissionsBoundary;
          this.multipleDeploymentsBaseDomain = config.multipleDeploymentsBaseDomain;
          this.tags = config.tags;
          this.tagsS3Bucket = config.tagsS3Bucket;
          this.vpcSecurityGroupIds = config.vpcSecurityGroupIds;
          this.vpcSubnetIds = config.vpcSubnetIds;
        }
        public get cloudfrontAcmCertificateArn(): string | undefined {
          return this.inputs['cloudfront_acm_certificate_arn'] as string | undefined;
        }
        public set cloudfrontAcmCertificateArn(value: string | undefined) {
          this.inputs['cloudfront_acm_certificate_arn'] = value;
        }
        public get cloudfrontAliases(): string[] | undefined {
          return this.inputs['cloudfront_aliases'] as string[] | undefined;
        }
        public set cloudfrontAliases(value: string[] | undefined) {
          this.inputs['cloudfront_aliases'] = value;
        }
        public get cloudfrontCacheKeyHeaders(): string[] | undefined {
          return this.inputs['cloudfront_cache_key_headers'] as string[] | undefined;
        }
        public set cloudfrontCacheKeyHeaders(value: string[] | undefined) {
          this.inputs['cloudfront_cache_key_headers'] = value;
        }
        public get cloudfrontCreateDistribution(): boolean | undefined {
          return this.inputs['cloudfront_create_distribution'] as boolean | undefined;
        }
        public set cloudfrontCreateDistribution(value: boolean | undefined) {
          this.inputs['cloudfront_create_distribution'] = value;
        }
        public get cloudfrontExternalArn(): string | undefined {
          return this.inputs['cloudfront_external_arn'] as string | undefined;
        }
        public set cloudfrontExternalArn(value: string | undefined) {
          this.inputs['cloudfront_external_arn'] = value;
        }
        public get cloudfrontExternalId(): string | undefined {
          return this.inputs['cloudfront_external_id'] as string | undefined;
        }
        public set cloudfrontExternalId(value: string | undefined) {
          this.inputs['cloudfront_external_id'] = value;
        }
        public get cloudfrontMinimumProtocolVersion(): string | undefined {
          return this.inputs['cloudfront_minimum_protocol_version'] as string | undefined;
        }
        public set cloudfrontMinimumProtocolVersion(value: string | undefined) {
          this.inputs['cloudfront_minimum_protocol_version'] = value;
        }
        public get cloudfrontOriginRequestPolicy(): string | undefined {
          return this.inputs['cloudfront_origin_request_policy'] as string | undefined;
        }
        public set cloudfrontOriginRequestPolicy(value: string | undefined) {
          this.inputs['cloudfront_origin_request_policy'] = value;
        }
        public get cloudfrontPriceClass(): string | undefined {
          return this.inputs['cloudfront_price_class'] as string | undefined;
        }
        public set cloudfrontPriceClass(value: string | undefined) {
          this.inputs['cloudfront_price_class'] = value;
        }
        public get cloudfrontResponseHeadersPolicy(): string | undefined {
          return this.inputs['cloudfront_response_headers_policy'] as string | undefined;
        }
        public set cloudfrontResponseHeadersPolicy(value: string | undefined) {
          this.inputs['cloudfront_response_headers_policy'] = value;
        }
        public get cloudfrontWebaclId(): string | undefined {
          return this.inputs['cloudfront_webacl_id'] as string | undefined;
        }
        public set cloudfrontWebaclId(value: string | undefined) {
          this.inputs['cloudfront_webacl_id'] = value;
        }
        public get createImageOptimization(): boolean | undefined {
          return this.inputs['create_image_optimization'] as boolean | undefined;
        }
        public set createImageOptimization(value: boolean | undefined) {
          this.inputs['create_image_optimization'] = value;
        }
        public get debugUseLocalPackages(): boolean | undefined {
          return this.inputs['debug_use_local_packages'] as boolean | undefined;
        }
        public set debugUseLocalPackages(value: boolean | undefined) {
          this.inputs['debug_use_local_packages'] = value;
        }
        public get deploymentName(): string | undefined {
          return this.inputs['deployment_name'] as string | undefined;
        }
        public set deploymentName(value: string | undefined) {
          this.inputs['deployment_name'] = value;
        }
        public get enableMultipleDeployments(): boolean | undefined {
          return this.inputs['enable_multiple_deployments'] as boolean | undefined;
        }
        public set enableMultipleDeployments(value: boolean | undefined) {
          this.inputs['enable_multiple_deployments'] = value;
        }
        public get imageOptimizationLambdaMemorySize(): number | undefined {
          return this.inputs['image_optimization_lambda_memory_size'] as number | undefined;
        }
        public set imageOptimizationLambdaMemorySize(value: number | undefined) {
          this.inputs['image_optimization_lambda_memory_size'] = value;
        }
        public get lambdaAttachPolicyJson(): boolean | undefined {
          return this.inputs['lambda_attach_policy_json'] as boolean | undefined;
        }
        public set lambdaAttachPolicyJson(value: boolean | undefined) {
          this.inputs['lambda_attach_policy_json'] = value;
        }
        public get lambdaAttachToVpc(): boolean | undefined {
          return this.inputs['lambda_attach_to_vpc'] as boolean | undefined;
        }
        public set lambdaAttachToVpc(value: boolean | undefined) {
          this.inputs['lambda_attach_to_vpc'] = value;
        }
        public get lambdaPolicyJson(): string | undefined {
          return this.inputs['lambda_policy_json'] as string | undefined;
        }
        public set lambdaPolicyJson(value: string | undefined) {
          this.inputs['lambda_policy_json'] = value;
        }
        public get lambdaRolePermissionsBoundary(): string | undefined {
          return this.inputs['lambda_role_permissions_boundary'] as string | undefined;
        }
        public set lambdaRolePermissionsBoundary(value: string | undefined) {
          this.inputs['lambda_role_permissions_boundary'] = value;
        }
        public get multipleDeploymentsBaseDomain(): string | undefined {
          return this.inputs['multiple_deployments_base_domain'] as string | undefined;
        }
        public set multipleDeploymentsBaseDomain(value: string | undefined) {
          this.inputs['multiple_deployments_base_domain'] = value;
        }
        public get tags(): { [key: string]: string } | undefined {
          return this.inputs['tags'] as { [key: string]: string } | undefined;
        }
        public set tags(value: { [key: string]: string } | undefined) {
          this.inputs['tags'] = value;
        }
        public get tagsS3Bucket(): { [key: string]: string } | undefined {
          return this.inputs['tags_s3_bucket'] as { [key: string]: string } | undefined;
        }
        public set tagsS3Bucket(value: { [key: string]: string } | undefined) {
          this.inputs['tags_s3_bucket'] = value;
        }
        public get vpcSecurityGroupIds(): string[] | undefined {
          return this.inputs['vpc_security_group_ids'] as string[] | undefined;
        }
        public set vpcSecurityGroupIds(value: string[] | undefined) {
          this.inputs['vpc_security_group_ids'] = value;
        }
        public get vpcSubnetIds(): string[] | undefined {
          return this.inputs['vpc_subnet_ids'] as string[] | undefined;
        }
        public set vpcSubnetIds(value: string[] | undefined) {
          this.inputs['vpc_subnet_ids'] = value;
        }
        public get apiEndpointOutput() {
          return this.getString('api_endpoint')
        }
        public get apiEndpointAccessPolicyArnOutput() {
          return this.getString('api_endpoint_access_policy_arn')
        }
        public get cloudfrontCustomErrorResponseOutput() {
          return this.getString('cloudfront_custom_error_response')
        }
        public get cloudfrontDefaultCacheBehaviorOutput() {
          return this.getString('cloudfront_default_cache_behavior')
        }
        public get cloudfrontDefaultRootObjectOutput() {
          return this.getString('cloudfront_default_root_object')
        }
        public get cloudfrontDomainNameOutput() {
          return this.getString('cloudfront_domain_name')
        }
        public get cloudfrontHostedZoneIdOutput() {
          return this.getString('cloudfront_hosted_zone_id')
        }
        public get cloudfrontOrderedCacheBehaviorsOutput() {
          return this.getString('cloudfront_ordered_cache_behaviors')
        }
        public get cloudfrontOriginsOutput() {
          return this.getString('cloudfront_origins')
        }
        public get uploadBucketIdOutput() {
          return this.getString('upload_bucket_id')
        }
        protected synthesizeAttributes() {
          return this.inputs;
        }
        protected synthesizeHclAttributes(): { [name: string]: any } {
          return Object.fromEntries(
            Object.entries(this.inputs)
              .filter(([, val]) => val !== undefined)
              .map(([key, val]) => {
                return [
                  key,
                  {
                    value: val,
                    type: "any",
                  },
                ];
              })
          );
        }
      }
      "
    `);
}, 120000);
//# sourceMappingURL=data:application/json;base64,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