"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const provider_generator_1 = require("../../generator/provider-generator");
const codemaker_1 = require("codemaker");
// this is a workaround for a bug introduced in TS 3.9.x and seems to be unlikely to get fixed.
// Since jsii relies on TS < 4 at the moment we can't use newer TS versions which have this fixed (^4.1).
// see https://github.com/hashicorp/terraform-cdk/pull/1248 for more context
test("shard exports across multiple files to avoid generating files with more than a 1000 exports", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "export-sharding.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "aws_wafv2_web_acl.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index.ts"), "utf-8");
    expect(output).toMatchSnapshot(`wafv2-web-acl-resource`);
    const outputStructsIndex = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/index.ts"), "utf-8");
    expect(outputStructsIndex).toMatchSnapshot(`structs-index`);
    const outputStructs0 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs0.ts"), "utf-8");
    expect(outputStructs0).toMatchSnapshot(`structs0`);
    const outputStructs400 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs400.ts"), "utf-8");
    expect(outputStructs400).toMatchSnapshot(`structs400`);
    const outputStructs800 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs800.ts"), "utf-8");
    expect(outputStructs800).toMatchSnapshot(`structs800`);
    const outputStructs1200 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs1200.ts"), "utf-8");
    expect(outputStructs1200).toMatchSnapshot(`structs1200`);
    const outputStructs1600 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs1600.ts"), "utf-8");
    expect(outputStructs1600).toMatchSnapshot(`structs1600`);
    const outputStructs2000 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs2000.ts"), "utf-8");
    expect(outputStructs2000).toMatchSnapshot(`structs2000`);
    const outputStructs2400 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs2400.ts"), "utf-8");
    expect(outputStructs2400).toMatchSnapshot(`structs2400`);
    const outputStructs2800 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs2800.ts"), "utf-8");
    expect(outputStructs2800).toMatchSnapshot(`structs2800`);
    const outputStructs3200 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs3200.ts"), "utf-8");
    expect(outputStructs3200).toMatchSnapshot(`structs3200`);
    const outputStructs3600 = fs.readFileSync(path.join(workdir, "providers/test/wafv2-web-acl/index-structs/structs3600.ts"), "utf-8");
    expect(outputStructs3600).toMatchSnapshot(`structs3600`);
});
test("shard exports across multiple files to avoid generating files with more than a 1000 exports in a provider without namespaces", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "export-sharding-no-namespace.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "datadog_dashboard.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/datadog/dashboard/index.ts"), "utf-8");
    expect(output).toMatchSnapshot(`dashboard-resource`);
    const outputStructsIndex = fs.readFileSync(path.join(workdir, "providers/datadog/dashboard/index-structs/index.ts"), "utf-8");
    expect(outputStructsIndex).toMatchSnapshot(`structs-index`);
    const outputStructs0 = fs.readFileSync(path.join(workdir, "providers/datadog/dashboard/index-structs/structs0.ts"), "utf-8");
    expect(outputStructs0).toMatchSnapshot(`structs0`);
    const outputStructs400 = fs.readFileSync(path.join(workdir, "providers/datadog/dashboard/index-structs/structs400.ts"), "utf-8");
    expect(outputStructs400).toMatchSnapshot(`structs400`);
});
//# sourceMappingURL=data:application/json;base64,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