"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const provider_generator_1 = require("../../generator/provider-generator");
const codemaker_1 = require("codemaker");
test("broken attribute description comments", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "description-escaping.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "description-escaping.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/google/description-escaping/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
// That popped up in the google-beta provider which transforms markdown fenced
// code blocks from the actual markdown docs to the provider schema (``` => ''')
// see
//  - https://raw.githubusercontent.com/hashicorp/terraform-provider-google-beta/4094e3bdd530ca853a046a6d938807f8a131c7c7/website/docs/r/iam_workload_identity_pool_provider.html.markdown
//  - https://github.com/hashicorp/terraform-provider-google-beta/blob/4094e3bdd530ca853a046a6d938807f8a131c7c7/google-beta/resource_iam_beta_workload_identity_pool_provider.go
test("malformed code blocks which break in python rst", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "markdown-description-with-code-blocks.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "markdown-description-with-code-blocks.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/code-blocks/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
test("comment ending sequence in comment", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "comment-ending-sequence.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "comment-ending-sequence.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/code-blocks/index.ts"), "utf-8");
    expect(output).toMatchSnapshot();
});
//# sourceMappingURL=data:application/json;base64,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