"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc // SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const provider_generator_1 = require("../../generator/provider-generator");
const codemaker_1 = require("codemaker");
test("generate a resource with attribute that's a list of a map of an object", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "deep-nested-attributes.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "stripe-schema.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/stripe/invoiceitems/index.ts"), "utf-8");
    expect(output).toEqual(expect.stringContaining(`export class InvoiceitemsDiscountsMapList extends cdktf.MapList {`));
});
test("generate a resource with attribute that's a map of a list of an object", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "deep-nested-attributes-list.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "deep-attributes.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/stripe/invoiceitems/index.ts"), "utf-8");
    expect(output).toEqual(expect.stringContaining(`export class InvoiceitemsDiscountsListMap extends cdktf.ComplexMap {`));
});
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiZGVlcC1uZXN0ZWQtYXR0cmlidXRlcy50ZXN0LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiZGVlcC1uZXN0ZWQtYXR0cmlidXRlcy50ZXN0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7Ozs7QUFBQSxtRUFBbUU7QUFDbkUsdUNBQXlCO0FBQ3pCLHVDQUF5QjtBQUN6QiwyQ0FBNkI7QUFDN0IsMkVBQWdGO0FBQ2hGLHlDQUFzQztBQUV0QyxJQUFJLENBQUMsd0VBQXdFLEVBQUUsS0FBSyxJQUFJLEVBQUU7SUFDeEYsTUFBTSxJQUFJLEdBQUcsSUFBSSxxQkFBUyxFQUFFLENBQUM7SUFDN0IsTUFBTSxPQUFPLEdBQUcsRUFBRSxDQUFDLFdBQVcsQ0FDNUIsSUFBSSxDQUFDLElBQUksQ0FBQyxFQUFFLENBQUMsTUFBTSxFQUFFLEVBQUUsNkJBQTZCLENBQUMsQ0FDdEQsQ0FBQztJQUNGLE1BQU0sSUFBSSxHQUFHLElBQUksQ0FBQyxLQUFLLENBQ3JCLEVBQUUsQ0FBQyxZQUFZLENBQ2IsSUFBSSxDQUFDLElBQUksQ0FBQyxTQUFTLEVBQUUsVUFBVSxFQUFFLGlDQUFpQyxDQUFDLEVBQ25FLE9BQU8sQ0FDUixDQUNGLENBQUM7SUFDRixJQUFJLCtDQUEwQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsQ0FBQyxXQUFXLEVBQUUsQ0FBQztJQUN6RCxNQUFNLElBQUksQ0FBQyxJQUFJLENBQUMsT0FBTyxDQUFDLENBQUM7SUFFekIsTUFBTSxNQUFNLEdBQUcsRUFBRSxDQUFDLFlBQVksQ0FDNUIsSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLEVBQUUsd0NBQXdDLENBQUMsRUFDNUQsT0FBTyxDQUNSLENBQUM7SUFFRixNQUFNLENBQUMsTUFBTSxDQUFDLENBQUMsT0FBTyxDQUNwQixNQUFNLENBQUMsZ0JBQWdCLENBQ3JCLG1FQUFtRSxDQUNwRSxDQUNGLENBQUM7QUFDSixDQUFDLENBQUMsQ0FBQztBQUVILElBQUksQ0FBQyx3RUFBd0UsRUFBRSxLQUFLLElBQUksRUFBRTtJQUN4RixNQUFNLElBQUksR0FBRyxJQUFJLHFCQUFTLEVBQUUsQ0FBQztJQUM3QixNQUFNLE9BQU8sR0FBRyxFQUFFLENBQUMsV0FBVyxDQUM1QixJQUFJLENBQUMsSUFBSSxDQUFDLEVBQUUsQ0FBQyxNQUFNLEVBQUUsRUFBRSxrQ0FBa0MsQ0FBQyxDQUMzRCxDQUFDO0lBQ0YsTUFBTSxJQUFJLEdBQUcsSUFBSSxDQUFDLEtBQUssQ0FDckIsRUFBRSxDQUFDLFlBQVksQ0FDYixJQUFJLENBQUMsSUFBSSxDQUFDLFNBQVMsRUFBRSxVQUFVLEVBQUUsbUNBQW1DLENBQUMsRUFDckUsT0FBTyxDQUNSLENBQ0YsQ0FBQztJQUNGLElBQUksK0NBQTBCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQyxDQUFDLFdBQVcsRUFBRSxDQUFDO0lBQ3pELE1BQU0sSUFBSSxDQUFDLElBQUksQ0FBQyxPQUFPLENBQUMsQ0FBQztJQUV6QixNQUFNLE1BQU0sR0FBRyxFQUFFLENBQUMsWUFBWSxDQUM1QixJQUFJLENBQUMsSUFBSSxDQUFDLE9BQU8sRUFBRSx3Q0FBd0MsQ0FBQyxFQUM1RCxPQUFPLENBQ1IsQ0FBQztJQUVGLE1BQU0sQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLENBQ3BCLE1BQU0sQ0FBQyxnQkFBZ0IsQ0FDckIsc0VBQXNFLENBQ3ZFLENBQ0YsQ0FBQztBQUNKLENBQUMsQ0FBQyxDQUFDIiwic291cmNlc0NvbnRlbnQiOlsiLy8gQ29weXJpZ2h0IChjKSBIYXNoaUNvcnAsIEluYyAvLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuaW1wb3J0ICogYXMgZnMgZnJvbSBcImZzXCI7XG5pbXBvcnQgKiBhcyBvcyBmcm9tIFwib3NcIjtcbmltcG9ydCAqIGFzIHBhdGggZnJvbSBcInBhdGhcIjtcbmltcG9ydCB7IFRlcnJhZm9ybVByb3ZpZGVyR2VuZXJhdG9yIH0gZnJvbSBcIi4uLy4uL2dlbmVyYXRvci9wcm92aWRlci1nZW5lcmF0b3JcIjtcbmltcG9ydCB7IENvZGVNYWtlciB9IGZyb20gXCJjb2RlbWFrZXJcIjtcblxudGVzdChcImdlbmVyYXRlIGEgcmVzb3VyY2Ugd2l0aCBhdHRyaWJ1dGUgdGhhdCdzIGEgbGlzdCBvZiBhIG1hcCBvZiBhbiBvYmplY3RcIiwgYXN5bmMgKCkgPT4ge1xuICBjb25zdCBjb2RlID0gbmV3IENvZGVNYWtlcigpO1xuICBjb25zdCB3b3JrZGlyID0gZnMubWtkdGVtcFN5bmMoXG4gICAgcGF0aC5qb2luKG9zLnRtcGRpcigpLCBcImRlZXAtbmVzdGVkLWF0dHJpYnV0ZXMudGVzdFwiKSxcbiAgKTtcbiAgY29uc3Qgc3BlYyA9IEpTT04ucGFyc2UoXG4gICAgZnMucmVhZEZpbGVTeW5jKFxuICAgICAgcGF0aC5qb2luKF9fZGlybmFtZSwgXCJmaXh0dXJlc1wiLCBcInN0cmlwZS1zY2hlbWEudGVzdC5maXh0dXJlLmpzb25cIiksXG4gICAgICBcInV0Zi04XCIsXG4gICAgKSxcbiAgKTtcbiAgbmV3IFRlcnJhZm9ybVByb3ZpZGVyR2VuZXJhdG9yKGNvZGUsIHNwZWMpLmdlbmVyYXRlQWxsKCk7XG4gIGF3YWl0IGNvZGUuc2F2ZSh3b3JrZGlyKTtcblxuICBjb25zdCBvdXRwdXQgPSBmcy5yZWFkRmlsZVN5bmMoXG4gICAgcGF0aC5qb2luKHdvcmtkaXIsIFwicHJvdmlkZXJzL3N0cmlwZS9pbnZvaWNlaXRlbXMvaW5kZXgudHNcIiksXG4gICAgXCJ1dGYtOFwiLFxuICApO1xuXG4gIGV4cGVjdChvdXRwdXQpLnRvRXF1YWwoXG4gICAgZXhwZWN0LnN0cmluZ0NvbnRhaW5pbmcoXG4gICAgICBgZXhwb3J0IGNsYXNzIEludm9pY2VpdGVtc0Rpc2NvdW50c01hcExpc3QgZXh0ZW5kcyBjZGt0Zi5NYXBMaXN0IHtgLFxuICAgICksXG4gICk7XG59KTtcblxudGVzdChcImdlbmVyYXRlIGEgcmVzb3VyY2Ugd2l0aCBhdHRyaWJ1dGUgdGhhdCdzIGEgbWFwIG9mIGEgbGlzdCBvZiBhbiBvYmplY3RcIiwgYXN5bmMgKCkgPT4ge1xuICBjb25zdCBjb2RlID0gbmV3IENvZGVNYWtlcigpO1xuICBjb25zdCB3b3JrZGlyID0gZnMubWtkdGVtcFN5bmMoXG4gICAgcGF0aC5qb2luKG9zLnRtcGRpcigpLCBcImRlZXAtbmVzdGVkLWF0dHJpYnV0ZXMtbGlzdC50ZXN0XCIpLFxuICApO1xuICBjb25zdCBzcGVjID0gSlNPTi5wYXJzZShcbiAgICBmcy5yZWFkRmlsZVN5bmMoXG4gICAgICBwYXRoLmpvaW4oX19kaXJuYW1lLCBcImZpeHR1cmVzXCIsIFwiZGVlcC1hdHRyaWJ1dGVzLnRlc3QuZml4dHVyZS5qc29uXCIpLFxuICAgICAgXCJ1dGYtOFwiLFxuICAgICksXG4gICk7XG4gIG5ldyBUZXJyYWZvcm1Qcm92aWRlckdlbmVyYXRvcihjb2RlLCBzcGVjKS5nZW5lcmF0ZUFsbCgpO1xuICBhd2FpdCBjb2RlLnNhdmUod29ya2Rpcik7XG5cbiAgY29uc3Qgb3V0cHV0ID0gZnMucmVhZEZpbGVTeW5jKFxuICAgIHBhdGguam9pbih3b3JrZGlyLCBcInByb3ZpZGVycy9zdHJpcGUvaW52b2ljZWl0ZW1zL2luZGV4LnRzXCIpLFxuICAgIFwidXRmLThcIixcbiAgKTtcblxuICBleHBlY3Qob3V0cHV0KS50b0VxdWFsKFxuICAgIGV4cGVjdC5zdHJpbmdDb250YWluaW5nKFxuICAgICAgYGV4cG9ydCBjbGFzcyBJbnZvaWNlaXRlbXNEaXNjb3VudHNMaXN0TWFwIGV4dGVuZHMgY2RrdGYuQ29tcGxleE1hcCB7YCxcbiAgICApLFxuICApO1xufSk7XG4iXX0=