"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const provider_generator_1 = require("../../generator/provider-generator");
const codemaker_1 = require("codemaker");
test("generate an acm certifacte resource with complex computed types", async () => {
    const code = new codemaker_1.CodeMaker();
    const workdir = fs.mkdtempSync(path.join(os.tmpdir(), "complex-computed-types.test"));
    const spec = JSON.parse(fs.readFileSync(path.join(__dirname, "fixtures", "aws_acm_certificate.test.fixture.json"), "utf-8"));
    new provider_generator_1.TerraformProviderGenerator(code, spec).generateAll();
    await code.save(workdir);
    const output = fs.readFileSync(path.join(workdir, "providers/aws/acm-certificate/index.ts"), "utf-8");
    expect(output).toMatchSnapshot(`acm-certificate`);
});
//# sourceMappingURL=data:application/json;base64,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