"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const fs = __importStar(require("fs-extra"));
const os = __importStar(require("os"));
const path = __importStar(require("path"));
const commons_1 = require("@cdktf/commons");
const constructs_maker_1 = require("../constructs-maker");
describe("constructsMaker", () => {
    describe("determineGoModuleName", () => {
        let tmpDir;
        let emptySubDir, validSubdir, invalidSubdir;
        beforeAll(async () => {
            tmpDir = await fs.mkdtemp(path.join(os.tmpdir(), "cdktf.test"));
            /* test directory layout
             * <tmpDir>
             * ├── go.mod
             * └── subdir
             *     ├── empty
             *     ├── valid
             *     │   └── go.mod
             *     └── invalid
             *         └── go.mod
             */
            emptySubDir = path.join(tmpDir, "subdir", "empty");
            validSubdir = path.join(tmpDir, "subdir", "valid");
            invalidSubdir = path.join(tmpDir, "subdir", "invalid");
            await fs.mkdirs(emptySubDir);
            await fs.mkdirs(validSubdir);
            await fs.mkdirs(invalidSubdir);
            const root = `module cdk.tf/test/go`;
            const valid = `module cdk.tf/test/go-valid-subdir`;
            const invalid = `malformed go mod`;
            await fs.writeFile(path.join(tmpDir, "go.mod"), root);
            await fs.writeFile(path.join(validSubdir, "go.mod"), valid);
            await fs.writeFile(path.join(invalidSubdir, "go.mod"), invalid);
        });
        afterAll(async () => {
            // await fs.remove(tmpDir);
        });
        it("works in root directory", async () => {
            const moduleName = await (0, constructs_maker_1.determineGoModuleName)(tmpDir);
            expect(moduleName).toBe("cdk.tf/test/go");
        });
        it("can walk upwards from empty directory", async () => {
            const moduleName = await (0, constructs_maker_1.determineGoModuleName)(emptySubDir);
            expect(moduleName).toBe("cdk.tf/test/go/subdir/empty");
        });
        it("works in subdirectory with go.mod", async () => {
            const moduleName = await (0, constructs_maker_1.determineGoModuleName)(validSubdir);
            expect(moduleName).toBe("cdk.tf/test/go-valid-subdir");
        });
        it("throws if go.mod is invalid", async () => {
            await expect((0, constructs_maker_1.determineGoModuleName)(invalidSubdir)).rejects.toThrow(`Could not determine the root Go module name. Found ${path.join(invalidSubdir, "go.mod")} but failed to regex match the module name directive`);
        });
        it("works from subdirectory that does not exist yet", async () => {
            const moduleName = await (0, constructs_maker_1.determineGoModuleName)(path.join(tmpDir, "subdir", "that", "does", "not", "exist", "yet"));
            expect(moduleName).toBe("cdk.tf/test/go/subdir/that/does/not/exist/yet");
        });
        it("throws if nothing could be found", async () => {
            const dir = "/cdktf-test/this/dir/does/not/exist"; //... and has no go.mod in any parent dir
            await expect((0, constructs_maker_1.determineGoModuleName)(dir)).rejects.toThrow(`Could not determine the root Go module name. No go.mod found in ${dir} and any parent directories`);
        });
    });
    describe("ConstructsMakerProviderTarget", () => {
        it("returns valid package name for Go", () => {
            const target = new commons_1.ConstructsMakerProviderTarget({
                name: "google-beta",
                fqn: "google-beta",
                source: "google-beta",
                version: "~> 4.0",
            }, commons_1.Language.GO);
            expect(target.srcMakName).toEqual("google_beta");
        });
    });
    describe("ConstructsMakerModuleTarget", () => {
        it("returns valid package name for Go", () => {
            const target = new commons_1.ConstructsMakerModuleTarget({
                name: "security-group",
                source: "terraform-aws-modules/security-group/aws",
                fqn: "terraform-aws-modules/security-group/aws",
                version: "4.9.0",
                namespace: "terraform-aws-modules/aws",
            }, commons_1.Language.GO);
            expect(target.srcMakName).toEqual("security_group");
        });
    });
});
//# sourceMappingURL=data:application/json;base64,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