"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const glob_1 = require("glob");
const commons_1 = require("@cdktf/commons");
const constructs_maker_1 = require("../get/constructs-maker");
const commons_2 = require("@cdktf/commons");
function directorySnapshot(root) {
    const output = {};
    const files = glob_1.glob.sync("**", {
        ignore: [".git/**", ".jsii"],
        cwd: root,
        nodir: true,
        dot: true,
    });
    for (const file of files) {
        const filePath = path.join(root, file);
        let content;
        if (path.extname(filePath) === ".json") {
            content = fs.readJsonSync(filePath);
            if (path.basename(filePath) === "constraints.json") {
                delete content.cdktf;
            }
        }
        else {
            content = fs.readFileSync(filePath, "utf-8");
        }
        output[file] = content;
    }
    return output;
}
function resourceTypesPresentInSnapshot(snapshot, providerNameInPath) {
    const resources = [];
    const files = Object.keys(snapshot);
    for (const file of files) {
        const match = file.match(`/providers\/${providerNameInPath}\/(.*?)\/index\.ts/`);
        // avoids any not resources from being pushed
        if (match &&
            !match[1].includes("/") &&
            !match[1].includes("data-") &&
            !match[1].includes("provider")) {
            resources.push(match[1]);
        }
    }
    return resources;
}
describe("Provider", () => {
    it("generates a provider", async () => {
        const constraint = new commons_2.TerraformProviderConstraint("DataDog/datadog@= 3.12.0");
        return await (0, commons_1.mkdtemp)(async (workdir) => {
            const jsiiPath = path.join(workdir, ".jsii");
            const maker = new constructs_maker_1.ConstructsMaker({
                codeMakerOutput: workdir,
                outputJsii: jsiiPath,
                targetLanguage: commons_2.Language.TYPESCRIPT,
            }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
            await maker.generate([constraint]);
            const snapshot = directorySnapshot(workdir);
            expect(snapshot).toMatchSnapshot();
        });
    }, 600000);
    it("has generated provider that includes static import functions", async () => {
        const constraint = new commons_2.TerraformProviderConstraint("DataDog/datadog@= 3.12.0");
        return await (0, commons_1.mkdtemp)(async (workdir) => {
            const jsiiPath = path.join(workdir, ".jsii");
            const maker = new constructs_maker_1.ConstructsMaker({
                codeMakerOutput: workdir,
                outputJsii: jsiiPath,
                targetLanguage: commons_2.Language.TYPESCRIPT,
            });
            await maker.generate([constraint]);
            const snapshot = directorySnapshot(workdir);
            const terraformResourceTypesPresent = resourceTypesPresentInSnapshot(snapshot, "datadog");
            terraformResourceTypesPresent.forEach((resource) => {
                let terraformResourceType = resource.replace(/-/g, "_");
                if (!terraformResourceType.includes("datadog")) {
                    terraformResourceType = `datadog_${terraformResourceType}`;
                }
                expect(snapshot[`providers/datadog/${resource}/index.ts`]).toContain(`public static generateConfigForImport(scope: Construct, importToId: string, importFromId: string, provider?: cdktf.TerraformProvider) {`);
                expect(snapshot[`providers/datadog/${resource}/index.ts`]).toContain(`return new cdktf.ImportableResource(scope, importToId, { terraformResourceType: "${terraformResourceType}", importId: importFromId, provider });`);
            });
        });
    }, 600000);
    it("has name in constraint that does not match resolved name in fqpn", async () => {
        const constraint = new commons_2.TerraformProviderConstraint({
            name: "dockerr",
            source: "registry.terraform.io/kreuzwerker/docker",
            version: "3.0.2",
        });
        return await (0, commons_1.mkdtemp)(async (workdir) => {
            const jsiiPath = path.join(workdir, ".jsii");
            const maker = new constructs_maker_1.ConstructsMaker({
                codeMakerOutput: workdir,
                outputJsii: jsiiPath,
                targetLanguage: commons_2.Language.TYPESCRIPT,
            }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
            await maker.generate([constraint]);
            const snapshot = directorySnapshot(workdir);
            const terraformResourceTypesPresent = resourceTypesPresentInSnapshot(snapshot, "dockerr");
            terraformResourceTypesPresent.forEach((resource) => {
                expect(snapshot[`providers/dockerr/${resource}/index.ts`]).toBeDefined();
            });
        });
    }, 600000);
    it("generates constructs for two providers with same name", async () => {
        const constraint = new commons_2.TerraformProviderConstraint({
            name: "bitbucket",
            namespace: "Runelab",
            version: "2.1.0",
            source: "Runelab/bitbucket",
        });
        const constraint2 = new commons_2.TerraformProviderConstraint({
            name: "abitbucket",
            namespace: "aeirola",
            version: "2.0.2",
            source: "aeirola/bitbucket",
        });
        return await (0, commons_1.mkdtemp)(async (workdir) => {
            const jsiiPath = path.join(workdir, ".jsii");
            const maker = new constructs_maker_1.ConstructsMaker({
                codeMakerOutput: workdir,
                outputJsii: jsiiPath,
                targetLanguage: commons_2.Language.TYPESCRIPT,
            }, process.env.CDKTF_EXPERIMENTAL_PROVIDER_SCHEMA_CACHE_PATH);
            await maker.generate([constraint, constraint2]);
            console.log("workdir", workdir);
            const snapshot = directorySnapshot(workdir);
            expect(snapshot).toMatchSnapshot();
        });
    }, 600000);
});
//# sourceMappingURL=data:application/json;base64,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