"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.edgeSchema = void 0;
const builder_1 = require("./builder");
const required_attribute_resource = new builder_1.SchemaBuilder()
    .addAllPrimitiveTypes({ required: true, computed: false })
    .addAllPrimitiveListTypes({ required: true, computed: false })
    .build();
const optional_attribute_resource = new builder_1.SchemaBuilder()
    .addAllPrimitiveTypes({ required: false, computed: false })
    .addAllPrimitiveListTypes({ required: false, computed: false })
    .build();
const optional_computed_attribute_resource = new builder_1.SchemaBuilder()
    .addAllPrimitiveTypes({ required: false, computed: true })
    .addAllPrimitiveListTypes({ required: false, computed: true })
    .build();
const list_block_resource = new builder_1.SchemaBuilder()
    .listBlock({
    name: "opt",
    block: new builder_1.SchemaBuilder().addAllPrimitivePermutations().asBlock(),
    minItems: 0,
    maxItems: 42,
})
    .listBlock({
    name: "req",
    block: new builder_1.SchemaBuilder().addAllPrimitivePermutations().asBlock(),
    minItems: 1,
    maxItems: 42,
})
    .listBlock({
    name: "singleopt",
    block: new builder_1.SchemaBuilder().addAllPrimitivePermutations().asBlock(),
    minItems: 0,
    maxItems: 1,
})
    .listBlock({
    name: "singlereq",
    block: new builder_1.SchemaBuilder().addAllPrimitivePermutations().asBlock(),
    minItems: 1,
    maxItems: 1,
})
    .listBlock({
    name: "singleComputedBlock",
    block: new builder_1.SchemaBuilder()
        .attribute({
        computed: true,
        name: "computed",
        type: "string",
        required: false,
        optional: false,
    })
        .attribute({
        computed: false,
        name: "configured",
        type: "string",
        required: false,
    })
        .asBlock(),
    minItems: 0,
    maxItems: 1,
})
    .attribute({
    name: "computedListOfObject",
    type: [
        "list",
        [
            "object",
            {
                str: "string",
            },
        ],
    ],
    computed: true,
    optional: false,
})
    .attribute({
    name: "computedListOfMapOfObject",
    type: [
        "list",
        [
            "map",
            [
                "object",
                {
                    str: "string",
                    other: "string",
                },
            ],
        ],
    ],
    computed: true,
    optional: false,
})
    .build();
const map_list_resource = new builder_1.SchemaBuilder()
    .attribute({
    name: "mapListOfObject",
    type: [
        "map",
        [
            "list",
            [
                "object",
                {
                    hello: "string",
                },
            ],
        ],
    ],
    computed: false,
    optional: false,
})
    .build();
const map_resource = new builder_1.SchemaBuilder()
    .attribute({
    name: "optMap",
    type: ["map", "string"],
    required: false,
    computed: false,
})
    .attribute({
    name: "reqMap",
    type: ["map", "bool"],
    required: true,
    computed: false,
})
    .attribute({
    name: "computedMap",
    type: ["map", "number"],
    required: false,
    computed: true,
})
    .build();
const set_block_resource = new builder_1.SchemaBuilder()
    .setBlock({
    name: "set",
    block: new builder_1.SchemaBuilder().addAllPrimitivePermutations().asBlock(),
})
    .build();
exports.edgeSchema = (0, builder_1.schema)({
    name: "edge",
    provider: new builder_1.SchemaBuilder().addAllPrimitivePermutations().build(),
    resources: {
        required_attribute_resource,
        optional_attribute_resource,
        optional_computed_attribute_resource,
        list_block_resource,
        map_resource,
        set_block_resource,
        map_list_resource,
    },
    dataSources: {},
});
//# sourceMappingURL=data:application/json;base64,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