"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const path = __importStar(require("path"));
const fs = __importStar(require("fs-extra"));
const _1 = require(".");
const __1 = require("../..");
// This script builds the schema for the edge provider into the given directory for all languages.
const args = process.argv.slice(2);
const targetPath = args[0];
if (!targetPath) {
    console.error("No target path specified");
    process.exit(1);
}
// Clear / Create path
fs.mkdirpSync(targetPath);
fs.emptyDirSync(targetPath);
const deps = ["@types/node", "constructs", "cdktf"];
(async () => {
    await (0, __1.generateProviderBindingsFromSchema)(targetPath, _1.edgeSchema, {
        entrypoint: path.join("providers", "edge", "index.ts"),
        deps: deps.map((dep) => path.dirname(require.resolve(`${dep}/package.json`))),
        moduleKey: "edge",
        python: {
            outdir: path.resolve(targetPath, "python"),
            moduleName: "edge",
        },
        java: {
            outdir: path.resolve(targetPath, "java"),
            package: `imports.edgeprovider`,
        },
        csharp: {
            outdir: path.resolve(targetPath, "csharp"),
            namespace: "Providers.Edge",
        },
        golang: {
            outdir: path.resolve(targetPath, "go"),
            moduleName: "cdk.tf/go/stack/generated/hashicorp",
            packageName: "edge",
        },
    });
})();
//# sourceMappingURL=data:application/json;base64,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