"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.SchemaBuilder = exports.schema = void 0;
function schema({ name, provider, resources = {}, dataSources = {}, }) {
    return {
        format_version: "0.2",
        provider_schemas: {
            [`registry.terraform.io/cdktf/${name}`]: {
                provider: provider,
                resource_schemas: resources,
                data_source_schemas: dataSources,
            },
        },
    };
}
exports.schema = schema;
class SchemaBuilder {
    constructor() {
        this.schema = {
            version: 0,
            block: {
                attributes: {},
                block_types: {},
            },
        };
    }
    attribute({ name, type, required = false, computed = false, optional = !required, }) {
        this.schema.block.attributes[name] = {
            type,
            optional,
            computed,
            required,
        };
        return this;
    }
    listBlock({ name, block, minItems, maxItems, }) {
        this.schema.block.block_types[name] = {
            nesting_mode: "list",
            block,
            min_items: minItems,
            max_items: maxItems,
        };
        return this;
    }
    mapBlock({ name, block, }) {
        this.schema.block.block_types[name] = { nesting_mode: "map", block };
        return this;
    }
    setBlock({ name, block, }) {
        this.schema.block.block_types[name] = { nesting_mode: "set", block };
        return this;
    }
    singleBlock({ name, block, }) {
        this.schema.block.block_types[name] = { nesting_mode: "single", block };
        return this;
    }
    build() {
        return this.schema;
    }
    asBlock() {
        return this.schema.block;
    }
    addAllPrimitiveTypes({ required, computed, prefix = "", }) {
        this.attribute({ name: prefix + "str", type: "string", required, computed })
            .attribute({ name: prefix + "num", type: "number", required, computed })
            .attribute({ name: prefix + "bool", type: "bool", required, computed });
        return this;
    }
    addAllPrimitivePermutations() {
        this.addAllPrimitiveTypes({
            required: false,
            computed: false,
            prefix: "opt",
        })
            .addAllPrimitiveTypes({ required: true, computed: false, prefix: "req" })
            .addAllPrimitiveTypes({
            required: false,
            computed: true,
            prefix: "computed",
        });
        return this;
    }
    addAllPrimitiveListTypes({ required, computed, prefix = "", }) {
        this.attribute({
            name: prefix + "strList",
            type: ["list", "string"],
            required,
            computed,
        })
            .attribute({
            name: prefix + "numList",
            type: ["list", "number"],
            required,
            computed,
        })
            .attribute({
            name: prefix + "boolList",
            type: ["list", "bool"],
            required,
            computed,
        });
        return this;
    }
}
exports.SchemaBuilder = SchemaBuilder;
//# sourceMappingURL=data:application/json;base64,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