import { ProviderSchema, Schema, AttributeType, Block } from "@cdktf/commons";
type ResourceSchema = {
    [type: string]: Schema;
};
export declare function schema({ name, provider, resources, dataSources, }: {
    name: string;
    provider: Schema;
    resources: ResourceSchema;
    dataSources: ResourceSchema;
}): ProviderSchema;
export declare class SchemaBuilder {
    private schema;
    constructor();
    attribute({ name, type, required, computed, optional, }: {
        name: string;
        type: AttributeType;
        required?: boolean;
        computed?: boolean;
        optional?: boolean;
    }): SchemaBuilder;
    listBlock({ name, block, minItems, maxItems, }: {
        name: string;
        block: Block;
        minItems: number;
        maxItems: number;
    }): SchemaBuilder;
    mapBlock({ name, block, }: {
        name: string;
        block: Block;
    }): SchemaBuilder;
    setBlock({ name, block, }: {
        name: string;
        block: Block;
    }): SchemaBuilder;
    singleBlock({ name, block, }: {
        name: string;
        block: Block;
    }): SchemaBuilder;
    build(): Schema;
    asBlock(): Block;
    addAllPrimitiveTypes({ required, computed, prefix, }: {
        required: boolean;
        computed: boolean;
        prefix?: string;
    }): SchemaBuilder;
    addAllPrimitivePermutations(): SchemaBuilder;
    addAllPrimitiveListTypes({ required, computed, prefix, }: {
        required: boolean;
        computed: boolean;
        prefix?: string;
    }): SchemaBuilder;
}
export {};
