"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
var fs = require("fs");
var os = require("os");
var path = require("path");
function prebuildName() {
    var tags = [];
    tags.push(process.versions.hasOwnProperty('electron') ? 'electron' : 'node');
    tags.push('abi' + process.versions.modules);
    if (os.platform() === 'linux' && fs.existsSync('/etc/alpine-release')) {
        tags.push('musl');
    }
    return tags.join('.') + '.node';
}
var pathToBuild = path.resolve(__dirname, "../prebuilds/" + os.platform() + "-" + os.arch() + "/" + prebuildName());
var winParentDir = path.resolve(__dirname, "../prebuilds/" + os.platform() + "-" + os.arch() + "/abi" + process.versions.modules + "/build/Release");
exports.ptyPath = fs.existsSync(pathToBuild) ? pathToBuild : null;
exports.winPtyPath = fs.existsSync(winParentDir) ? winParentDir + "/pty.node" : null;
exports.winConPtyPath = fs.existsSync(winParentDir) ? winParentDir + "/conpty.node" : null;
exports.winConPtyConsoleListPath = fs.existsSync(winParentDir) ? winParentDir + "/conpty_console_list.node" : null;
//# sourceMappingURL=prebuild-file-path.js.map