/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
/**
 * This function is used to escape quotes within a string.
 *  Note: This is a really naive implmentation that will not be able to work with
 *    nested templates. However, nested templates require parsing, so we will
 *    only handle strings without nested templates for the moment
 * @param input The string to escape
 */
export declare function replaceQuotes(input: string): string;
/**
 * This function is used to wrap a string in quotes conditionally.
 *  - If the string is already quoted, it will be returned as-is.
 *  - If the string contains a newline, it will be wrapped in a heredoc.
 *  - If the string is a number, it will be returned as-is.
 *  - If the string is a boolean, it will be returned as-is.
 *  - If the string is a list or map, it will be returned as-is.
 *
 * @param input The string to wrap
 * @returns The wrapped string, and the offset of the cursor within the string
 *
 * @example
 * wrapTerraformExpression("foo") // { wrap: '"foo"', wrapOffset: 1 }
 * wrapTerraformExpression("foo\nbar") // { wrap: '<<EOE\nfoo\nbar\nEOE\n', wrapOffset: 5 }
 * wrapTerraformExpression("22") // { wrap: '22', wrapOffset: 0 }
 * wrapTerraformExpression("true") // { wrap: 'true', wrapOffset: 0 }
 * wrapTerraformExpression("[22, 10]") // { wrap: '[22, 10]', wrapOffset: 0 }
 * wrapTerraformExpression("{ foo = 22 }") // { wrap: '{ foo = 22 }', wrapOffset: 0 }
 */
export declare function wrapTerraformExpression(input: string): {
    wrap: string;
    wrapOffset: number;
};
//# sourceMappingURL=util.d.ts.map