"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getChildWithValue = exports.isIndexTraversalPart = exports.isNameTraversalPart = exports.isObjectExpression = exports.isTupleExpression = exports.isBinaryOpExpression = exports.isUnaryOpExpression = exports.isConditionalExpression = exports.isSplatExpression = exports.isIndexExpression = exports.isLiteralValueExpression = exports.isRelativeTraversalExpression = exports.isScopeTraversalExpression = exports.isFunctionCallExpression = exports.isTemplateExpression = exports.isTemplateWrapExpression = exports.isForExpression = void 0;
function isForExpression(ast) {
    return ast.type === "for";
}
exports.isForExpression = isForExpression;
function isTemplateWrapExpression(ast) {
    return ast.type === "templateWrap";
}
exports.isTemplateWrapExpression = isTemplateWrapExpression;
function isTemplateExpression(ast) {
    return ast.type === "template";
}
exports.isTemplateExpression = isTemplateExpression;
function isFunctionCallExpression(ast) {
    return ast.type === "function";
}
exports.isFunctionCallExpression = isFunctionCallExpression;
function isScopeTraversalExpression(ast) {
    return ast.type === "scopeTraversal";
}
exports.isScopeTraversalExpression = isScopeTraversalExpression;
function isRelativeTraversalExpression(ast) {
    return ast.type === "relativeTraversal";
}
exports.isRelativeTraversalExpression = isRelativeTraversalExpression;
function isLiteralValueExpression(ast) {
    return ast.type === "literalValue";
}
exports.isLiteralValueExpression = isLiteralValueExpression;
function isIndexExpression(ast) {
    return ast.type === "index";
}
exports.isIndexExpression = isIndexExpression;
function isSplatExpression(ast) {
    return ast.type === "splat";
}
exports.isSplatExpression = isSplatExpression;
function isConditionalExpression(ast) {
    return ast.type === "conditional";
}
exports.isConditionalExpression = isConditionalExpression;
function isUnaryOpExpression(ast) {
    return ast.type === "unaryOp";
}
exports.isUnaryOpExpression = isUnaryOpExpression;
function isBinaryOpExpression(ast) {
    return ast.type === "binaryOp";
}
exports.isBinaryOpExpression = isBinaryOpExpression;
function isTupleExpression(ast) {
    return ast.type === "tuple";
}
exports.isTupleExpression = isTupleExpression;
function isObjectExpression(part) {
    return part.type === "object";
}
exports.isObjectExpression = isObjectExpression;
function isNameTraversalPart(part) {
    return part.type === "nameTraversal";
}
exports.isNameTraversalPart = isNameTraversalPart;
function isIndexTraversalPart(part) {
    return part.type === "indexTraversal";
}
exports.isIndexTraversalPart = isIndexTraversalPart;
function getChildWithValue(node, value) {
    if (!node.children) {
        return null;
    }
    return node.children.find((child) => {
        if (!child.meta)
            return false;
        return child.meta.value === value;
    });
}
exports.getChildWithValue = getChildWithValue;
//# sourceMappingURL=data:application/json;base64,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