"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.variableName = exports.constructAst = exports.referenceToVariableName = void 0;
const t = __importStar(require("@babel/types"));
const utils_1 = require("./utils");
const provider_generator_1 = require("@cdktf/provider-generator");
const provider_1 = require("./provider");
const reserved_words_1 = __importDefault(require("reserved-words"));
function referenceToVariableName(scope, ref) {
    const parts = ref.referencee.id.split(".");
    const resource = parts[0] === "data" ? `${parts[0]}.${parts[1]}` : parts[0];
    const name = parts[0] === "data" ? parts[2] : parts[1];
    return variableName(scope, resource, name);
}
exports.referenceToVariableName = referenceToVariableName;
function validVarName(name) {
    if (reserved_words_1.default.check(name)) {
        return `${name}Var`;
    }
    if (!Number.isNaN(parseInt(name[0], 10))) {
        return `d${name}`;
    }
    return name;
}
function getUniqueName(scope, provider, type) {
    var _a;
    // early abort on cdktf
    if (provider === "cdktf") {
        return (0, utils_1.pascalCase)(type.replace("cdktf_", ""));
    }
    if (provider === "NullProvider") {
        return (0, utils_1.pascalCase)(type.replace("NullProvider_", ""));
    }
    // Special handling for provider blocks, e.g. aws_AwsProvider
    if (type === `${(0, utils_1.pascalCase)(provider)}Provider`) {
        return (0, provider_generator_1.sanitizeClassOrNamespaceName)(type, true);
    }
    const fullProviderName = (0, provider_1.getFullProviderName)(scope.providerSchema, provider);
    if (fullProviderName && scope.providerGenerator[fullProviderName]) {
        return (_a = scope.providerGenerator[fullProviderName]) === null || _a === void 0 ? void 0 : _a.getClassNameForResource(type);
    }
    else {
        // If we can not find the class name for a resource the caller needs to find a sensible default
        return null;
    }
}
function getResourceNamespace(scope, provider, resource, isDataSource, type) {
    var _a;
    // happens e.g. for references to cdktf.TerraformStack (and similar) in generated code
    if (provider === "cdktf") {
        return undefined;
    }
    // e.g. awsProvider -> provider
    if (resource === (0, utils_1.pascalCase)(`${provider}_provider`) ||
        (provider === "NullProvider" && resource === "NullProvider")) {
        return "provider";
    }
    const fullProviderName = (0, provider_1.getFullProviderName)(scope.providerSchema, provider);
    if (fullProviderName && scope.providerGenerator[fullProviderName]) {
        return (0, utils_1.camelCase)((_a = scope.providerGenerator[fullProviderName]) === null || _a === void 0 ? void 0 : _a.getNamespaceNameForResource(type.replace(/\./g, "_")));
    }
    if (isDataSource) {
        return (0, utils_1.camelCase)((0, provider_generator_1.sanitizeClassOrNamespaceName)(`data_${provider}_${resource}`));
    }
    return (0, utils_1.camelCase)((0, provider_generator_1.sanitizeClassOrNamespaceName)(resource));
}
function constructAst(scope, type, isModuleImport) {
    if (isModuleImport) {
        return t.memberExpression(t.identifier(type), t.identifier(type));
    }
    if (type.startsWith("var.")) {
        scope.importables.push({
            provider: "cdktf",
            constructName: "TerraformVariable",
        });
        return t.identifier("TerraformVariable");
    }
    if (type === "terraform.data") {
        scope.importables.push({
            constructName: "DataResource",
            provider: "cdktf",
        });
        return t.identifier("DataResource");
    }
    // resources or data sources
    if (!type.includes("./") && type.includes(".")) {
        const parts = type.split(".");
        if (parts[0] === "data") {
            const [, provider, resource] = parts;
            const namespace = getResourceNamespace(scope, provider, resource, true, type);
            const resourceName = getUniqueName(scope, provider, parts.join("_")) ||
                (0, utils_1.pascalCase)((0, provider_generator_1.sanitizeClassOrNamespaceName)(`data_${provider}_${resource}`));
            scope.importables.push({
                provider: provider,
                constructName: resourceName,
                namespace,
            });
            if (namespace) {
                return t.identifier(resourceName); // e.g. DataAwsInstance
            }
            return t.identifier(resourceName); // e.g. DataAwsNatGateway
        }
        const [provider, resource] = parts;
        const namespace = getResourceNamespace(scope, provider, resource, false, type);
        const resourceName = getUniqueName(scope, provider, parts.join("_")) ||
            (0, utils_1.pascalCase)((0, provider_generator_1.sanitizeClassOrNamespaceName)(resource));
        scope.importables.push({
            provider: provider,
            constructName: resourceName,
            namespace,
        });
        if (namespace) {
            return t.identifier(resourceName); // e.g. Instance
        }
        return t.identifier(resourceName); // e.g. BigQueryTable
    }
    return t.identifier((0, utils_1.pascalCase)(type));
}
exports.constructAst = constructAst;
function variableName(scope, resource, name) {
    const consistentResourceName = resource.replace(/\./g, "_");
    // name collision, we need to prefix the name
    if (scope.variables[name]) {
        if (consistentResourceName === scope.variables[name].resource) {
            return scope.variables[name].variableName;
        }
        // we only cache one per name
        return validVarName((0, utils_1.camelCase)([resource, name].join("_")));
    }
    const variableName = validVarName((0, utils_1.camelCase)(name));
    scope.variables[name] = {
        variableName,
        resource: consistentResourceName,
    };
    return variableName;
}
exports.variableName = variableName;
//# sourceMappingURL=data:application/json;base64,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