"use strict";
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.uniqueId = exports.pascalCase = exports.camelCase = exports.leaveCommentText = exports.logger = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const camelcase_1 = __importDefault(require("camelcase"));
var commons_1 = require("@cdktf/commons");
Object.defineProperty(exports, "logger", { enumerable: true, get: function () { return commons_1.logger; } });
exports.leaveCommentText = `Please leave a comment at https://cdk.tf/bugs/convert-expressions if you run into this issue.`;
const camelCase = (str) => (0, camelcase_1.default)(str.replace(/[-/]/g, "_"));
exports.camelCase = camelCase;
const pascalCase = (str) => (0, camelcase_1.default)(str.replace(/[-/]/g, "_"), { pascalCase: true });
exports.pascalCase = pascalCase;
function uniqueId(set, key) {
    if (set.has(key)) {
        return uniqueId(set, `${key}_${set.size}`);
    }
    set.add(key);
    return key;
}
exports.uniqueId = uniqueId;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoidXRpbHMuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJ1dGlscy50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7Ozs7QUFBQSwrQkFBK0I7QUFDL0IsbUNBQW1DO0FBQ25DLDBEQUFrQztBQUVsQywwQ0FBd0M7QUFBL0IsaUdBQUEsTUFBTSxPQUFBO0FBRUYsUUFBQSxnQkFBZ0IsR0FBRywrRkFBK0YsQ0FBQztBQUV6SCxNQUFNLFNBQVMsR0FBRyxDQUFDLEdBQVcsRUFBRSxFQUFFLENBQUMsSUFBQSxtQkFBUyxFQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxDQUFDLENBQUM7QUFBbEUsUUFBQSxTQUFTLGFBQXlEO0FBQ3hFLE1BQU0sVUFBVSxHQUFHLENBQUMsR0FBVyxFQUFFLEVBQUUsQ0FDeEMsSUFBQSxtQkFBUyxFQUFDLEdBQUcsQ0FBQyxPQUFPLENBQUMsT0FBTyxFQUFFLEdBQUcsQ0FBQyxFQUFFLEVBQUUsVUFBVSxFQUFFLElBQUksRUFBRSxDQUFDLENBQUM7QUFEaEQsUUFBQSxVQUFVLGNBQ3NDO0FBRTdELFNBQWdCLFFBQVEsQ0FBQyxHQUFnQixFQUFFLEdBQVc7SUFDcEQsSUFBSSxHQUFHLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxFQUFFLENBQUM7UUFDakIsT0FBTyxRQUFRLENBQUMsR0FBRyxFQUFFLEdBQUcsR0FBRyxJQUFJLEdBQUcsQ0FBQyxJQUFJLEVBQUUsQ0FBQyxDQUFDO0lBQzdDLENBQUM7SUFDRCxHQUFHLENBQUMsR0FBRyxDQUFDLEdBQUcsQ0FBQyxDQUFDO0lBQ2IsT0FBTyxHQUFHLENBQUM7QUFDYixDQUFDO0FBTkQsNEJBTUMiLCJzb3VyY2VzQ29udGVudCI6WyIvLyBDb3B5cmlnaHQgKGMpIEhhc2hpQ29ycCwgSW5jXG4vLyBTUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogTVBMLTIuMFxuaW1wb3J0IGNhbWVsY2FzZSBmcm9tIFwiY2FtZWxjYXNlXCI7XG5cbmV4cG9ydCB7IGxvZ2dlciB9IGZyb20gXCJAY2RrdGYvY29tbW9uc1wiO1xuXG5leHBvcnQgY29uc3QgbGVhdmVDb21tZW50VGV4dCA9IGBQbGVhc2UgbGVhdmUgYSBjb21tZW50IGF0IGh0dHBzOi8vY2RrLnRmL2J1Z3MvY29udmVydC1leHByZXNzaW9ucyBpZiB5b3UgcnVuIGludG8gdGhpcyBpc3N1ZS5gO1xuXG5leHBvcnQgY29uc3QgY2FtZWxDYXNlID0gKHN0cjogc3RyaW5nKSA9PiBjYW1lbGNhc2Uoc3RyLnJlcGxhY2UoL1stL10vZywgXCJfXCIpKTtcbmV4cG9ydCBjb25zdCBwYXNjYWxDYXNlID0gKHN0cjogc3RyaW5nKSA9PlxuICBjYW1lbGNhc2Uoc3RyLnJlcGxhY2UoL1stL10vZywgXCJfXCIpLCB7IHBhc2NhbENhc2U6IHRydWUgfSk7XG5cbmV4cG9ydCBmdW5jdGlvbiB1bmlxdWVJZChzZXQ6IFNldDxzdHJpbmc+LCBrZXk6IHN0cmluZyk6IHN0cmluZyB7XG4gIGlmIChzZXQuaGFzKGtleSkpIHtcbiAgICByZXR1cm4gdW5pcXVlSWQoc2V0LCBgJHtrZXl9XyR7c2V0LnNpemV9YCk7XG4gIH1cbiAgc2V0LmFkZChrZXkpO1xuICByZXR1cm4ga2V5O1xufVxuIl19