import { TerraformProviderGenerator } from "@cdktf/provider-generator";
import { ProviderSchema } from "@cdktf/commons";
export type TerraformResourceBlock = unknown;
export type AttributePath = string;
export type ProgramScope = {
    providerSchema: ProviderSchema;
    providerGenerator: Record<string, TerraformProviderGenerator>;
    constructs: Set<string>;
    variables: Record<string, {
        resource: string;
        variableName: string;
    }>;
    hasTokenBasedTypeCoercion: boolean;
    nodeIds: string[];
    importables: ImportableConstruct[];
    topLevelConfig: Record<string, AttributePath>;
};
export type ResourceScope = ProgramScope & {
    forEachIteratorName?: string;
    countIteratorName?: string;
    withinOverrideExpression?: boolean;
    scopedVariables?: Record<string, string>;
};
export type Reference = {
    start: number;
    end: number;
    referencee: {
        id: string;
        full: string;
    };
    useFqn?: boolean;
    isVariable?: boolean;
};
export type DynamicBlock = {
    path: string;
    for_each: string;
    content: TerraformResourceBlock;
    scopedVar: string;
};
export type IteratorVariableReference = {
    start: number;
    end: number;
    value: string;
};
export type ImportableConstruct = {
    provider: string;
    constructName: string;
    namespace?: string;
};
//# sourceMappingURL=types.d.ts.map