"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.schema = void 0;
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
const z = __importStar(require("zod"));
const tfObject = (config) => z.array(z.object(config).partial());
const outputConfig = tfObject({
    value: z.any(),
    description: z.string().optional(),
    sensitive: z.boolean().optional(),
    depends_on: z.string().optional(),
});
const validationConfig = z.object({
    error_message: z.string(),
    condition: z.any(),
});
const variableConfig = tfObject({
    type: z.string(),
    default: z.any(),
    description: z.string(),
    sensitive: z.boolean(),
    nullable: z.boolean().optional(),
    validation: z.array(validationConfig).optional(),
});
const providerConfig = z.array(z.record(z.any()));
const moduleConfig = z.array(z.object({ source: z.string() }).nonstrict());
const resourceConfig = z.array(z.record(z.any()));
const importConfig = z.object({
    to: z.string(),
    id: z.string(),
    provider: z.any().optional(),
});
const providerSpecification = z.union([
    z.object({ source: z.string(), version: z.string() }).partial(),
    z.string(),
]);
const terraformConfig = z
    .object({
    required_version: z.string(),
    required_providers: z.array(z.record(providerSpecification)),
    backend: z.record(z.array(z.record(z.any()))),
})
    .partial();
exports.schema = z
    .object({
    data: z.record(z.record(resourceConfig)),
    import: z.array(importConfig),
    locals: z.array(z.record(z.any())),
    module: z.record(moduleConfig),
    output: z.record(outputConfig),
    provider: z.record(providerConfig),
    resource: z.record(z.record(resourceConfig)),
    terraform: z.array(terraformConfig),
    variable: z.record(variableConfig),
})
    .partial();
//# sourceMappingURL=data:application/json;base64,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