import * as z from "zod";
declare const outputConfig: z.ZodArray<z.ZodObject<{
    value: z.ZodOptional<z.ZodAny>;
    description: z.ZodOptional<z.ZodOptional<z.ZodString>>;
    sensitive: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    depends_on: z.ZodOptional<z.ZodOptional<z.ZodString>>;
}, "strip", z.ZodTypeAny, {
    value?: any;
    description?: string | undefined;
    sensitive?: boolean | undefined;
    depends_on?: string | undefined;
}, {
    value?: any;
    description?: string | undefined;
    sensitive?: boolean | undefined;
    depends_on?: string | undefined;
}>, "many">;
export type Output = z.infer<typeof outputConfig>;
declare const variableConfig: z.ZodArray<z.ZodObject<{
    type: z.ZodOptional<z.ZodString>;
    default: z.ZodOptional<z.ZodAny>;
    description: z.ZodOptional<z.ZodString>;
    sensitive: z.ZodOptional<z.ZodBoolean>;
    nullable: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
    validation: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodObject<{
        error_message: z.ZodString;
        condition: z.ZodAny;
    }, "strip", z.ZodTypeAny, {
        error_message: string;
        condition?: any;
    }, {
        error_message: string;
        condition?: any;
    }>, "many">>>;
}, "strip", z.ZodTypeAny, {
    type?: string | undefined;
    default?: any;
    description?: string | undefined;
    sensitive?: boolean | undefined;
    nullable?: boolean | undefined;
    validation?: {
        error_message: string;
        condition?: any;
    }[] | undefined;
}, {
    type?: string | undefined;
    default?: any;
    description?: string | undefined;
    sensitive?: boolean | undefined;
    nullable?: boolean | undefined;
    validation?: {
        error_message: string;
        condition?: any;
    }[] | undefined;
}>, "many">;
export type Variable = z.infer<typeof variableConfig>;
declare const providerConfig: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">;
export type Provider = z.infer<typeof providerConfig>;
declare const moduleConfig: z.ZodArray<z.ZodObject<{
    source: z.ZodString;
}, "passthrough", z.ZodTypeAny, z.objectOutputType<{
    source: z.ZodString;
}, z.ZodTypeAny, "passthrough">, z.objectInputType<{
    source: z.ZodString;
}, z.ZodTypeAny, "passthrough">>, "many">;
export type Module = z.infer<typeof moduleConfig>;
declare const resourceConfig: z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">;
export type Resource = z.infer<typeof resourceConfig>;
export type Data = Resource;
declare const importConfig: z.ZodObject<{
    to: z.ZodString;
    id: z.ZodString;
    provider: z.ZodOptional<z.ZodAny>;
}, "strip", z.ZodTypeAny, {
    to: string;
    id: string;
    provider?: any;
}, {
    to: string;
    id: string;
    provider?: any;
}>;
export type Import = z.infer<typeof importConfig>;
declare const terraformConfig: z.ZodObject<{
    required_version: z.ZodOptional<z.ZodString>;
    required_providers: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<{
        source: z.ZodOptional<z.ZodString>;
        version: z.ZodOptional<z.ZodString>;
    }, "strip", z.ZodTypeAny, {
        source?: string | undefined;
        version?: string | undefined;
    }, {
        source?: string | undefined;
        version?: string | undefined;
    }>, z.ZodString]>>, "many">>;
    backend: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">>>;
}, "strip", z.ZodTypeAny, {
    backend?: Record<string, Record<string, any>[]> | undefined;
    required_providers?: Record<string, string | {
        source?: string | undefined;
        version?: string | undefined;
    }>[] | undefined;
    required_version?: string | undefined;
}, {
    backend?: Record<string, Record<string, any>[]> | undefined;
    required_providers?: Record<string, string | {
        source?: string | undefined;
        version?: string | undefined;
    }>[] | undefined;
    required_version?: string | undefined;
}>;
export type TerraformConfig = z.infer<typeof terraformConfig>;
export declare const schema: z.ZodObject<{
    data: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">>>>;
    import: z.ZodOptional<z.ZodArray<z.ZodObject<{
        to: z.ZodString;
        id: z.ZodString;
        provider: z.ZodOptional<z.ZodAny>;
    }, "strip", z.ZodTypeAny, {
        to: string;
        id: string;
        provider?: any;
    }, {
        to: string;
        id: string;
        provider?: any;
    }>, "many">>;
    locals: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">>;
    module: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodObject<{
        source: z.ZodString;
    }, "passthrough", z.ZodTypeAny, z.objectOutputType<{
        source: z.ZodString;
    }, z.ZodTypeAny, "passthrough">, z.objectInputType<{
        source: z.ZodString;
    }, z.ZodTypeAny, "passthrough">>, "many">>>;
    output: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodObject<{
        value: z.ZodOptional<z.ZodAny>;
        description: z.ZodOptional<z.ZodOptional<z.ZodString>>;
        sensitive: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
        depends_on: z.ZodOptional<z.ZodOptional<z.ZodString>>;
    }, "strip", z.ZodTypeAny, {
        value?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        depends_on?: string | undefined;
    }, {
        value?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        depends_on?: string | undefined;
    }>, "many">>>;
    provider: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">>>;
    resource: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodRecord<z.ZodString, z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">>>>;
    terraform: z.ZodOptional<z.ZodArray<z.ZodObject<{
        required_version: z.ZodOptional<z.ZodString>;
        required_providers: z.ZodOptional<z.ZodArray<z.ZodRecord<z.ZodString, z.ZodUnion<[z.ZodObject<{
            source: z.ZodOptional<z.ZodString>;
            version: z.ZodOptional<z.ZodString>;
        }, "strip", z.ZodTypeAny, {
            source?: string | undefined;
            version?: string | undefined;
        }, {
            source?: string | undefined;
            version?: string | undefined;
        }>, z.ZodString]>>, "many">>;
        backend: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodRecord<z.ZodString, z.ZodAny>, "many">>>;
    }, "strip", z.ZodTypeAny, {
        backend?: Record<string, Record<string, any>[]> | undefined;
        required_providers?: Record<string, string | {
            source?: string | undefined;
            version?: string | undefined;
        }>[] | undefined;
        required_version?: string | undefined;
    }, {
        backend?: Record<string, Record<string, any>[]> | undefined;
        required_providers?: Record<string, string | {
            source?: string | undefined;
            version?: string | undefined;
        }>[] | undefined;
        required_version?: string | undefined;
    }>, "many">>;
    variable: z.ZodOptional<z.ZodRecord<z.ZodString, z.ZodArray<z.ZodObject<{
        type: z.ZodOptional<z.ZodString>;
        default: z.ZodOptional<z.ZodAny>;
        description: z.ZodOptional<z.ZodString>;
        sensitive: z.ZodOptional<z.ZodBoolean>;
        nullable: z.ZodOptional<z.ZodOptional<z.ZodBoolean>>;
        validation: z.ZodOptional<z.ZodOptional<z.ZodArray<z.ZodObject<{
            error_message: z.ZodString;
            condition: z.ZodAny;
        }, "strip", z.ZodTypeAny, {
            error_message: string;
            condition?: any;
        }, {
            error_message: string;
            condition?: any;
        }>, "many">>>;
    }, "strip", z.ZodTypeAny, {
        type?: string | undefined;
        default?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        nullable?: boolean | undefined;
        validation?: {
            error_message: string;
            condition?: any;
        }[] | undefined;
    }, {
        type?: string | undefined;
        default?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        nullable?: boolean | undefined;
        validation?: {
            error_message: string;
            condition?: any;
        }[] | undefined;
    }>, "many">>>;
}, "strip", z.ZodTypeAny, {
    terraform?: {
        backend?: Record<string, Record<string, any>[]> | undefined;
        required_providers?: Record<string, string | {
            source?: string | undefined;
            version?: string | undefined;
        }>[] | undefined;
        required_version?: string | undefined;
    }[] | undefined;
    provider?: Record<string, Record<string, any>[]> | undefined;
    module?: Record<string, z.objectOutputType<{
        source: z.ZodString;
    }, z.ZodTypeAny, "passthrough">[]> | undefined;
    resource?: Record<string, Record<string, Record<string, any>[]>> | undefined;
    data?: Record<string, Record<string, Record<string, any>[]>> | undefined;
    output?: Record<string, {
        value?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        depends_on?: string | undefined;
    }[]> | undefined;
    variable?: Record<string, {
        type?: string | undefined;
        default?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        nullable?: boolean | undefined;
        validation?: {
            error_message: string;
            condition?: any;
        }[] | undefined;
    }[]> | undefined;
    import?: {
        to: string;
        id: string;
        provider?: any;
    }[] | undefined;
    locals?: Record<string, any>[] | undefined;
}, {
    terraform?: {
        backend?: Record<string, Record<string, any>[]> | undefined;
        required_providers?: Record<string, string | {
            source?: string | undefined;
            version?: string | undefined;
        }>[] | undefined;
        required_version?: string | undefined;
    }[] | undefined;
    provider?: Record<string, Record<string, any>[]> | undefined;
    module?: Record<string, z.objectInputType<{
        source: z.ZodString;
    }, z.ZodTypeAny, "passthrough">[]> | undefined;
    resource?: Record<string, Record<string, Record<string, any>[]>> | undefined;
    data?: Record<string, Record<string, Record<string, any>[]>> | undefined;
    output?: Record<string, {
        value?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        depends_on?: string | undefined;
    }[]> | undefined;
    variable?: Record<string, {
        type?: string | undefined;
        default?: any;
        description?: string | undefined;
        sensitive?: boolean | undefined;
        nullable?: boolean | undefined;
        validation?: {
            error_message: string;
            condition?: any;
        }[] | undefined;
    }[]> | undefined;
    import?: {
        to: string;
        id: string;
        provider?: any;
    }[] | undefined;
    locals?: Record<string, any>[] | undefined;
}>;
export {};
//# sourceMappingURL=schema.d.ts.map