"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.getProviderRequirements = exports.getFullProviderName = void 0;
function getFullProviderName(schema, providerName) {
    return Object.keys(schema.provider_schemas || {}).find((name) => name.endsWith(providerName));
}
exports.getFullProviderName = getFullProviderName;
function getProviderRequirements(plan) {
    var _a;
    // In Terraform one can implicitly define the provider by using resources of that type
    const explicitProviders = Object.keys(plan.provider || {});
    const implicitProviders = Object.keys({ ...plan.resource, ...plan.data })
        .filter((type) => type !== "terraform_remote_state")
        .filter((type) => type !== "terraform_data")
        .map((type) => type.split("_")[0]);
    const providerRequirements = Array.from(new Set([...explicitProviders, ...implicitProviders])).reduce((carry, req) => ({ ...carry, [req]: "*" }), {});
    (_a = plan.terraform) === null || _a === void 0 ? void 0 : _a.forEach(({ required_providers }) => (required_providers || []).forEach((providerBlock) => Object.entries(providerBlock).forEach(([key, value]) => {
        let name, version;
        if (typeof value === "string") {
            name = key;
            version = value;
        }
        else {
            name = value.source;
            version = value.version;
        }
        if (!name) {
            return;
        }
        // implicitly only the last part of the path is used (e.g. docker for kreuzwerker/docker)
        const parts = name.split("/");
        if (parts.length > 1) {
            delete providerRequirements[parts.pop() || ""];
        }
        providerRequirements[name] = version || "*";
    })));
    return providerRequirements;
}
exports.getProviderRequirements = getProviderRequirements;
//# sourceMappingURL=data:application/json;base64,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