"use strict";
/**
 * Copyright (c) HashiCorp, Inc.
 * SPDX-License-Identifier: MPL-2.0
 */
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    var desc = Object.getOwnPropertyDescriptor(m, k);
    if (!desc || ("get" in desc ? !m.__esModule : desc.writable || desc.configurable)) {
      desc = { enumerable: true, get: function() { return m[k]; } };
    }
    Object.defineProperty(o, k2, desc);
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.getRequiredAttributes = exports.fillWithConfigAccessors = void 0;
const terraformSchema_1 = require("./terraformSchema");
const t = __importStar(require("@babel/types"));
const utils_1 = require("./utils");
function getConfigFieldName(topLevelConfig, name) {
    const sanitizedName = (0, utils_1.camelCase)(name);
    return deduplicateName(Object.keys(topLevelConfig), sanitizedName);
}
function deduplicateName(existingNames, name) {
    let newName = name;
    let i = 1;
    while (existingNames.includes(newName)) {
        newName = `${name}${i}`;
        i++;
    }
    return newName;
}
function fillWithConfigAccessors(scope, config, path) {
    if (Array.isArray(config)) {
        return config.map((c) => fillWithConfigAccessors(scope, c, `${path}.[]`));
    }
    if (typeof config === "object" && config !== null) {
        const mutated = Object.entries(config).reduce((acc, [key, value]) => ({
            ...acc,
            [key]: fillWithConfigAccessors(scope, value, `${path}.${key}`),
        }), {});
        // Get type of this part of the config
        const attributeType = (0, terraformSchema_1.getTypeAtPath)(scope.providerSchema, path);
        const requiredAttributes = getRequiredAttributes(attributeType);
        // Add accessors for all required attributes that are missing
        requiredAttributes.forEach((key) => {
            const value = mutated[key];
            const isNotDirectlyAccessible = value === undefined;
            const isReplacedByAst = (t.isNode(mutated) && t.isExpression(mutated)) ||
                t.isExpression(value);
            const isEmptyArray = Array.isArray(value) && value.length === 0;
            // If this was already replaced by an AST node, we don't need to do anything
            // We assume all fields are filled in by the AST
            if (isReplacedByAst) {
                return;
            }
            if (isNotDirectlyAccessible || isEmptyArray) {
                const fieldName = getConfigFieldName(scope.topLevelConfig, key);
                mutated[key] = t.memberExpression(t.identifier("config"), t.identifier(fieldName));
                scope.topLevelConfig[fieldName] = `${path}.${key}`;
            }
        });
        return mutated;
    }
    else {
        return config;
    }
}
exports.fillWithConfigAccessors = fillWithConfigAccessors;
function getRequiredAttributes(attributeType) {
    if (!attributeType) {
        return [];
    }
    if (typeof attributeType !== "object" ||
        Array.isArray(attributeType) ||
        attributeType === null ||
        attributeType === undefined ||
        !("block" in attributeType)) {
        return [];
    }
    const requiredAttributes = Object.entries(attributeType.block.attributes || {}).reduce((acc, [key, value]) => (value.required ? [...acc, key] : acc), []);
    // Logic taken from (and should be shared with) provider generator resource parser: attributeForBlockType
    const requiredBlockTypes = Object.entries(attributeType.block.block_types || {}).reduce((acc, [key, value]) => {
        if (value.nesting_mode === "single" &&
            !Object.values(value.block.attributes || {}).some((x) => !x.required)) {
            return [...acc, key];
        }
        if (value.nesting_mode === "map") {
            return acc;
        }
        if ((value.nesting_mode === "list" || value.nesting_mode === "set") &&
            value.min_items === undefined
            ? false
            : value.min_items > 0) {
            return [...acc, key];
        }
        return acc;
    }, []);
    return [...requiredAttributes, ...requiredBlockTypes].sort();
}
exports.getRequiredAttributes = getRequiredAttributes;
//# sourceMappingURL=data:application/json;base64,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