"use strict";
// Copyright (c) HashiCorp, Inc
// SPDX-License-Identifier: MPL-2.0
Object.defineProperty(exports, "__esModule", { value: true });
exports.replaceGoImports = exports.replaceCsharpImports = exports.replaceJavaImports = exports.replacePythonImports = void 0;
function replacePythonImports(code) {
    return code
        .split("\n")
        .map((line) => {
        // Replace from-import lines with lib
        const fromImportLibRegex = /from \.\.\.gen\.providers\.([^.]+)(?:\.lib)?\.(.*) import/;
        if (fromImportLibRegex.test(line)) {
            return line.replace(fromImportLibRegex, "from imports.$1.$2 import");
        }
        // Replace import lines with lib
        const importLibRegex = /import \.\.\.gen\.providers\.([^.]+)(?:\.lib)?\.(.*) as (.*)/;
        if (importLibRegex.test(line)) {
            return line.replace(importLibRegex, "import imports.$1.$2 as $3");
        }
        // Replace from-import lines
        if (line.startsWith("from ...gen.providers.")) {
            return line.replace("from ...gen.providers.", "from imports.");
        }
        // Replace import lines
        if (line.startsWith("import ...gen.providers.")) {
            return line.replace("import ...gen.providers.", "import imports.");
        }
        // Replace modules
        if (line.startsWith("import ...gen.modules.")) {
            return line.replace("import ...gen.modules.", "import imports.");
        }
        return line;
    })
        .join("\n");
}
exports.replacePythonImports = replacePythonImports;
function replaceJavaImports(code) {
    return code
        .split("\n")
        .map((line) => {
        // Replace using lines with lib and precices import
        const importWithLib = /import gen\.providers\.([^.]+)(?:\.lib)?\.([^.]+)\.(.*);/;
        const matchWithLib = line.match(importWithLib);
        if (matchWithLib) {
            const [, provider, resource, className] = matchWithLib;
            return `import imports.${provider}.${resource}.${className};`;
        }
        // Replace using lines
        const importWithoutLib = /import gen\.providers\.([^.]+)\.([^.]+)\.\*;/;
        const matchWithoutLib = line.match(importWithoutLib);
        if (matchWithoutLib) {
            const [, provider, resource] = matchWithoutLib;
            return `import imports.${provider}.${resource}.*;`;
        }
        // Replace using lines
        const importModules = /import gen\.modules\.(.+)\.\*;/;
        const importModulesMatch = line.match(importModules);
        if (importModulesMatch) {
            const [, module] = importModulesMatch;
            return `import imports.${module}.*;`;
        }
        return line;
    })
        .join("\n");
}
exports.replaceJavaImports = replaceJavaImports;
function replaceCsharpImports(code) {
    return code
        .split("\n")
        .map((line) => {
        // Replace using lines with lib
        const fromImportLibRegex = /using Gen\.Providers\.([^.]*)(?:\.Lib)?\.(.*);/;
        const match = line.match(fromImportLibRegex);
        if (match) {
            const [, provider, resource] = match;
            return `using ${lowercaseFirstChar(provider)}.${resource};`;
        }
        // Replace using lines
        if (line.startsWith("using Gen.Providers.")) {
            const importLine = line.replace("using Gen.Providers.", "");
            return `using ${importLine
                .substring(0, 1)
                .toLocaleLowerCase()}${importLine.substring(1)}`;
        }
        if (line.startsWith("using Gen.Modules.")) {
            const importLine = line.replace("using Gen.Modules.", "");
            return `using ${importLine}`;
        }
        return line;
    })
        .join("\n");
}
exports.replaceCsharpImports = replaceCsharpImports;
function replaceGoImports(code) {
    return code
        .split("\n")
        .map((line) => {
        // Replace using lines with lib
        const fromImportLibRegex = /import \"github.com\/aws-samples\/dummy\/gen\/providers\/([^\/]*)(?:\/lib)?\/(.*)\"/;
        const matchLib = line.match(fromImportLibRegex);
        if (matchLib) {
            const [, provider, resource] = matchLib;
            return `import "cdk.tf/go/stack/generated/${provider}/${resource}"`;
        }
        // Replace using lines
        const fromImportRegex = /import \"github.com\/aws-samples\/dummy\/gen\/providers\/([^\/]+)\/(.*)\"/;
        const match = line.match(fromImportRegex);
        if (match) {
            const [, provider, resource] = match;
            return `import "cdk.tf/go/stack/generated/${provider}/${resource}"`;
        }
        const importModulesRegex = /import (.*) \"github.com\/aws-samples\/dummy\/gen\/modules\/(.*)\"/;
        const matchModules = line.match(importModulesRegex);
        if (matchModules) {
            const [, name, module] = matchModules;
            return `import ${name} "cdk.tf/go/stack/generated/${module}"`;
        }
        return line;
    })
        .join("\n");
}
exports.replaceGoImports = replaceGoImports;
function lowercaseFirstChar(str) {
    return str.substring(0, 1).toLocaleLowerCase() + str.substring(1);
}
//# sourceMappingURL=data:application/json;base64,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